/**--------------------------------------------------------------------------**\
					==========================
					 y_colours - X11 colours!
					==========================
Description:
	This holds the colour information that used to be part of the text system
	but which is far more useful than just for text.  This now supports the full
	set of X11 colours, both by name and by definition.  You can also define
	your own if you so choose (up to 32 - should be enough given that this
	includes the X11 colours).
Legal:
	Version: MPL 1.1
	
	The contents of this file are subject to the Mozilla Public License Version 
	1.1 (the "License"); you may not use this file except in compliance with 
	the License. You may obtain a copy of the License at 
	http://www.mozilla.org/MPL/
	
	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	The Original Code is the YSI colours include.
	
	The Initial Developer of the Original Code is Alex "Y_Less" Cole.
	Portions created by the Initial Developer are Copyright (C) 2011
	the Initial Developer. All Rights Reserved.
	
	Contributors:
		ZeeX, koolk, JoeBullet/Google63, g_aSlice/Slice
	
	Thanks:
		JoeBullet/Google63 - Handy arbitrary ASM jump code using SCTRL.
		ZeeX - Very productive conversations.
		koolk - IsPlayerinAreaEx code.
		TheAlpha - Danish translation.
		breadfish - German translation.
		Fireburn - Dutch translation.
		yom - French translation.
		50p - Polish translation.
		Zamaroht - Spanish translation.
		Dracoblue, sintax, mabako, Xtreme, other coders - Producing other modes
			for me to strive to better.
		Pixels^ - Running XScripters where the idea was born.
		Matite - Pestering me to release it and using it.
	
	Very special thanks to:
		Thiadmer - PAWN, whose limits continue to amaze me!
		Kye/Kalcor - SA:MP.
		SA:MP Team past, present and future - SA:MP.
	
Version:
	1.0
Changelog:
	29/11/10:
		Added the ability to use "X11" prefixes in strings.
		Added colourspace resolution for converting {FF0000} to ~r~.
	25/11/10:
		First version.
</remarks>
\**--------------------------------------------------------------------------**/

	#define X11_SNOW                    MK_RGB(255, 250, 250)
	#define X11_GHOSTWHITE              MK_RGB(248, 248, 255)
	#define X11_GHOST_WHITE             MK_RGB(248, 248, 255)
	#define X11_WHITESMOKE              MK_RGB(245, 245, 245)
	#define X11_WHITE_SMOKE             MK_RGB(245, 245, 245)
	#define X11_GAINSBORO               MK_RGB(220, 220, 220)
	#define X11_FLORALWHITE             MK_RGB(255, 250, 240)
	#define X11_FLORAL_WHITE            MK_RGB(255, 250, 240)
	#define X11_OLDLACE                 MK_RGB(253, 245, 230)
	#define X11_OLD_LACE                MK_RGB(253, 245, 230)
	#define X11_LINEN                   MK_RGB(250, 240, 230)
	#define X11_ANTIQUEWHITE            MK_RGB(250, 235, 215)
	#define X11_ANTIQUE_WHITE           MK_RGB(250, 235, 215)
	#define X11_PAPAYAWHIP              MK_RGB(255, 239, 213)
	#define X11_PAPAYA_WHIP             MK_RGB(255, 239, 213)
	#define X11_BLANCHEDALMOND          MK_RGB(255, 235, 205)
	#define X11_BLANCHED_ALMOND         MK_RGB(255, 235, 205)
	#define X11_BISQUE                  MK_RGB(255, 228, 196)
	#define X11_PEACHPUFF               MK_RGB(255, 218, 185)
	#define X11_PEACH_PUFF              MK_RGB(255, 218, 185)
	#define X11_NAVAJOWHITE             MK_RGB(255, 222, 173)
	#define X11_NAVAJO_WHITE            MK_RGB(255, 222, 173)
	#define X11_MOCCASIN                MK_RGB(255, 228, 181)
	#define X11_CORNSILK                MK_RGB(255, 248, 220)
	#define X11_IVORY                   MK_RGB(255, 255, 240)
	#define X11_LEMONCHIFFON            MK_RGB(255, 250, 205)
	#define X11_LEMON_CHIFFON           MK_RGB(255, 250, 205)
	#define X11_SEASHELL                MK_RGB(255, 245, 238)
	#define X11_HONEYDEW                MK_RGB(240, 255, 240)
	#define X11_MINTCREAM               MK_RGB(245, 255, 250)
	#define X11_MINT_CREAM              MK_RGB(245, 255, 250)
	#define X11_AZURE                   MK_RGB(240, 255, 255)
	#define X11_ALICEBLUE               MK_RGB(240, 248, 255)
	#define X11_ALICE_BLUE              MK_RGB(240, 248, 255)
	#define X11_LAVENDER                MK_RGB(230, 230, 250)
	#define X11_LAVENDERBLUSH           MK_RGB(255, 240, 245)
	#define X11_LAVENDER_BLUSH          MK_RGB(255, 240, 245)
	#define X11_MISTYROSE               MK_RGB(255, 228, 225)
	#define X11_MISTY_ROSE              MK_RGB(255, 228, 225)
	#define X11_WHITE                   MK_RGB(255, 255, 255)
	#define X11_BLACK                   MK_RGB(  0,   0,   0)
	#define X11_DARKSLATEGRAY           MK_RGB( 47,  79,  79)
	#define X11_DARK_SLATE_GRAY         MK_RGB( 47,  79,  79)
	#define X11_DARKSLATEGREY           MK_RGB( 47,  79,  79)
	#define X11_DARK_SLATE_GREY         MK_RGB( 47,  79,  79)
	#define X11_DIMGRAY                 MK_RGB(105, 105, 105)
	#define X11_DIM_GRAY                MK_RGB(105, 105, 105)
	#define X11_DIMGREY                 MK_RGB(105, 105, 105)
	#define X11_DIM_GREY                MK_RGB(105, 105, 105)
	#define X11_SLATEGRAY               MK_RGB(112, 128, 144)
	#define X11_SLATE_GRAY              MK_RGB(112, 128, 144)
	#define X11_SLATEGREY               MK_RGB(112, 128, 144)
	#define X11_SLATE_GREY              MK_RGB(112, 128, 144)
	#define X11_LIGHTSLATEGRAY          MK_RGB(119, 136, 153)
	#define X11_LIGHT_SLATE_GRAY        MK_RGB(119, 136, 153)
	#define X11_LIGHTSLATEGREY          MK_RGB(119, 136, 153)
	#define X11_LIGHT_SLATE_GREY        MK_RGB(119, 136, 153)
	#define X11_GRAY                    MK_RGB(190, 190, 190)
	#define X11_GREY                    MK_RGB(190, 190, 190)
	#define X11_LIGHTGREY               MK_RGB(211, 211, 211)
	#define X11_LIGHT_GREY              MK_RGB(211, 211, 211)
	#define X11_LIGHTGRAY               MK_RGB(211, 211, 211)
	#define X11_LIGHT_GRAY              MK_RGB(211, 211, 211)
	#define X11_MIDNIGHTBLUE            MK_RGB( 25,  25, 112)
	#define X11_MIDNIGHT_BLUE           MK_RGB( 25,  25, 112)
	#define X11_NAVY                    MK_RGB(  0,   0, 128)
	#define X11_NAVYBLUE                MK_RGB(  0,   0, 128)
	#define X11_NAVY_BLUE               MK_RGB(  0,   0, 128)
	#define X11_CORNFLOWERBLUE          MK_RGB(100, 149, 237)
	#define X11_CORNFLOWER_BLUE         MK_RGB(100, 149, 237)
	#define X11_DARKSLATEBLUE           MK_RGB( 72,  61, 139)
	#define X11_DARK_SLATE_BLUE         MK_RGB( 72,  61, 139)
	#define X11_SLATEBLUE               MK_RGB(106,  90, 205)
	#define X11_SLATE_BLUE              MK_RGB(106,  90, 205)
	#define X11_MEDIUMSLATEBLUE         MK_RGB(123, 104, 238)
	#define X11_MEDIUM_SLATE_BLUE       MK_RGB(123, 104, 238)
	#define X11_LIGHTSLATEBLUE          MK_RGB(132, 112, 255)
	#define X11_LIGHT_SLATE_BLUE        MK_RGB(132, 112, 255)
	#define X11_MEDIUMBLUE              MK_RGB(  0,   0, 205)
	#define X11_MEDIUM_BLUE             MK_RGB(  0,   0, 205)
	#define X11_ROYALBLUE               MK_RGB( 65, 105, 225)
	#define X11_ROYAL_BLUE              MK_RGB( 65, 105, 225)
	#define X11_BLUE                    MK_RGB(  0,   0, 255)
	#define X11_DODGERBLUE              MK_RGB( 30, 144, 255)
	#define X11_DODGER_BLUE             MK_RGB( 30, 144, 255)
	#define X11_DEEPSKYBLUE             MK_RGB(  0, 191, 255)
	#define X11_DEEP_SKY_BLUE           MK_RGB(  0, 191, 255)
	#define X11_SKYBLUE                 MK_RGB(135, 206, 235)
	#define X11_SKY_BLUE                MK_RGB(135, 206, 235)
	#define X11_LIGHTSKYBLUE            MK_RGB(135, 206, 250)
	#define X11_LIGHT_SKY_BLUE          MK_RGB(135, 206, 250)
	#define X11_STEELBLUE               MK_RGB( 70, 130, 180)
	#define X11_STEEL_BLUE              MK_RGB( 70, 130, 180)
	#define X11_LIGHTSTEELBLUE          MK_RGB(176, 196, 222)
	#define X11_LIGHT_STEEL_BLUE        MK_RGB(176, 196, 222)
	#define X11_LIGHTBLUE               MK_RGB(173, 216, 230)
	#define X11_LIGHT_BLUE              MK_RGB(173, 216, 230)
	#define X11_POWDERBLUE              MK_RGB(176, 224, 230)
	#define X11_POWDER_BLUE             MK_RGB(176, 224, 230)
	#define X11_PALETURQUOISE           MK_RGB(175, 238, 238)
	#define X11_PALE_TURQUOISE          MK_RGB(175, 238, 238)
	#define X11_DARKTURQUOISE           MK_RGB(  0, 206, 209)
	#define X11_DARK_TURQUOISE          MK_RGB(  0, 206, 209)
	#define X11_MEDIUMTURQUOISE         MK_RGB( 72, 209, 204)
	#define X11_MEDIUM_TURQUOISE        MK_RGB( 72, 209, 204)
	#define X11_TURQUOISE               MK_RGB( 64, 224, 208)
	#define X11_CYAN                    MK_RGB(  0, 255, 255)
	#define X11_LIGHTCYAN               MK_RGB(224, 255, 255)
	#define X11_LIGHT_CYAN              MK_RGB(224, 255, 255)
	#define X11_CADETBLUE               MK_RGB( 95, 158, 160)
	#define X11_CADET_BLUE              MK_RGB( 95, 158, 160)
	#define X11_MEDIUMAQUAMARINE        MK_RGB(102, 205, 170)
	#define X11_MEDIUM_AQUAMARINE       MK_RGB(102, 205, 170)
	#define X11_AQUAMARINE              MK_RGB(127, 255, 212)
	#define X11_DARKGREEN               MK_RGB(  0, 100,   0)
	#define X11_DARK_GREEN              MK_RGB(  0, 100,   0)
	#define X11_DARKOLIVEGREEN          MK_RGB( 85, 107,  47)
	#define X11_DARK_OLIVE_GREEN        MK_RGB( 85, 107,  47)
	#define X11_DARKSEAGREEN            MK_RGB(143, 188, 143)
	#define X11_DARK_SEA_GREEN          MK_RGB(143, 188, 143)
	#define X11_SEAGREEN                MK_RGB( 46, 139,  87)
	#define X11_SEA_GREEN               MK_RGB( 46, 139,  87)
	#define X11_MEDIUMSEAGREEN          MK_RGB( 60, 179, 113)
	#define X11_MEDIUM_SEA_GREEN        MK_RGB( 60, 179, 113)
	#define X11_LIGHTSEAGREEN           MK_RGB( 32, 178, 170)
	#define X11_LIGHT_SEA_GREEN         MK_RGB( 32, 178, 170)
	#define X11_PALEGREEN               MK_RGB(152, 251, 152)
	#define X11_PALE_GREEN              MK_RGB(152, 251, 152)
	#define X11_SPRINGGREEN             MK_RGB(  0, 255, 127)
	#define X11_SPRING_GREEN            MK_RGB(  0, 255, 127)
	#define X11_LAWNGREEN               MK_RGB(124, 252,   0)
	#define X11_LAWN_GREEN              MK_RGB(124, 252,   0)
	#define X11_GREEN                   MK_RGB(  0, 255,   0)
	#define X11_CHARTREUSE              MK_RGB(127, 255,   0)
	#define X11_MEDIUMSPRINGGREEN       MK_RGB(  0, 250, 154)
	#define X11_MEDIUM_SPRING_GREEN     MK_RGB(  0, 250, 154)
	#define X11_GREENYELLOW             MK_RGB(173, 255,  47)
	#define X11_GREEN_YELLOW            MK_RGB(173, 255,  47)
	#define X11_LIMEGREEN               MK_RGB( 50, 205,  50)
	#define X11_LIME_GREEN              MK_RGB( 50, 205,  50)
	#define X11_YELLOWGREEN             MK_RGB(154, 205,  50)
	#define X11_YELLOW_GREEN            MK_RGB(154, 205,  50)
	#define X11_FORESTGREEN             MK_RGB( 34, 139,  34)
	#define X11_FOREST_GREEN            MK_RGB( 34, 139,  34)
	#define X11_OLIVEDRAB               MK_RGB(107, 142,  35)
	#define X11_OLIVE_DRAB              MK_RGB(107, 142,  35)
	#define X11_DARKKHAKI               MK_RGB(189, 183, 107)
	#define X11_DARK_KHAKI              MK_RGB(189, 183, 107)
	#define X11_KHAKI                   MK_RGB(240, 230, 140)
	#define X11_PALEGOLDENROD           MK_RGB(238, 232, 170)
	#define X11_PALE_GOLDENROD          MK_RGB(238, 232, 170)
	#define X11_LIGHTGOLDENRODYELLOW    MK_RGB(250, 250, 210)
	#define X11_LIGHT_GOLDENROD_YELLOW  MK_RGB(250, 250, 210)
	#define X11_LIGHTYELLOW             MK_RGB(255, 255, 224)
	#define X11_LIGHT_YELLOW            MK_RGB(255, 255, 224)
	#define X11_YELLOW                  MK_RGB(255, 255,   0)
	#define X11_GOLD                    MK_RGB(255, 215,   0)
	#define X11_LIGHTGOLDENROD          MK_RGB(238, 221, 130)
	#define X11_LIGHT_GOLDENROD         MK_RGB(238, 221, 130)
	#define X11_GOLDENROD               MK_RGB(218, 165,  32)
	#define X11_DARKGOLDENROD           MK_RGB(184, 134,  11)
	#define X11_DARK_GOLDENROD          MK_RGB(184, 134,  11)
	#define X11_ROSYBROWN               MK_RGB(188, 143, 143)
	#define X11_ROSY_BROWN              MK_RGB(188, 143, 143)
	#define X11_INDIANRED               MK_RGB(205,  92,  92)
	#define X11_INDIAN_RED              MK_RGB(205,  92,  92)
	#define X11_SADDLEBROWN             MK_RGB(139,  69,  19)
	#define X11_SADDLE_BROWN            MK_RGB(139,  69,  19)
	#define X11_SIENNA                  MK_RGB(160,  82,  45)
	#define X11_PERU                    MK_RGB(205, 133,  63)
	#define X11_BURLYWOOD               MK_RGB(222, 184, 135)
	#define X11_BEIGE                   MK_RGB(245, 245, 220)
	#define X11_WHEAT                   MK_RGB(245, 222, 179)
	#define X11_SANDYBROWN              MK_RGB(244, 164,  96)
	#define X11_SANDY_BROWN             MK_RGB(244, 164,  96)
	#define X11_TAN                     MK_RGB(210, 180, 140)
	#define X11_CHOCOLATE               MK_RGB(210, 105,  30)
	#define X11_FIREBRICK               MK_RGB(178,  34,  34)
	#define X11_BROWN                   MK_RGB(165,  42,  42)
	#define X11_DARKSALMON              MK_RGB(233, 150, 122)
	#define X11_DARK_SALMON             MK_RGB(233, 150, 122)
	#define X11_SALMON                  MK_RGB(250, 128, 114)
	#define X11_LIGHTSALMON             MK_RGB(255, 160, 122)
	#define X11_LIGHT_SALMON            MK_RGB(255, 160, 122)
	#define X11_ORANGE                  MK_RGB(255, 165,   0)
	#define X11_DARKORANGE              MK_RGB(255, 140,   0)
	#define X11_DARK_ORANGE             MK_RGB(255, 140,   0)
	#define X11_CORAL                   MK_RGB(255, 127,  80)
	#define X11_LIGHTCORAL              MK_RGB(240, 128, 128)
	#define X11_LIGHT_CORAL             MK_RGB(240, 128, 128)
	#define X11_TOMATO                  MK_RGB(255,  99,  71)
	#define X11_ORANGERED               MK_RGB(255,  69,   0)
	#define X11_ORANGE_RED              MK_RGB(255,  69,   0)
	#define X11_RED                     MK_RGB(255,   0,   0)
	#define X11_HOTPINK                 MK_RGB(255, 105, 180)
	#define X11_HOT_PINK                MK_RGB(255, 105, 180)
	#define X11_DEEPPINK                MK_RGB(255,  20, 147)
	#define X11_DEEP_PINK               MK_RGB(255,  20, 147)
	#define X11_PINK                    MK_RGB(255, 192, 203)
	#define X11_LIGHTPINK               MK_RGB(255, 182, 193)
	#define X11_LIGHT_PINK              MK_RGB(255, 182, 193)
	#define X11_PALEVIOLETRED           MK_RGB(219, 112, 147)
	#define X11_PALE_VIOLET_RED         MK_RGB(219, 112, 147)
	#define X11_MAROON                  MK_RGB(176,  48,  96)
	#define X11_MEDIUMVIOLETRED         MK_RGB(199,  21, 133)
	#define X11_MEDIUM_VIOLET_RED       MK_RGB(199,  21, 133)
	#define X11_VIOLETRED               MK_RGB(208,  32, 144)
	#define X11_VIOLET_RED              MK_RGB(208,  32, 144)
	#define X11_MAGENTA                 MK_RGB(255,   0, 255)
	#define X11_VIOLET                  MK_RGB(238, 130, 238)
	#define X11_PLUM                    MK_RGB(221, 160, 221)
	#define X11_ORCHID                  MK_RGB(218, 112, 214)
	#define X11_MEDIUMORCHID            MK_RGB(186,  85, 211)
	#define X11_MEDIUM_ORCHID           MK_RGB(186,  85, 211)
	#define X11_DARKORCHID              MK_RGB(153,  50, 204)
	#define X11_DARK_ORCHID             MK_RGB(153,  50, 204)
	#define X11_DARKVIOLET              MK_RGB(148,   0, 211)
	#define X11_DARK_VIOLET             MK_RGB(148,   0, 211)
	#define X11_BLUEVIOLET              MK_RGB(138,  43, 226)
	#define X11_BLUE_VIOLET             MK_RGB(138,  43, 226)
	#define X11_PURPLE                  MK_RGB(160,  32, 240)
	#define X11_MEDIUMPURPLE            MK_RGB(147, 112, 219)
	#define X11_MEDIUM_PURPLE           MK_RGB(147, 112, 219)
	#define X11_THISTLE                 MK_RGB(216, 191, 216)
	#define X11_SNOW1                   MK_RGB(255, 250, 250)
	#define X11_SNOW_1                  MK_RGB(255, 250, 250)
	#define X11_SNOW2                   MK_RGB(238, 233, 233)
	#define X11_SNOW_2                  MK_RGB(238, 233, 233)
	#define X11_SNOW3                   MK_RGB(205, 201, 201)
	#define X11_SNOW_3                  MK_RGB(205, 201, 201)
	#define X11_SNOW4                   MK_RGB(139, 137, 137)
	#define X11_SNOW_4                  MK_RGB(139, 137, 137)
	#define X11_SEASHELL1               MK_RGB(255, 245, 238)
	#define X11_SEASHELL_1              MK_RGB(255, 245, 238)
	#define X11_SEASHELL2               MK_RGB(238, 229, 222)
	#define X11_SEASHELL_2              MK_RGB(238, 229, 222)
	#define X11_SEASHELL3               MK_RGB(205, 197, 191)
	#define X11_SEASHELL_3              MK_RGB(205, 197, 191)
	#define X11_SEASHELL4               MK_RGB(139, 134, 130)
	#define X11_SEASHELL_4              MK_RGB(139, 134, 130)
	#define X11_ANTIQUEWHITE1           MK_RGB(255, 239, 219)
	#define X11_ANTIQUE_WHITE_1         MK_RGB(255, 239, 219)
	#define X11_ANTIQUEWHITE2           MK_RGB(238, 223, 204)
	#define X11_ANTIQUE_WHITE_2         MK_RGB(238, 223, 204)
	#define X11_ANTIQUEWHITE3           MK_RGB(205, 192, 176)
	#define X11_ANTIQUE_WHITE_3         MK_RGB(205, 192, 176)
	#define X11_ANTIQUEWHITE4           MK_RGB(139, 131, 120)
	#define X11_ANTIQUE_WHITE_4         MK_RGB(139, 131, 120)
	#define X11_BISQUE1                 MK_RGB(255, 228, 196)
	#define X11_BISQUE_1                MK_RGB(255, 228, 196)
	#define X11_BISQUE2                 MK_RGB(238, 213, 183)
	#define X11_BISQUE_2                MK_RGB(238, 213, 183)
	#define X11_BISQUE3                 MK_RGB(205, 183, 158)
	#define X11_BISQUE_3                MK_RGB(205, 183, 158)
	#define X11_BISQUE4                 MK_RGB(139, 125, 107)
	#define X11_BISQUE_4                MK_RGB(139, 125, 107)
	#define X11_PEACHPUFF1              MK_RGB(255, 218, 185)
	#define X11_PEACH_PUFF_1            MK_RGB(255, 218, 185)
	#define X11_PEACHPUFF2              MK_RGB(238, 203, 173)
	#define X11_PEACH_PUFF_2            MK_RGB(238, 203, 173)
	#define X11_PEACHPUFF3              MK_RGB(205, 175, 149)
	#define X11_PEACH_PUFF_3            MK_RGB(205, 175, 149)
	#define X11_PEACHPUFF4              MK_RGB(139, 119, 101)
	#define X11_PEACH_PUFF_4            MK_RGB(139, 119, 101)
	#define X11_NAVAJOWHITE1            MK_RGB(255, 222, 173)
	#define X11_NAVAJO_WHITE_1          MK_RGB(255, 222, 173)
	#define X11_NAVAJOWHITE2            MK_RGB(238, 207, 161)
	#define X11_NAVAJO_WHITE_2          MK_RGB(238, 207, 161)
	#define X11_NAVAJOWHITE3            MK_RGB(205, 179, 139)
	#define X11_NAVAJO_WHITE_3          MK_RGB(205, 179, 139)
	#define X11_NAVAJOWHITE4            MK_RGB(139, 121,  94)
	#define X11_NAVAJO_WHITE_4          MK_RGB(139, 121,  94)
	#define X11_LEMONCHIFFON1           MK_RGB(255, 250, 205)
	#define X11_LEMON_CHIFFON_1         MK_RGB(255, 250, 205)
	#define X11_LEMONCHIFFON2           MK_RGB(238, 233, 191)
	#define X11_LEMON_CHIFFON_2         MK_RGB(238, 233, 191)
	#define X11_LEMONCHIFFON3           MK_RGB(205, 201, 165)
	#define X11_LEMON_CHIFFON_3         MK_RGB(205, 201, 165)
	#define X11_LEMONCHIFFON4           MK_RGB(139, 137, 112)
	#define X11_LEMON_CHIFFON_4         MK_RGB(139, 137, 112)
	#define X11_CORNSILK1               MK_RGB(255, 248, 220)
	#define X11_CORNSILK_1              MK_RGB(255, 248, 220)
	#define X11_CORNSILK2               MK_RGB(238, 232, 205)
	#define X11_CORNSILK_2              MK_RGB(238, 232, 205)
	#define X11_CORNSILK3               MK_RGB(205, 200, 177)
	#define X11_CORNSILK_3              MK_RGB(205, 200, 177)
	#define X11_CORNSILK4               MK_RGB(139, 136, 120)
	#define X11_CORNSILK_4              MK_RGB(139, 136, 120)
	#define X11_IVORY1                  MK_RGB(255, 255, 240)
	#define X11_IVORY_1                 MK_RGB(255, 255, 240)
	#define X11_IVORY2                  MK_RGB(238, 238, 224)
	#define X11_IVORY_2                 MK_RGB(238, 238, 224)
	#define X11_IVORY3                  MK_RGB(205, 205, 193)
	#define X11_IVORY_3                 MK_RGB(205, 205, 193)
	#define X11_IVORY4                  MK_RGB(139, 139, 131)
	#define X11_IVORY_4                 MK_RGB(139, 139, 131)
	#define X11_HONEYDEW1               MK_RGB(240, 255, 240)
	#define X11_HONEYDEW_1              MK_RGB(240, 255, 240)
	#define X11_HONEYDEW2               MK_RGB(224, 238, 224)
	#define X11_HONEYDEW_2              MK_RGB(224, 238, 224)
	#define X11_HONEYDEW3               MK_RGB(193, 205, 193)
	#define X11_HONEYDEW_3              MK_RGB(193, 205, 193)
	#define X11_HONEYDEW4               MK_RGB(131, 139, 131)
	#define X11_HONEYDEW_4              MK_RGB(131, 139, 131)
	#define X11_LAVENDERBLUSH1          MK_RGB(255, 240, 245)
	#define X11_LAVENDER_BLUSH_1        MK_RGB(255, 240, 245)
	#define X11_LAVENDERBLUSH2          MK_RGB(238, 224, 229)
	#define X11_LAVENDER_BLUSH_2        MK_RGB(238, 224, 229)
	#define X11_LAVENDERBLUSH3          MK_RGB(205, 193, 197)
	#define X11_LAVENDER_BLUSH_3        MK_RGB(205, 193, 197)
	#define X11_LAVENDERBLUSH4          MK_RGB(139, 131, 134)
	#define X11_LAVENDER_BLUSH_4        MK_RGB(139, 131, 134)
	#define X11_MISTYROSE1              MK_RGB(255, 228, 225)
	#define X11_MISTY_ROSE_1            MK_RGB(255, 228, 225)
	#define X11_MISTYROSE2              MK_RGB(238, 213, 210)
	#define X11_MISTY_ROSE_2            MK_RGB(238, 213, 210)
	#define X11_MISTYROSE3              MK_RGB(205, 183, 181)
	#define X11_MISTY_ROSE_3            MK_RGB(205, 183, 181)
	#define X11_MISTYROSE4              MK_RGB(139, 125, 123)
	#define X11_MISTY_ROSE_4            MK_RGB(139, 125, 123)
	#define X11_AZURE1                  MK_RGB(240, 255, 255)
	#define X11_AZURE_1                 MK_RGB(240, 255, 255)
	#define X11_AZURE2                  MK_RGB(224, 238, 238)
	#define X11_AZURE_2                 MK_RGB(224, 238, 238)
	#define X11_AZURE3                  MK_RGB(193, 205, 205)
	#define X11_AZURE_3                 MK_RGB(193, 205, 205)
	#define X11_AZURE4                  MK_RGB(131, 139, 139)
	#define X11_AZURE_4                 MK_RGB(131, 139, 139)
	#define X11_SLATEBLUE1              MK_RGB(131, 111, 255)
	#define X11_SLATE_BLUE_1            MK_RGB(131, 111, 255)
	#define X11_SLATEBLUE2              MK_RGB(122, 103, 238)
	#define X11_SLATE_BLUE_2            MK_RGB(122, 103, 238)
	#define X11_SLATEBLUE3              MK_RGB(105,  89, 205)
	#define X11_SLATE_BLUE_3            MK_RGB(105,  89, 205)
	#define X11_SLATEBLUE4              MK_RGB( 71,  60, 139)
	#define X11_SLATE_BLUE_4            MK_RGB( 71,  60, 139)
	#define X11_ROYALBLUE1              MK_RGB( 72, 118, 255)
	#define X11_ROYAL_BLUE_1            MK_RGB( 72, 118, 255)
	#define X11_ROYALBLUE2              MK_RGB( 67, 110, 238)
	#define X11_ROYAL_BLUE_2            MK_RGB( 67, 110, 238)
	#define X11_ROYALBLUE3              MK_RGB( 58,  95, 205)
	#define X11_ROYAL_BLUE_3            MK_RGB( 58,  95, 205)
	#define X11_ROYALBLUE4              MK_RGB( 39,  64, 139)
	#define X11_ROYAL_BLUE_4            MK_RGB( 39,  64, 139)
	#define X11_BLUE1                   MK_RGB(  0,   0, 255)
	#define X11_BLUE_1                  MK_RGB(  0,   0, 255)
	#define X11_BLUE2                   MK_RGB(  0,   0, 238)
	#define X11_BLUE_2                  MK_RGB(  0,   0, 238)
	#define X11_BLUE3                   MK_RGB(  0,   0, 205)
	#define X11_BLUE_3                  MK_RGB(  0,   0, 205)
	#define X11_BLUE4                   MK_RGB(  0,   0, 139)
	#define X11_BLUE_4                  MK_RGB(  0,   0, 139)
	#define X11_DODGERBLUE1             MK_RGB( 30, 144, 255)
	#define X11_DODGER_BLUE_1           MK_RGB( 30, 144, 255)
	#define X11_DODGERBLUE2             MK_RGB( 28, 134, 238)
	#define X11_DODGER_BLUE_2           MK_RGB( 28, 134, 238)
	#define X11_DODGERBLUE3             MK_RGB( 24, 116, 205)
	#define X11_DODGER_BLUE_3           MK_RGB( 24, 116, 205)
	#define X11_DODGERBLUE4             MK_RGB( 16,  78, 139)
	#define X11_DODGER_BLUE_4           MK_RGB( 16,  78, 139)
	#define X11_STEELBLUE1              MK_RGB( 99, 184, 255)
	#define X11_STEEL_BLUE_1            MK_RGB( 99, 184, 255)
	#define X11_STEELBLUE2              MK_RGB( 92, 172, 238)
	#define X11_STEEL_BLUE_2            MK_RGB( 92, 172, 238)
	#define X11_STEELBLUE3              MK_RGB( 79, 148, 205)
	#define X11_STEEL_BLUE_3            MK_RGB( 79, 148, 205)
	#define X11_STEELBLUE4              MK_RGB( 54, 100, 139)
	#define X11_STEEL_BLUE_4            MK_RGB( 54, 100, 139)
	#define X11_DEEPSKYBLUE1            MK_RGB(  0, 191, 255)
	#define X11_DEEP_SKY_BLUE_1         MK_RGB(  0, 191, 255)
	#define X11_DEEPSKYBLUE2            MK_RGB(  0, 178, 238)
	#define X11_DEEP_SKY_BLUE_2         MK_RGB(  0, 178, 238)
	#define X11_DEEPSKYBLUE3            MK_RGB(  0, 154, 205)
	#define X11_DEEP_SKY_BLUE_3         MK_RGB(  0, 154, 205)
	#define X11_DEEPSKYBLUE4            MK_RGB(  0, 104, 139)
	#define X11_DEEP_SKY_BLUE_4         MK_RGB(  0, 104, 139)
	#define X11_SKYBLUE1                MK_RGB(135, 206, 255)
	#define X11_SKY_BLUE_1              MK_RGB(135, 206, 255)
	#define X11_SKYBLUE2                MK_RGB(126, 192, 238)
	#define X11_SKY_BLUE_2              MK_RGB(126, 192, 238)
	#define X11_SKYBLUE3                MK_RGB(108, 166, 205)
	#define X11_SKY_BLUE_3              MK_RGB(108, 166, 205)
	#define X11_SKYBLUE4                MK_RGB( 74, 112, 139)
	#define X11_SKY_BLUE_4              MK_RGB( 74, 112, 139)
	#define X11_LIGHTSKYBLUE1           MK_RGB(176, 226, 255)
	#define X11_LIGHT_SKY_BLUE_1        MK_RGB(176, 226, 255)
	#define X11_LIGHTSKYBLUE2           MK_RGB(164, 211, 238)
	#define X11_LIGHT_SKY_BLUE_2        MK_RGB(164, 211, 238)
	#define X11_LIGHTSKYBLUE3           MK_RGB(141, 182, 205)
	#define X11_LIGHT_SKY_BLUE_3        MK_RGB(141, 182, 205)
	#define X11_LIGHTSKYBLUE4           MK_RGB( 96, 123, 139)
	#define X11_LIGHT_SKY_BLUE_4        MK_RGB( 96, 123, 139)
	#define X11_SLATEGRAY1              MK_RGB(198, 226, 255)
	#define X11_SLATE_GRAY_1            MK_RGB(198, 226, 255)
	#define X11_SLATEGRAY2              MK_RGB(185, 211, 238)
	#define X11_SLATE_GRAY_2            MK_RGB(185, 211, 238)
	#define X11_SLATEGRAY3              MK_RGB(159, 182, 205)
	#define X11_SLATE_GRAY_3            MK_RGB(159, 182, 205)
	#define X11_SLATEGRAY4              MK_RGB(108, 123, 139)
	#define X11_SLATE_GRAY_4            MK_RGB(108, 123, 139)
	#define X11_SLATEGREY1              MK_RGB(198, 226, 255)
	#define X11_SLATE_GREY_1            MK_RGB(198, 226, 255)
	#define X11_SLATEGREY2              MK_RGB(185, 211, 238)
	#define X11_SLATE_GREY_2            MK_RGB(185, 211, 238)
	#define X11_SLATEGREY3              MK_RGB(159, 182, 205)
	#define X11_SLATE_GREY_3            MK_RGB(159, 182, 205)
	#define X11_SLATEGREY4              MK_RGB(108, 123, 139)
	#define X11_SLATE_GREY_4            MK_RGB(108, 123, 139)
	#define X11_LIGHTSTEELBLUE1         MK_RGB(202, 225, 255)
	#define X11_LIGHT_STEEL_BLUE_1      MK_RGB(202, 225, 255)
	#define X11_LIGHTSTEELBLUE2         MK_RGB(188, 210, 238)
	#define X11_LIGHT_STEEL_BLUE_2      MK_RGB(188, 210, 238)
	#define X11_LIGHTSTEELBLUE3         MK_RGB(162, 181, 205)
	#define X11_LIGHT_STEEL_BLUE_3      MK_RGB(162, 181, 205)
	#define X11_LIGHTSTEELBLUE4         MK_RGB(110, 123, 139)
	#define X11_LIGHT_STEEL_BLUE_4      MK_RGB(110, 123, 139)
	#define X11_LIGHTBLUE1              MK_RGB(191, 239, 255)
	#define X11_LIGHT_BLUE_1            MK_RGB(191, 239, 255)
	#define X11_LIGHTBLUE2              MK_RGB(178, 223, 238)
	#define X11_LIGHT_BLUE_2            MK_RGB(178, 223, 238)
	#define X11_LIGHTBLUE3              MK_RGB(154, 192, 205)
	#define X11_LIGHT_BLUE_3            MK_RGB(154, 192, 205)
	#define X11_LIGHTBLUE4              MK_RGB(104, 131, 139)
	#define X11_LIGHT_BLUE_4            MK_RGB(104, 131, 139)
	#define X11_LIGHTCYAN1              MK_RGB(224, 255, 255)
	#define X11_LIGHT_CYAN_1            MK_RGB(224, 255, 255)
	#define X11_LIGHTCYAN2              MK_RGB(209, 238, 238)
	#define X11_LIGHT_CYAN_2            MK_RGB(209, 238, 238)
	#define X11_LIGHTCYAN3              MK_RGB(180, 205, 205)
	#define X11_LIGHT_CYAN_3            MK_RGB(180, 205, 205)
	#define X11_LIGHTCYAN4              MK_RGB(122, 139, 139)
	#define X11_LIGHT_CYAN_4            MK_RGB(122, 139, 139)
	#define X11_PALETURQUOISE1          MK_RGB(187, 255, 255)
	#define X11_PALE_TURQUOISE_1        MK_RGB(187, 255, 255)
	#define X11_PALETURQUOISE2          MK_RGB(174, 238, 238)
	#define X11_PALE_TURQUOISE_2        MK_RGB(174, 238, 238)
	#define X11_PALETURQUOISE3          MK_RGB(150, 205, 205)
	#define X11_PALE_TURQUOISE_3        MK_RGB(150, 205, 205)
	#define X11_PALETURQUOISE4          MK_RGB(102, 139, 139)
	#define X11_PALE_TURQUOISE_4        MK_RGB(102, 139, 139)
	#define X11_CADETBLUE1              MK_RGB(152, 245, 255)
	#define X11_CADET_BLUE_1            MK_RGB(152, 245, 255)
	#define X11_CADETBLUE2              MK_RGB(142, 229, 238)
	#define X11_CADET_BLUE_2            MK_RGB(142, 229, 238)
	#define X11_CADETBLUE3              MK_RGB(122, 197, 205)
	#define X11_CADET_BLUE_3            MK_RGB(122, 197, 205)
	#define X11_CADETBLUE4              MK_RGB( 83, 134, 139)
	#define X11_CADET_BLUE_4            MK_RGB( 83, 134, 139)
	#define X11_TURQUOISE1              MK_RGB(  0, 245, 255)
	#define X11_TURQUOISE_1             MK_RGB(  0, 245, 255)
	#define X11_TURQUOISE2              MK_RGB(  0, 229, 238)
	#define X11_TURQUOISE_2             MK_RGB(  0, 229, 238)
	#define X11_TURQUOISE3              MK_RGB(  0, 197, 205)
	#define X11_TURQUOISE_3             MK_RGB(  0, 197, 205)
	#define X11_TURQUOISE4              MK_RGB(  0, 134, 139)
	#define X11_TURQUOISE_4             MK_RGB(  0, 134, 139)
	#define X11_CYAN1                   MK_RGB(  0, 255, 255)
	#define X11_CYAN_1                  MK_RGB(  0, 255, 255)
	#define X11_CYAN2                   MK_RGB(  0, 238, 238)
	#define X11_CYAN_2                  MK_RGB(  0, 238, 238)
	#define X11_CYAN3                   MK_RGB(  0, 205, 205)
	#define X11_CYAN_3                  MK_RGB(  0, 205, 205)
	#define X11_CYAN4                   MK_RGB(  0, 139, 139)
	#define X11_CYAN_4                  MK_RGB(  0, 139, 139)
	#define X11_DARKSLATEGRAY1          MK_RGB(151, 255, 255)
	#define X11_DARK_SLATE_GRAY_1       MK_RGB(151, 255, 255)
	#define X11_DARKSLATEGRAY2          MK_RGB(141, 238, 238)
	#define X11_DARK_SLATE_GRAY_2       MK_RGB(141, 238, 238)
	#define X11_DARKSLATEGRAY3          MK_RGB(121, 205, 205)
	#define X11_DARK_SLATE_GRAY_3       MK_RGB(121, 205, 205)
	#define X11_DARKSLATEGRAY4          MK_RGB( 82, 139, 139)
	#define X11_DARK_SLATE_GRAY_4       MK_RGB( 82, 139, 139)
	#define X11_DARKSLATEGREY1          MK_RGB(151, 255, 255)
	#define X11_DARK_SLATE_GREY_1       MK_RGB(151, 255, 255)
	#define X11_DARKSLATEGREY2          MK_RGB(141, 238, 238)
	#define X11_DARK_SLATE_GREY_2       MK_RGB(141, 238, 238)
	#define X11_DARKSLATEGREY3          MK_RGB(121, 205, 205)
	#define X11_DARK_SLATE_GREY_3       MK_RGB(121, 205, 205)
	#define X11_DARKSLATEGREY4          MK_RGB( 82, 139, 139)
	#define X11_DARK_SLATE_GREY_4       MK_RGB( 82, 139, 139)
	#define X11_AQUAMARINE1             MK_RGB(127, 255, 212)
	#define X11_AQUAMARINE_1            MK_RGB(127, 255, 212)
	#define X11_AQUAMARINE2             MK_RGB(118, 238, 198)
	#define X11_AQUAMARINE_2            MK_RGB(118, 238, 198)
	#define X11_AQUAMARINE3             MK_RGB(102, 205, 170)
	#define X11_AQUAMARINE_3            MK_RGB(102, 205, 170)
	#define X11_AQUAMARINE4             MK_RGB( 69, 139, 116)
	#define X11_AQUAMARINE_4            MK_RGB( 69, 139, 116)
	#define X11_DARKSEAGREEN1           MK_RGB(193, 255, 193)
	#define X11_DARK_SEA_GREEN_1        MK_RGB(193, 255, 193)
	#define X11_DARKSEAGREEN2           MK_RGB(180, 238, 180)
	#define X11_DARK_SEA_GREEN_2        MK_RGB(180, 238, 180)
	#define X11_DARKSEAGREEN3           MK_RGB(155, 205, 155)
	#define X11_DARK_SEA_GREEN_3        MK_RGB(155, 205, 155)
	#define X11_DARKSEAGREEN4           MK_RGB(105, 139, 105)
	#define X11_DARK_SEA_GREEN_4        MK_RGB(105, 139, 105)
	#define X11_SEAGREEN1               MK_RGB( 84, 255, 159)
	#define X11_SEA_GREEN_1             MK_RGB( 84, 255, 159)
	#define X11_SEAGREEN2               MK_RGB( 78, 238, 148)
	#define X11_SEA_GREEN_2             MK_RGB( 78, 238, 148)
	#define X11_SEAGREEN3               MK_RGB( 67, 205, 128)
	#define X11_SEA_GREEN_3             MK_RGB( 67, 205, 128)
	#define X11_SEAGREEN4               MK_RGB( 46, 139,  87)
	#define X11_SEA_GREEN_4             MK_RGB( 46, 139,  87)
	#define X11_PALEGREEN1              MK_RGB(154, 255, 154)
	#define X11_PALE_GREEN_1            MK_RGB(154, 255, 154)
	#define X11_PALEGREEN2              MK_RGB(144, 238, 144)
	#define X11_PALE_GREEN_2            MK_RGB(144, 238, 144)
	#define X11_PALEGREEN3              MK_RGB(124, 205, 124)
	#define X11_PALE_GREEN_3            MK_RGB(124, 205, 124)
	#define X11_PALEGREEN4              MK_RGB( 84, 139,  84)
	#define X11_PALE_GREEN_4            MK_RGB( 84, 139,  84)
	#define X11_SPRINGGREEN1            MK_RGB(  0, 255, 127)
	#define X11_SPRING_GREEN_1          MK_RGB(  0, 255, 127)
	#define X11_SPRINGGREEN2            MK_RGB(  0, 238, 118)
	#define X11_SPRING_GREEN_2          MK_RGB(  0, 238, 118)
	#define X11_SPRINGGREEN3            MK_RGB(  0, 205, 102)
	#define X11_SPRING_GREEN_3          MK_RGB(  0, 205, 102)
	#define X11_SPRINGGREEN4            MK_RGB(  0, 139,  69)
	#define X11_SPRING_GREEN_4          MK_RGB(  0, 139,  69)
	#define X11_GREEN1                  MK_RGB(  0, 255,   0)
	#define X11_GREEN_1                 MK_RGB(  0, 255,   0)
	#define X11_GREEN2                  MK_RGB(  0, 238,   0)
	#define X11_GREEN_2                 MK_RGB(  0, 238,   0)
	#define X11_GREEN3                  MK_RGB(  0, 205,   0)
	#define X11_GREEN_3                 MK_RGB(  0, 205,   0)
	#define X11_GREEN4                  MK_RGB(  0, 139,   0)
	#define X11_GREEN_4                 MK_RGB(  0, 139,   0)
	#define X11_CHARTREUSE1             MK_RGB(127, 255,   0)
	#define X11_CHARTREUSE_1            MK_RGB(127, 255,   0)
	#define X11_CHARTREUSE2             MK_RGB(118, 238,   0)
	#define X11_CHARTREUSE_2            MK_RGB(118, 238,   0)
	#define X11_CHARTREUSE3             MK_RGB(102, 205,   0)
	#define X11_CHARTREUSE_3            MK_RGB(102, 205,   0)
	#define X11_CHARTREUSE4             MK_RGB( 69, 139,   0)
	#define X11_CHARTREUSE_4            MK_RGB( 69, 139,   0)
	#define X11_OLIVEDRAB1              MK_RGB(192, 255,  62)
	#define X11_OLIVE_DRAB_1            MK_RGB(192, 255,  62)
	#define X11_OLIVEDRAB2              MK_RGB(179, 238,  58)
	#define X11_OLIVE_DRAB_2            MK_RGB(179, 238,  58)
	#define X11_OLIVEDRAB3              MK_RGB(154, 205,  50)
	#define X11_OLIVE_DRAB_3            MK_RGB(154, 205,  50)
	#define X11_OLIVEDRAB4              MK_RGB(105, 139,  34)
	#define X11_OLIVE_DRAB_4            MK_RGB(105, 139,  34)
	#define X11_DARKOLIVEGREEN1         MK_RGB(202, 255, 112)
	#define X11_DARK_OLIVE_GREEN_1      MK_RGB(202, 255, 112)
	#define X11_DARKOLIVEGREEN2         MK_RGB(188, 238, 104)
	#define X11_DARK_OLIVE_GREEN_2      MK_RGB(188, 238, 104)
	#define X11_DARKOLIVEGREEN3         MK_RGB(162, 205,  90)
	#define X11_DARK_OLIVE_GREEN_3      MK_RGB(162, 205,  90)
	#define X11_DARKOLIVEGREEN4         MK_RGB(110, 139,  61)
	#define X11_DARK_OLIVE_GREEN_4      MK_RGB(110, 139,  61)
	#define X11_KHAKI1                  MK_RGB(255, 246, 143)
	#define X11_KHAKI_1                 MK_RGB(255, 246, 143)
	#define X11_KHAKI2                  MK_RGB(238, 230, 133)
	#define X11_KHAKI_2                 MK_RGB(238, 230, 133)
	#define X11_KHAKI3                  MK_RGB(205, 198, 115)
	#define X11_KHAKI_3                 MK_RGB(205, 198, 115)
	#define X11_KHAKI4                  MK_RGB(139, 134,  78)
	#define X11_KHAKI_4                 MK_RGB(139, 134,  78)
	#define X11_LIGHTGOLDENROD1         MK_RGB(255, 236, 139)
	#define X11_LIGHT_GOLDENROD_1       MK_RGB(255, 236, 139)
	#define X11_LIGHTGOLDENROD2         MK_RGB(238, 220, 130)
	#define X11_LIGHT_GOLDENROD_2       MK_RGB(238, 220, 130)
	#define X11_LIGHTGOLDENROD3         MK_RGB(205, 190, 112)
	#define X11_LIGHT_GOLDENROD_3       MK_RGB(205, 190, 112)
	#define X11_LIGHTGOLDENROD4         MK_RGB(139, 129,  76)
	#define X11_LIGHT_GOLDENROD_4       MK_RGB(139, 129,  76)
	#define X11_LIGHTYELLOW1            MK_RGB(255, 255, 224)
	#define X11_LIGHT_YELLOW_1          MK_RGB(255, 255, 224)
	#define X11_LIGHTYELLOW2            MK_RGB(238, 238, 209)
	#define X11_LIGHT_YELLOW_2          MK_RGB(238, 238, 209)
	#define X11_LIGHTYELLOW3            MK_RGB(205, 205, 180)
	#define X11_LIGHT_YELLOW_3          MK_RGB(205, 205, 180)
	#define X11_LIGHTYELLOW4            MK_RGB(139, 139, 122)
	#define X11_LIGHT_YELLOW_4          MK_RGB(139, 139, 122)
	#define X11_YELLOW1                 MK_RGB(255, 255,   0)
	#define X11_YELLOW_1                MK_RGB(255, 255,   0)
	#define X11_YELLOW2                 MK_RGB(238, 238,   0)
	#define X11_YELLOW_2                MK_RGB(238, 238,   0)
	#define X11_YELLOW3                 MK_RGB(205, 205,   0)
	#define X11_YELLOW_3                MK_RGB(205, 205,   0)
	#define X11_YELLOW4                 MK_RGB(139, 139,   0)
	#define X11_YELLOW_4                MK_RGB(139, 139,   0)
	#define X11_GOLD1                   MK_RGB(255, 215,   0)
	#define X11_GOLD_1                  MK_RGB(255, 215,   0)
	#define X11_GOLD2                   MK_RGB(238, 201,   0)
	#define X11_GOLD_2                  MK_RGB(238, 201,   0)
	#define X11_GOLD3                   MK_RGB(205, 173,   0)
	#define X11_GOLD_3                  MK_RGB(205, 173,   0)
	#define X11_GOLD4                   MK_RGB(139, 117,   0)
	#define X11_GOLD_4                  MK_RGB(139, 117,   0)
	#define X11_GOLDENROD1              MK_RGB(255, 193,  37)
	#define X11_GOLDENROD_1             MK_RGB(255, 193,  37)
	#define X11_GOLDENROD2              MK_RGB(238, 180,  34)
	#define X11_GOLDENROD_2             MK_RGB(238, 180,  34)
	#define X11_GOLDENROD3              MK_RGB(205, 155,  29)
	#define X11_GOLDENROD_3             MK_RGB(205, 155,  29)
	#define X11_GOLDENROD4              MK_RGB(139, 105,  20)
	#define X11_GOLDENROD_4             MK_RGB(139, 105,  20)
	#define X11_DARKGOLDENROD1          MK_RGB(255, 185,  15)
	#define X11_DARK_GOLDENROD_1        MK_RGB(255, 185,  15)
	#define X11_DARKGOLDENROD2          MK_RGB(238, 173,  14)
	#define X11_DARK_GOLDENROD_2        MK_RGB(238, 173,  14)
	#define X11_DARKGOLDENROD3          MK_RGB(205, 149,  12)
	#define X11_DARK_GOLDENROD_3        MK_RGB(205, 149,  12)
	#define X11_DARKGOLDENROD4          MK_RGB(139, 101,   8)
	#define X11_DARK_GOLDENROD_4        MK_RGB(139, 101,   8)
	#define X11_ROSYBROWN1              MK_RGB(255, 193, 193)
	#define X11_ROSY_BROWN_1            MK_RGB(255, 193, 193)
	#define X11_ROSYBROWN2              MK_RGB(238, 180, 180)
	#define X11_ROSY_BROWN_2            MK_RGB(238, 180, 180)
	#define X11_ROSYBROWN3              MK_RGB(205, 155, 155)
	#define X11_ROSY_BROWN_3            MK_RGB(205, 155, 155)
	#define X11_ROSYBROWN4              MK_RGB(139, 105, 105)
	#define X11_ROSY_BROWN_4            MK_RGB(139, 105, 105)
	#define X11_INDIANRED1              MK_RGB(255, 106, 106)
	#define X11_INDIAN_RED_1            MK_RGB(255, 106, 106)
	#define X11_INDIANRED2              MK_RGB(238,  99,  99)
	#define X11_INDIAN_RED_2            MK_RGB(238,  99,  99)
	#define X11_INDIANRED3              MK_RGB(205,  85,  85)
	#define X11_INDIAN_RED_3            MK_RGB(205,  85,  85)
	#define X11_INDIANRED4              MK_RGB(139,  58,  58)
	#define X11_INDIAN_RED_4            MK_RGB(139,  58,  58)
	#define X11_SIENNA1                 MK_RGB(255, 130,  71)
	#define X11_SIENNA_1                MK_RGB(255, 130,  71)
	#define X11_SIENNA2                 MK_RGB(238, 121,  66)
	#define X11_SIENNA_2                MK_RGB(238, 121,  66)
	#define X11_SIENNA3                 MK_RGB(205, 104,  57)
	#define X11_SIENNA_3                MK_RGB(205, 104,  57)
	#define X11_SIENNA4                 MK_RGB(139,  71,  38)
	#define X11_SIENNA_4                MK_RGB(139,  71,  38)
	#define X11_BURLYWOOD1              MK_RGB(255, 211, 155)
	#define X11_BURLYWOOD_1             MK_RGB(255, 211, 155)
	#define X11_BURLYWOOD2              MK_RGB(238, 197, 145)
	#define X11_BURLYWOOD_2             MK_RGB(238, 197, 145)
	#define X11_BURLYWOOD3              MK_RGB(205, 170, 125)
	#define X11_BURLYWOOD_3             MK_RGB(205, 170, 125)
	#define X11_BURLYWOOD4              MK_RGB(139, 115,  85)
	#define X11_BURLYWOOD_4             MK_RGB(139, 115,  85)
	#define X11_WHEAT1                  MK_RGB(255, 231, 186)
	#define X11_WHEAT_1                 MK_RGB(255, 231, 186)
	#define X11_WHEAT2                  MK_RGB(238, 216, 174)
	#define X11_WHEAT_2                 MK_RGB(238, 216, 174)
	#define X11_WHEAT3                  MK_RGB(205, 186, 150)
	#define X11_WHEAT_3                 MK_RGB(205, 186, 150)
	#define X11_WHEAT4                  MK_RGB(139, 126, 102)
	#define X11_WHEAT_4                 MK_RGB(139, 126, 102)
	#define X11_TAN1                    MK_RGB(255, 165,  79)
	#define X11_TAN_1                   MK_RGB(255, 165,  79)
	#define X11_TAN2                    MK_RGB(238, 154,  73)
	#define X11_TAN_2                   MK_RGB(238, 154,  73)
	#define X11_TAN3                    MK_RGB(205, 133,  63)
	#define X11_TAN_3                   MK_RGB(205, 133,  63)
	#define X11_TAN4                    MK_RGB(139,  90,  43)
	#define X11_TAN_4                   MK_RGB(139,  90,  43)
	#define X11_CHOCOLATE1              MK_RGB(255, 127,  36)
	#define X11_CHOCOLATE_1             MK_RGB(255, 127,  36)
	#define X11_CHOCOLATE2              MK_RGB(238, 118,  33)
	#define X11_CHOCOLATE_2             MK_RGB(238, 118,  33)
	#define X11_CHOCOLATE3              MK_RGB(205, 102,  29)
	#define X11_CHOCOLATE_3             MK_RGB(205, 102,  29)
	#define X11_CHOCOLATE4              MK_RGB(139,  69,  19)
	#define X11_CHOCOLATE_4             MK_RGB(139,  69,  19)
	#define X11_FIREBRICK1              MK_RGB(255,  48,  48)
	#define X11_FIREBRICK_1             MK_RGB(255,  48,  48)
	#define X11_FIREBRICK2              MK_RGB(238,  44,  44)
	#define X11_FIREBRICK_2             MK_RGB(238,  44,  44)
	#define X11_FIREBRICK3              MK_RGB(205,  38,  38)
	#define X11_FIREBRICK_3             MK_RGB(205,  38,  38)
	#define X11_FIREBRICK4              MK_RGB(139,  26,  26)
	#define X11_FIREBRICK_4             MK_RGB(139,  26,  26)
	#define X11_BROWN1                  MK_RGB(255,  64,  64)
	#define X11_BROWN_1                 MK_RGB(255,  64,  64)
	#define X11_BROWN2                  MK_RGB(238,  59,  59)
	#define X11_BROWN_2                 MK_RGB(238,  59,  59)
	#define X11_BROWN3                  MK_RGB(205,  51,  51)
	#define X11_BROWN_3                 MK_RGB(205,  51,  51)
	#define X11_BROWN4                  MK_RGB(139,  35,  35)
	#define X11_BROWN_4                 MK_RGB(139,  35,  35)
	#define X11_SALMON1                 MK_RGB(255, 140, 105)
	#define X11_SALMON_1                MK_RGB(255, 140, 105)
	#define X11_SALMON2                 MK_RGB(238, 130,  98)
	#define X11_SALMON_2                MK_RGB(238, 130,  98)
	#define X11_SALMON3                 MK_RGB(205, 112,  84)
	#define X11_SALMON_3                MK_RGB(205, 112,  84)
	#define X11_SALMON4                 MK_RGB(139,  76,  57)
	#define X11_SALMON_4                MK_RGB(139,  76,  57)
	#define X11_LIGHTSALMON1            MK_RGB(255, 160, 122)
	#define X11_LIGHT_SALMON_1          MK_RGB(255, 160, 122)
	#define X11_LIGHTSALMON2            MK_RGB(238, 149, 114)
	#define X11_LIGHT_SALMON_2          MK_RGB(238, 149, 114)
	#define X11_LIGHTSALMON3            MK_RGB(205, 129,  98)
	#define X11_LIGHT_SALMON_3          MK_RGB(205, 129,  98)
	#define X11_LIGHTSALMON4            MK_RGB(139,  87,  66)
	#define X11_LIGHT_SALMON_4          MK_RGB(139,  87,  66)
	#define X11_ORANGE1                 MK_RGB(255, 165,   0)
	#define X11_ORANGE_1                MK_RGB(255, 165,   0)
	#define X11_ORANGE2                 MK_RGB(238, 154,   0)
	#define X11_ORANGE_2                MK_RGB(238, 154,   0)
	#define X11_ORANGE3                 MK_RGB(205, 133,   0)
	#define X11_ORANGE_3                MK_RGB(205, 133,   0)
	#define X11_ORANGE4                 MK_RGB(139,  90,   0)
	#define X11_ORANGE_4                MK_RGB(139,  90,   0)
	#define X11_DARKORANGE1             MK_RGB(255, 127,   0)
	#define X11_DARK_ORANGE_1           MK_RGB(255, 127,   0)
	#define X11_DARKORANGE2             MK_RGB(238, 118,   0)
	#define X11_DARK_ORANGE_2           MK_RGB(238, 118,   0)
	#define X11_DARKORANGE3             MK_RGB(205, 102,   0)
	#define X11_DARK_ORANGE_3           MK_RGB(205, 102,   0)
	#define X11_DARKORANGE4             MK_RGB(139,  69,   0)
	#define X11_DARK_ORANGE_4           MK_RGB(139,  69,   0)
	#define X11_CORAL1                  MK_RGB(255, 114,  86)
	#define X11_CORAL_1                 MK_RGB(255, 114,  86)
	#define X11_CORAL2                  MK_RGB(238, 106,  80)
	#define X11_CORAL_2                 MK_RGB(238, 106,  80)
	#define X11_CORAL3                  MK_RGB(205,  91,  69)
	#define X11_CORAL_3                 MK_RGB(205,  91,  69)
	#define X11_CORAL4                  MK_RGB(139,  62,  47)
	#define X11_CORAL_4                 MK_RGB(139,  62,  47)
	#define X11_TOMATO1                 MK_RGB(255,  99,  71)
	#define X11_TOMATO_1                MK_RGB(255,  99,  71)
	#define X11_TOMATO2                 MK_RGB(238,  92,  66)
	#define X11_TOMATO_2                MK_RGB(238,  92,  66)
	#define X11_TOMATO3                 MK_RGB(205,  79,  57)
	#define X11_TOMATO_3                MK_RGB(205,  79,  57)
	#define X11_TOMATO4                 MK_RGB(139,  54,  38)
	#define X11_TOMATO_4                MK_RGB(139,  54,  38)
	#define X11_ORANGERED1              MK_RGB(255,  69,   0)
	#define X11_ORANGE_RED_1            MK_RGB(255,  69,   0)
	#define X11_ORANGERED2              MK_RGB(238,  64,   0)
	#define X11_ORANGE_RED_2            MK_RGB(238,  64,   0)
	#define X11_ORANGERED3              MK_RGB(205,  55,   0)
	#define X11_ORANGE_RED_3            MK_RGB(205,  55,   0)
	#define X11_ORANGERED4              MK_RGB(139,  37,   0)
	#define X11_ORANGE_RED_4            MK_RGB(139,  37,   0)
	#define X11_RED1                    MK_RGB(255,   0,   0)
	#define X11_RED_1                   MK_RGB(255,   0,   0)
	#define X11_RED2                    MK_RGB(238,   0,   0)
	#define X11_RED_2                   MK_RGB(238,   0,   0)
	#define X11_RED3                    MK_RGB(205,   0,   0)
	#define X11_RED_3                   MK_RGB(205,   0,   0)
	#define X11_RED4                    MK_RGB(139,   0,   0)
	#define X11_RED_4                   MK_RGB(139,   0,   0)
	#define X11_DEEPPINK1               MK_RGB(255,  20, 147)
	#define X11_DEEP_PINK_1             MK_RGB(255,  20, 147)
	#define X11_DEEPPINK2               MK_RGB(238,  18, 137)
	#define X11_DEEP_PINK_2             MK_RGB(238,  18, 137)
	#define X11_DEEPPINK3               MK_RGB(205,  16, 118)
	#define X11_DEEP_PINK_3             MK_RGB(205,  16, 118)
	#define X11_DEEPPINK4               MK_RGB(139,  10,  80)
	#define X11_DEEP_PINK_4             MK_RGB(139,  10,  80)
	#define X11_HOTPINK1                MK_RGB(255, 110, 180)
	#define X11_HOT_PINK_1              MK_RGB(255, 110, 180)
	#define X11_HOTPINK2                MK_RGB(238, 106, 167)
	#define X11_HOT_PINK_2              MK_RGB(238, 106, 167)
	#define X11_HOTPINK3                MK_RGB(205,  96, 144)
	#define X11_HOT_PINK_3              MK_RGB(205,  96, 144)
	#define X11_HOTPINK4                MK_RGB(139,  58,  98)
	#define X11_HOT_PINK_4              MK_RGB(139,  58,  98)
	#define X11_PINK1                   MK_RGB(255, 181, 197)
	#define X11_PINK_1                  MK_RGB(255, 181, 197)
	#define X11_PINK2                   MK_RGB(238, 169, 184)
	#define X11_PINK_2                  MK_RGB(238, 169, 184)
	#define X11_PINK3                   MK_RGB(205, 145, 158)
	#define X11_PINK_3                  MK_RGB(205, 145, 158)
	#define X11_PINK4                   MK_RGB(139,  99, 108)
	#define X11_PINK_4                  MK_RGB(139,  99, 108)
	#define X11_LIGHTPINK1              MK_RGB(255, 174, 185)
	#define X11_LIGHT_PINK_1            MK_RGB(255, 174, 185)
	#define X11_LIGHTPINK2              MK_RGB(238, 162, 173)
	#define X11_LIGHT_PINK_2            MK_RGB(238, 162, 173)
	#define X11_LIGHTPINK3              MK_RGB(205, 140, 149)
	#define X11_LIGHT_PINK_3            MK_RGB(205, 140, 149)
	#define X11_LIGHTPINK4              MK_RGB(139,  95, 101)
	#define X11_LIGHT_PINK_4            MK_RGB(139,  95, 101)
	#define X11_PALEVIOLETRED1          MK_RGB(255, 130, 171)
	#define X11_PALE_VIOLET_RED_1       MK_RGB(255, 130, 171)
	#define X11_PALEVIOLETRED2          MK_RGB(238, 121, 159)
	#define X11_PALE_VIOLET_RED_2       MK_RGB(238, 121, 159)
	#define X11_PALEVIOLETRED3          MK_RGB(205, 104, 137)
	#define X11_PALE_VIOLET_RED_3       MK_RGB(205, 104, 137)
	#define X11_PALEVIOLETRED4          MK_RGB(139,  71,  93)
	#define X11_PALE_VIOLET_RED_4       MK_RGB(139,  71,  93)
	#define X11_MAROON1                 MK_RGB(255,  52, 179)
	#define X11_MAROON_1                MK_RGB(255,  52, 179)
	#define X11_MAROON2                 MK_RGB(238,  48, 167)
	#define X11_MAROON_2                MK_RGB(238,  48, 167)
	#define X11_MAROON3                 MK_RGB(205,  41, 144)
	#define X11_MAROON_3                MK_RGB(205,  41, 144)
	#define X11_MAROON4                 MK_RGB(139,  28,  98)
	#define X11_MAROON_4                MK_RGB(139,  28,  98)
	#define X11_VIOLETRED1              MK_RGB(255,  62, 150)
	#define X11_VIOLET_RED_1            MK_RGB(255,  62, 150)
	#define X11_VIOLETRED2              MK_RGB(238,  58, 140)
	#define X11_VIOLET_RED_2            MK_RGB(238,  58, 140)
	#define X11_VIOLETRED3              MK_RGB(205,  50, 120)
	#define X11_VIOLET_RED_3            MK_RGB(205,  50, 120)
	#define X11_VIOLETRED4              MK_RGB(139,  34,  82)
	#define X11_VIOLET_RED_4            MK_RGB(139,  34,  82)
	#define X11_MAGENTA1                MK_RGB(255,   0, 255)
	#define X11_MAGENTA_1               MK_RGB(255,   0, 255)
	#define X11_MAGENTA2                MK_RGB(238,   0, 238)
	#define X11_MAGENTA_2               MK_RGB(238,   0, 238)
	#define X11_MAGENTA3                MK_RGB(205,   0, 205)
	#define X11_MAGENTA_3               MK_RGB(205,   0, 205)
	#define X11_MAGENTA4                MK_RGB(139,   0, 139)
	#define X11_MAGENTA_4               MK_RGB(139,   0, 139)
	#define X11_ORCHID1                 MK_RGB(255, 131, 250)
	#define X11_ORCHID_1                MK_RGB(255, 131, 250)
	#define X11_ORCHID2                 MK_RGB(238, 122, 233)
	#define X11_ORCHID_2                MK_RGB(238, 122, 233)
	#define X11_ORCHID3                 MK_RGB(205, 105, 201)
	#define X11_ORCHID_3                MK_RGB(205, 105, 201)
	#define X11_ORCHID4                 MK_RGB(139,  71, 137)
	#define X11_ORCHID_4                MK_RGB(139,  71, 137)
	#define X11_PLUM1                   MK_RGB(255, 187, 255)
	#define X11_PLUM_1                  MK_RGB(255, 187, 255)
	#define X11_PLUM2                   MK_RGB(238, 174, 238)
	#define X11_PLUM_2                  MK_RGB(238, 174, 238)
	#define X11_PLUM3                   MK_RGB(205, 150, 205)
	#define X11_PLUM_3                  MK_RGB(205, 150, 205)
	#define X11_PLUM4                   MK_RGB(139, 102, 139)
	#define X11_PLUM_4                  MK_RGB(139, 102, 139)
	#define X11_MEDIUMORCHID1           MK_RGB(224, 102, 255)
	#define X11_MEDIUM_ORCHID_1         MK_RGB(224, 102, 255)
	#define X11_MEDIUMORCHID2           MK_RGB(209,  95, 238)
	#define X11_MEDIUM_ORCHID_2         MK_RGB(209,  95, 238)
	#define X11_MEDIUMORCHID3           MK_RGB(180,  82, 205)
	#define X11_MEDIUM_ORCHID_3         MK_RGB(180,  82, 205)
	#define X11_MEDIUMORCHID4           MK_RGB(122,  55, 139)
	#define X11_MEDIUM_ORCHID_4         MK_RGB(122,  55, 139)
	#define X11_DARKORCHID1             MK_RGB(191,  62, 255)
	#define X11_DARK_ORCHID_1           MK_RGB(191,  62, 255)
	#define X11_DARKORCHID2             MK_RGB(178,  58, 238)
	#define X11_DARK_ORCHID_2           MK_RGB(178,  58, 238)
	#define X11_DARKORCHID3             MK_RGB(154,  50, 205)
	#define X11_DARK_ORCHID_3           MK_RGB(154,  50, 205)
	#define X11_DARKORCHID4             MK_RGB(104,  34, 139)
	#define X11_DARK_ORCHID_4           MK_RGB(104,  34, 139)
	#define X11_PURPLE1                 MK_RGB(155,  48, 255)
	#define X11_PURPLE_1                MK_RGB(155,  48, 255)
	#define X11_PURPLE2                 MK_RGB(145,  44, 238)
	#define X11_PURPLE_2                MK_RGB(145,  44, 238)
	#define X11_PURPLE3                 MK_RGB(125,  38, 205)
	#define X11_PURPLE_3                MK_RGB(125,  38, 205)
	#define X11_PURPLE4                 MK_RGB( 85,  26, 139)
	#define X11_PURPLE_4                MK_RGB( 85,  26, 139)
	#define X11_MEDIUMPURPLE1           MK_RGB(171, 130, 255)
	#define X11_MEDIUM_PURPLE_1         MK_RGB(171, 130, 255)
	#define X11_MEDIUMPURPLE2           MK_RGB(159, 121, 238)
	#define X11_MEDIUM_PURPLE_2         MK_RGB(159, 121, 238)
	#define X11_MEDIUMPURPLE3           MK_RGB(137, 104, 205)
	#define X11_MEDIUM_PURPLE_3         MK_RGB(137, 104, 205)
	#define X11_MEDIUMPURPLE4           MK_RGB( 93,  71, 139)
	#define X11_MEDIUM_PURPLE_4         MK_RGB( 93,  71, 139)
	#define X11_THISTLE1                MK_RGB(255, 225, 255)
	#define X11_THISTLE_1               MK_RGB(255, 225, 255)
	#define X11_THISTLE2                MK_RGB(238, 210, 238)
	#define X11_THISTLE_2               MK_RGB(238, 210, 238)
	#define X11_THISTLE3                MK_RGB(205, 181, 205)
	#define X11_THISTLE_3               MK_RGB(205, 181, 205)
	#define X11_THISTLE4                MK_RGB(139, 123, 139)
	#define X11_THISTLE_4               MK_RGB(139, 123, 139)
	#define X11_GRAY0                   MK_RGB(  0,   0,   0)
	#define X11_GRAY_0                  MK_RGB(  0,   0,   0)
	#define X11_GREY0                   MK_RGB(  0,   0,   0)
	#define X11_GREY_0                  MK_RGB(  0,   0,   0)
	#define X11_GRAY1                   MK_RGB(  3,   3,   3)
	#define X11_GRAY_1                  MK_RGB(  3,   3,   3)
	#define X11_GREY1                   MK_RGB(  3,   3,   3)
	#define X11_GREY_1                  MK_RGB(  3,   3,   3)
	#define X11_GRAY2                   MK_RGB(  5,   5,   5)
	#define X11_GRAY_2                  MK_RGB(  5,   5,   5)
	#define X11_GREY2                   MK_RGB(  5,   5,   5)
	#define X11_GREY_2                  MK_RGB(  5,   5,   5)
	#define X11_GRAY3                   MK_RGB(  8,   8,   8)
	#define X11_GRAY_3                  MK_RGB(  8,   8,   8)
	#define X11_GREY3                   MK_RGB(  8,   8,   8)
	#define X11_GREY_3                  MK_RGB(  8,   8,   8)
	#define X11_GRAY4                   MK_RGB( 10,  10,  10)
	#define X11_GRAY_4                  MK_RGB( 10,  10,  10)
	#define X11_GREY4                   MK_RGB( 10,  10,  10)
	#define X11_GREY_4                  MK_RGB( 10,  10,  10)
	#define X11_GRAY5                   MK_RGB( 13,  13,  13)
	#define X11_GRAY_5                  MK_RGB( 13,  13,  13)
	#define X11_GREY5                   MK_RGB( 13,  13,  13)
	#define X11_GREY_5                  MK_RGB( 13,  13,  13)
	#define X11_GRAY6                   MK_RGB( 15,  15,  15)
	#define X11_GRAY_6                  MK_RGB( 15,  15,  15)
	#define X11_GREY6                   MK_RGB( 15,  15,  15)
	#define X11_GREY_6                  MK_RGB( 15,  15,  15)
	#define X11_GRAY7                   MK_RGB( 18,  18,  18)
	#define X11_GRAY_7                  MK_RGB( 18,  18,  18)
	#define X11_GREY7                   MK_RGB( 18,  18,  18)
	#define X11_GREY_7                  MK_RGB( 18,  18,  18)
	#define X11_GRAY8                   MK_RGB( 20,  20,  20)
	#define X11_GRAY_8                  MK_RGB( 20,  20,  20)
	#define X11_GREY8                   MK_RGB( 20,  20,  20)
	#define X11_GREY_8                  MK_RGB( 20,  20,  20)
	#define X11_GRAY9                   MK_RGB( 23,  23,  23)
	#define X11_GRAY_9                  MK_RGB( 23,  23,  23)
	#define X11_GREY9                   MK_RGB( 23,  23,  23)
	#define X11_GREY_9                  MK_RGB( 23,  23,  23)
	#define X11_GRAY10                  MK_RGB( 26,  26,  26)
	#define X11_GRAY_10                 MK_RGB( 26,  26,  26)
	#define X11_GREY10                  MK_RGB( 26,  26,  26)
	#define X11_GREY_10                 MK_RGB( 26,  26,  26)
	#define X11_GRAY11                  MK_RGB( 28,  28,  28)
	#define X11_GRAY_11                 MK_RGB( 28,  28,  28)
	#define X11_GREY11                  MK_RGB( 28,  28,  28)
	#define X11_GREY_11                 MK_RGB( 28,  28,  28)
	#define X11_GRAY12                  MK_RGB( 31,  31,  31)
	#define X11_GRAY_12                 MK_RGB( 31,  31,  31)
	#define X11_GREY12                  MK_RGB( 31,  31,  31)
	#define X11_GREY_12                 MK_RGB( 31,  31,  31)
	#define X11_GRAY13                  MK_RGB( 33,  33,  33)
	#define X11_GRAY_13                 MK_RGB( 33,  33,  33)
	#define X11_GREY13                  MK_RGB( 33,  33,  33)
	#define X11_GREY_13                 MK_RGB( 33,  33,  33)
	#define X11_GRAY14                  MK_RGB( 36,  36,  36)
	#define X11_GRAY_14                 MK_RGB( 36,  36,  36)
	#define X11_GREY14                  MK_RGB( 36,  36,  36)
	#define X11_GREY_14                 MK_RGB( 36,  36,  36)
	#define X11_GRAY15                  MK_RGB( 38,  38,  38)
	#define X11_GRAY_15                 MK_RGB( 38,  38,  38)
	#define X11_GREY15                  MK_RGB( 38,  38,  38)
	#define X11_GREY_15                 MK_RGB( 38,  38,  38)
	#define X11_GRAY16                  MK_RGB( 41,  41,  41)
	#define X11_GRAY_16                 MK_RGB( 41,  41,  41)
	#define X11_GREY16                  MK_RGB( 41,  41,  41)
	#define X11_GREY_16                 MK_RGB( 41,  41,  41)
	#define X11_GRAY17                  MK_RGB( 43,  43,  43)
	#define X11_GRAY_17                 MK_RGB( 43,  43,  43)
	#define X11_GREY17                  MK_RGB( 43,  43,  43)
	#define X11_GREY_17                 MK_RGB( 43,  43,  43)
	#define X11_GRAY18                  MK_RGB( 46,  46,  46)
	#define X11_GRAY_18                 MK_RGB( 46,  46,  46)
	#define X11_GREY18                  MK_RGB( 46,  46,  46)
	#define X11_GREY_18                 MK_RGB( 46,  46,  46)
	#define X11_GRAY19                  MK_RGB( 48,  48,  48)
	#define X11_GRAY_19                 MK_RGB( 48,  48,  48)
	#define X11_GREY19                  MK_RGB( 48,  48,  48)
	#define X11_GREY_19                 MK_RGB( 48,  48,  48)
	#define X11_GRAY20                  MK_RGB( 51,  51,  51)
	#define X11_GRAY_20                 MK_RGB( 51,  51,  51)
	#define X11_GREY20                  MK_RGB( 51,  51,  51)
	#define X11_GREY_20                 MK_RGB( 51,  51,  51)
	#define X11_GRAY21                  MK_RGB( 54,  54,  54)
	#define X11_GRAY_21                 MK_RGB( 54,  54,  54)
	#define X11_GREY21                  MK_RGB( 54,  54,  54)
	#define X11_GREY_21                 MK_RGB( 54,  54,  54)
	#define X11_GRAY22                  MK_RGB( 56,  56,  56)
	#define X11_GRAY_22                 MK_RGB( 56,  56,  56)
	#define X11_GREY22                  MK_RGB( 56,  56,  56)
	#define X11_GREY_22                 MK_RGB( 56,  56,  56)
	#define X11_GRAY23                  MK_RGB( 59,  59,  59)
	#define X11_GRAY_23                 MK_RGB( 59,  59,  59)
	#define X11_GREY23                  MK_RGB( 59,  59,  59)
	#define X11_GREY_23                 MK_RGB( 59,  59,  59)
	#define X11_GRAY24                  MK_RGB( 61,  61,  61)
	#define X11_GRAY_24                 MK_RGB( 61,  61,  61)
	#define X11_GREY24                  MK_RGB( 61,  61,  61)
	#define X11_GREY_24                 MK_RGB( 61,  61,  61)
	#define X11_GRAY25                  MK_RGB( 64,  64,  64)
	#define X11_GRAY_25                 MK_RGB( 64,  64,  64)
	#define X11_GREY25                  MK_RGB( 64,  64,  64)
	#define X11_GREY_25                 MK_RGB( 64,  64,  64)
	#define X11_GRAY26                  MK_RGB( 66,  66,  66)
	#define X11_GRAY_26                 MK_RGB( 66,  66,  66)
	#define X11_GREY26                  MK_RGB( 66,  66,  66)
	#define X11_GREY_26                 MK_RGB( 66,  66,  66)
	#define X11_GRAY27                  MK_RGB( 69,  69,  69)
	#define X11_GRAY_27                 MK_RGB( 69,  69,  69)
	#define X11_GREY27                  MK_RGB( 69,  69,  69)
	#define X11_GREY_27                 MK_RGB( 69,  69,  69)
	#define X11_GRAY28                  MK_RGB( 71,  71,  71)
	#define X11_GRAY_28                 MK_RGB( 71,  71,  71)
	#define X11_GREY28                  MK_RGB( 71,  71,  71)
	#define X11_GREY_28                 MK_RGB( 71,  71,  71)
	#define X11_GRAY29                  MK_RGB( 74,  74,  74)
	#define X11_GRAY_29                 MK_RGB( 74,  74,  74)
	#define X11_GREY29                  MK_RGB( 74,  74,  74)
	#define X11_GREY_29                 MK_RGB( 74,  74,  74)
	#define X11_GRAY30                  MK_RGB( 77,  77,  77)
	#define X11_GRAY_30                 MK_RGB( 77,  77,  77)
	#define X11_GREY30                  MK_RGB( 77,  77,  77)
	#define X11_GREY_30                 MK_RGB( 77,  77,  77)
	#define X11_GRAY31                  MK_RGB( 79,  79,  79)
	#define X11_GRAY_31                 MK_RGB( 79,  79,  79)
	#define X11_GREY31                  MK_RGB( 79,  79,  79)
	#define X11_GREY_31                 MK_RGB( 79,  79,  79)
	#define X11_GRAY32                  MK_RGB( 82,  82,  82)
	#define X11_GRAY_32                 MK_RGB( 82,  82,  82)
	#define X11_GREY32                  MK_RGB( 82,  82,  82)
	#define X11_GREY_32                 MK_RGB( 82,  82,  82)
	#define X11_GRAY33                  MK_RGB( 84,  84,  84)
	#define X11_GRAY_33                 MK_RGB( 84,  84,  84)
	#define X11_GREY33                  MK_RGB( 84,  84,  84)
	#define X11_GREY_33                 MK_RGB( 84,  84,  84)
	#define X11_GRAY34                  MK_RGB( 87,  87,  87)
	#define X11_GRAY_34                 MK_RGB( 87,  87,  87)
	#define X11_GREY34                  MK_RGB( 87,  87,  87)
	#define X11_GREY_34                 MK_RGB( 87,  87,  87)
	#define X11_GRAY35                  MK_RGB( 89,  89,  89)
	#define X11_GRAY_35                 MK_RGB( 89,  89,  89)
	#define X11_GREY35                  MK_RGB( 89,  89,  89)
	#define X11_GREY_35                 MK_RGB( 89,  89,  89)
	#define X11_GRAY36                  MK_RGB( 92,  92,  92)
	#define X11_GRAY_36                 MK_RGB( 92,  92,  92)
	#define X11_GREY36                  MK_RGB( 92,  92,  92)
	#define X11_GREY_36                 MK_RGB( 92,  92,  92)
	#define X11_GRAY37                  MK_RGB( 94,  94,  94)
	#define X11_GRAY_37                 MK_RGB( 94,  94,  94)
	#define X11_GREY37                  MK_RGB( 94,  94,  94)
	#define X11_GREY_37                 MK_RGB( 94,  94,  94)
	#define X11_GRAY38                  MK_RGB( 97,  97,  97)
	#define X11_GRAY_38                 MK_RGB( 97,  97,  97)
	#define X11_GREY38                  MK_RGB( 97,  97,  97)
	#define X11_GREY_38                 MK_RGB( 97,  97,  97)
	#define X11_GRAY39                  MK_RGB( 99,  99,  99)
	#define X11_GRAY_39                 MK_RGB( 99,  99,  99)
	#define X11_GREY39                  MK_RGB( 99,  99,  99)
	#define X11_GREY_39                 MK_RGB( 99,  99,  99)
	#define X11_GRAY40                  MK_RGB(102, 102, 102)
	#define X11_GRAY_40                 MK_RGB(102, 102, 102)
	#define X11_GREY40                  MK_RGB(102, 102, 102)
	#define X11_GREY_40                 MK_RGB(102, 102, 102)
	#define X11_GRAY41                  MK_RGB(105, 105, 105)
	#define X11_GRAY_41                 MK_RGB(105, 105, 105)
	#define X11_GREY41                  MK_RGB(105, 105, 105)
	#define X11_GREY_41                 MK_RGB(105, 105, 105)
	#define X11_GRAY42                  MK_RGB(107, 107, 107)
	#define X11_GRAY_42                 MK_RGB(107, 107, 107)
	#define X11_GREY42                  MK_RGB(107, 107, 107)
	#define X11_GREY_42                 MK_RGB(107, 107, 107)
	#define X11_GRAY43                  MK_RGB(110, 110, 110)
	#define X11_GRAY_43                 MK_RGB(110, 110, 110)
	#define X11_GREY43                  MK_RGB(110, 110, 110)
	#define X11_GREY_43                 MK_RGB(110, 110, 110)
	#define X11_GRAY44                  MK_RGB(112, 112, 112)
	#define X11_GRAY_44                 MK_RGB(112, 112, 112)
	#define X11_GREY44                  MK_RGB(112, 112, 112)
	#define X11_GREY_44                 MK_RGB(112, 112, 112)
	#define X11_GRAY45                  MK_RGB(115, 115, 115)
	#define X11_GRAY_45                 MK_RGB(115, 115, 115)
	#define X11_GREY45                  MK_RGB(115, 115, 115)
	#define X11_GREY_45                 MK_RGB(115, 115, 115)
	#define X11_GRAY46                  MK_RGB(117, 117, 117)
	#define X11_GRAY_46                 MK_RGB(117, 117, 117)
	#define X11_GREY46                  MK_RGB(117, 117, 117)
	#define X11_GREY_46                 MK_RGB(117, 117, 117)
	#define X11_GRAY47                  MK_RGB(120, 120, 120)
	#define X11_GRAY_47                 MK_RGB(120, 120, 120)
	#define X11_GREY47                  MK_RGB(120, 120, 120)
	#define X11_GREY_47                 MK_RGB(120, 120, 120)
	#define X11_GRAY48                  MK_RGB(122, 122, 122)
	#define X11_GRAY_48                 MK_RGB(122, 122, 122)
	#define X11_GREY48                  MK_RGB(122, 122, 122)
	#define X11_GREY_48                 MK_RGB(122, 122, 122)
	#define X11_GRAY49                  MK_RGB(125, 125, 125)
	#define X11_GRAY_49                 MK_RGB(125, 125, 125)
	#define X11_GREY49                  MK_RGB(125, 125, 125)
	#define X11_GREY_49                 MK_RGB(125, 125, 125)
	#define X11_GRAY50                  MK_RGB(127, 127, 127)
	#define X11_GRAY_50                 MK_RGB(127, 127, 127)
	#define X11_GREY50                  MK_RGB(127, 127, 127)
	#define X11_GREY_50                 MK_RGB(127, 127, 127)
	#define X11_GRAY51                  MK_RGB(130, 130, 130)
	#define X11_GRAY_51                 MK_RGB(130, 130, 130)
	#define X11_GREY51                  MK_RGB(130, 130, 130)
	#define X11_GREY_51                 MK_RGB(130, 130, 130)
	#define X11_GRAY52                  MK_RGB(133, 133, 133)
	#define X11_GRAY_52                 MK_RGB(133, 133, 133)
	#define X11_GREY52                  MK_RGB(133, 133, 133)
	#define X11_GREY_52                 MK_RGB(133, 133, 133)
	#define X11_GRAY53                  MK_RGB(135, 135, 135)
	#define X11_GRAY_53                 MK_RGB(135, 135, 135)
	#define X11_GREY53                  MK_RGB(135, 135, 135)
	#define X11_GREY_53                 MK_RGB(135, 135, 135)
	#define X11_GRAY54                  MK_RGB(138, 138, 138)
	#define X11_GRAY_54                 MK_RGB(138, 138, 138)
	#define X11_GREY54                  MK_RGB(138, 138, 138)
	#define X11_GREY_54                 MK_RGB(138, 138, 138)
	#define X11_GRAY55                  MK_RGB(140, 140, 140)
	#define X11_GRAY_55                 MK_RGB(140, 140, 140)
	#define X11_GREY55                  MK_RGB(140, 140, 140)
	#define X11_GREY_55                 MK_RGB(140, 140, 140)
	#define X11_GRAY56                  MK_RGB(143, 143, 143)
	#define X11_GRAY_56                 MK_RGB(143, 143, 143)
	#define X11_GREY56                  MK_RGB(143, 143, 143)
	#define X11_GREY_56                 MK_RGB(143, 143, 143)
	#define X11_GRAY57                  MK_RGB(145, 145, 145)
	#define X11_GRAY_57                 MK_RGB(145, 145, 145)
	#define X11_GREY57                  MK_RGB(145, 145, 145)
	#define X11_GREY_57                 MK_RGB(145, 145, 145)
	#define X11_GRAY58                  MK_RGB(148, 148, 148)
	#define X11_GRAY_58                 MK_RGB(148, 148, 148)
	#define X11_GREY58                  MK_RGB(148, 148, 148)
	#define X11_GREY_58                 MK_RGB(148, 148, 148)
	#define X11_GRAY59                  MK_RGB(150, 150, 150)
	#define X11_GRAY_59                 MK_RGB(150, 150, 150)
	#define X11_GREY59                  MK_RGB(150, 150, 150)
	#define X11_GREY_59                 MK_RGB(150, 150, 150)
	#define X11_GRAY60                  MK_RGB(153, 153, 153)
	#define X11_GRAY_60                 MK_RGB(153, 153, 153)
	#define X11_GREY60                  MK_RGB(153, 153, 153)
	#define X11_GREY_60                 MK_RGB(153, 153, 153)
	#define X11_GRAY61                  MK_RGB(156, 156, 156)
	#define X11_GRAY_61                 MK_RGB(156, 156, 156)
	#define X11_GREY61                  MK_RGB(156, 156, 156)
	#define X11_GREY_61                 MK_RGB(156, 156, 156)
	#define X11_GRAY62                  MK_RGB(158, 158, 158)
	#define X11_GRAY_62                 MK_RGB(158, 158, 158)
	#define X11_GREY62                  MK_RGB(158, 158, 158)
	#define X11_GREY_62                 MK_RGB(158, 158, 158)
	#define X11_GRAY63                  MK_RGB(161, 161, 161)
	#define X11_GRAY_63                 MK_RGB(161, 161, 161)
	#define X11_GREY63                  MK_RGB(161, 161, 161)
	#define X11_GREY_63                 MK_RGB(161, 161, 161)
	#define X11_GRAY64                  MK_RGB(163, 163, 163)
	#define X11_GRAY_64                 MK_RGB(163, 163, 163)
	#define X11_GREY64                  MK_RGB(163, 163, 163)
	#define X11_GREY_64                 MK_RGB(163, 163, 163)
	#define X11_GRAY65                  MK_RGB(166, 166, 166)
	#define X11_GRAY_65                 MK_RGB(166, 166, 166)
	#define X11_GREY65                  MK_RGB(166, 166, 166)
	#define X11_GREY_65                 MK_RGB(166, 166, 166)
	#define X11_GRAY66                  MK_RGB(168, 168, 168)
	#define X11_GRAY_66                 MK_RGB(168, 168, 168)
	#define X11_GREY66                  MK_RGB(168, 168, 168)
	#define X11_GREY_66                 MK_RGB(168, 168, 168)
	#define X11_GRAY67                  MK_RGB(171, 171, 171)
	#define X11_GRAY_67                 MK_RGB(171, 171, 171)
	#define X11_GREY67                  MK_RGB(171, 171, 171)
	#define X11_GREY_67                 MK_RGB(171, 171, 171)
	#define X11_GRAY68                  MK_RGB(173, 173, 173)
	#define X11_GRAY_68                 MK_RGB(173, 173, 173)
	#define X11_GREY68                  MK_RGB(173, 173, 173)
	#define X11_GREY_68                 MK_RGB(173, 173, 173)
	#define X11_GRAY69                  MK_RGB(176, 176, 176)
	#define X11_GRAY_69                 MK_RGB(176, 176, 176)
	#define X11_GREY69                  MK_RGB(176, 176, 176)
	#define X11_GREY_69                 MK_RGB(176, 176, 176)
	#define X11_GRAY70                  MK_RGB(179, 179, 179)
	#define X11_GRAY_70                 MK_RGB(179, 179, 179)
	#define X11_GREY70                  MK_RGB(179, 179, 179)
	#define X11_GREY_70                 MK_RGB(179, 179, 179)
	#define X11_GRAY71                  MK_RGB(181, 181, 181)
	#define X11_GRAY_71                 MK_RGB(181, 181, 181)
	#define X11_GREY71                  MK_RGB(181, 181, 181)
	#define X11_GREY_71                 MK_RGB(181, 181, 181)
	#define X11_GRAY72                  MK_RGB(184, 184, 184)
	#define X11_GRAY_72                 MK_RGB(184, 184, 184)
	#define X11_GREY72                  MK_RGB(184, 184, 184)
	#define X11_GREY_72                 MK_RGB(184, 184, 184)
	#define X11_GRAY73                  MK_RGB(186, 186, 186)
	#define X11_GRAY_73                 MK_RGB(186, 186, 186)
	#define X11_GREY73                  MK_RGB(186, 186, 186)
	#define X11_GREY_73                 MK_RGB(186, 186, 186)
	#define X11_GRAY74                  MK_RGB(189, 189, 189)
	#define X11_GRAY_74                 MK_RGB(189, 189, 189)
	#define X11_GREY74                  MK_RGB(189, 189, 189)
	#define X11_GREY_74                 MK_RGB(189, 189, 189)
	#define X11_GRAY75                  MK_RGB(191, 191, 191)
	#define X11_GRAY_75                 MK_RGB(191, 191, 191)
	#define X11_GREY75                  MK_RGB(191, 191, 191)
	#define X11_GREY_75                 MK_RGB(191, 191, 191)
	#define X11_GRAY76                  MK_RGB(194, 194, 194)
	#define X11_GRAY_76                 MK_RGB(194, 194, 194)
	#define X11_GREY76                  MK_RGB(194, 194, 194)
	#define X11_GREY_76                 MK_RGB(194, 194, 194)
	#define X11_GRAY77                  MK_RGB(196, 196, 196)
	#define X11_GRAY_77                 MK_RGB(196, 196, 196)
	#define X11_GREY77                  MK_RGB(196, 196, 196)
	#define X11_GREY_77                 MK_RGB(196, 196, 196)
	#define X11_GRAY78                  MK_RGB(199, 199, 199)
	#define X11_GRAY_78                 MK_RGB(199, 199, 199)
	#define X11_GREY78                  MK_RGB(199, 199, 199)
	#define X11_GREY_78                 MK_RGB(199, 199, 199)
	#define X11_GRAY79                  MK_RGB(201, 201, 201)
	#define X11_GRAY_79                 MK_RGB(201, 201, 201)
	#define X11_GREY79                  MK_RGB(201, 201, 201)
	#define X11_GREY_79                 MK_RGB(201, 201, 201)
	#define X11_GRAY80                  MK_RGB(204, 204, 204)
	#define X11_GRAY_80                 MK_RGB(204, 204, 204)
	#define X11_GREY80                  MK_RGB(204, 204, 204)
	#define X11_GREY_80                 MK_RGB(204, 204, 204)
	#define X11_GRAY81                  MK_RGB(207, 207, 207)
	#define X11_GRAY_81                 MK_RGB(207, 207, 207)
	#define X11_GREY81                  MK_RGB(207, 207, 207)
	#define X11_GREY_81                 MK_RGB(207, 207, 207)
	#define X11_GRAY82                  MK_RGB(209, 209, 209)
	#define X11_GRAY_82                 MK_RGB(209, 209, 209)
	#define X11_GREY82                  MK_RGB(209, 209, 209)
	#define X11_GREY_82                 MK_RGB(209, 209, 209)
	#define X11_GRAY83                  MK_RGB(212, 212, 212)
	#define X11_GRAY_83                 MK_RGB(212, 212, 212)
	#define X11_GREY83                  MK_RGB(212, 212, 212)
	#define X11_GREY_83                 MK_RGB(212, 212, 212)
	#define X11_GRAY84                  MK_RGB(214, 214, 214)
	#define X11_GRAY_84                 MK_RGB(214, 214, 214)
	#define X11_GREY84                  MK_RGB(214, 214, 214)
	#define X11_GREY_84                 MK_RGB(214, 214, 214)
	#define X11_GRAY85                  MK_RGB(217, 217, 217)
	#define X11_GRAY_85                 MK_RGB(217, 217, 217)
	#define X11_GREY85                  MK_RGB(217, 217, 217)
	#define X11_GREY_85                 MK_RGB(217, 217, 217)
	#define X11_GRAY86                  MK_RGB(219, 219, 219)
	#define X11_GRAY_86                 MK_RGB(219, 219, 219)
	#define X11_GREY86                  MK_RGB(219, 219, 219)
	#define X11_GREY_86                 MK_RGB(219, 219, 219)
	#define X11_GRAY87                  MK_RGB(222, 222, 222)
	#define X11_GRAY_87                 MK_RGB(222, 222, 222)
	#define X11_GREY87                  MK_RGB(222, 222, 222)
	#define X11_GREY_87                 MK_RGB(222, 222, 222)
	#define X11_GRAY88                  MK_RGB(224, 224, 224)
	#define X11_GRAY_88                 MK_RGB(224, 224, 224)
	#define X11_GREY88                  MK_RGB(224, 224, 224)
	#define X11_GREY_88                 MK_RGB(224, 224, 224)
	#define X11_GRAY89                  MK_RGB(227, 227, 227)
	#define X11_GRAY_89                 MK_RGB(227, 227, 227)
	#define X11_GREY89                  MK_RGB(227, 227, 227)
	#define X11_GREY_89                 MK_RGB(227, 227, 227)
	#define X11_GRAY90                  MK_RGB(229, 229, 229)
	#define X11_GRAY_90                 MK_RGB(229, 229, 229)
	#define X11_GREY90                  MK_RGB(229, 229, 229)
	#define X11_GREY_90                 MK_RGB(229, 229, 229)
	#define X11_GRAY91                  MK_RGB(232, 232, 232)
	#define X11_GRAY_91                 MK_RGB(232, 232, 232)
	#define X11_GREY91                  MK_RGB(232, 232, 232)
	#define X11_GREY_91                 MK_RGB(232, 232, 232)
	#define X11_GRAY92                  MK_RGB(235, 235, 235)
	#define X11_GRAY_92                 MK_RGB(235, 235, 235)
	#define X11_GREY92                  MK_RGB(235, 235, 235)
	#define X11_GREY_92                 MK_RGB(235, 235, 235)
	#define X11_GRAY93                  MK_RGB(237, 237, 237)
	#define X11_GRAY_93                 MK_RGB(237, 237, 237)
	#define X11_GREY93                  MK_RGB(237, 237, 237)
	#define X11_GREY_93                 MK_RGB(237, 237, 237)
	#define X11_GRAY94                  MK_RGB(240, 240, 240)
	#define X11_GRAY_94                 MK_RGB(240, 240, 240)
	#define X11_GREY94                  MK_RGB(240, 240, 240)
	#define X11_GREY_94                 MK_RGB(240, 240, 240)
	#define X11_GRAY95                  MK_RGB(242, 242, 242)
	#define X11_GRAY_95                 MK_RGB(242, 242, 242)
	#define X11_GREY95                  MK_RGB(242, 242, 242)
	#define X11_GREY_95                 MK_RGB(242, 242, 242)
	#define X11_GRAY96                  MK_RGB(245, 245, 245)
	#define X11_GRAY_96                 MK_RGB(245, 245, 245)
	#define X11_GREY96                  MK_RGB(245, 245, 245)
	#define X11_GREY_96                 MK_RGB(245, 245, 245)
	#define X11_GRAY97                  MK_RGB(247, 247, 247)
	#define X11_GRAY_97                 MK_RGB(247, 247, 247)
	#define X11_GREY97                  MK_RGB(247, 247, 247)
	#define X11_GREY_97                 MK_RGB(247, 247, 247)
	#define X11_GRAY98                  MK_RGB(250, 250, 250)
	#define X11_GRAY_98                 MK_RGB(250, 250, 250)
	#define X11_GREY98                  MK_RGB(250, 250, 250)
	#define X11_GREY_98                 MK_RGB(250, 250, 250)
	#define X11_GRAY99                  MK_RGB(252, 252, 252)
	#define X11_GRAY_99                 MK_RGB(252, 252, 252)
	#define X11_GREY99                  MK_RGB(252, 252, 252)
	#define X11_GREY_99                 MK_RGB(252, 252, 252)
	#define X11_GRAY100                 MK_RGB(255, 255, 255)
	#define X11_GRAY_100                MK_RGB(255, 255, 255)
	#define X11_GREY100                 MK_RGB(255, 255, 255)
	#define X11_GREY_100                MK_RGB(255, 255, 255)
	#define X11_DARKGREY                MK_RGB(169, 169, 169)
	#define X11_DARK_GREY               MK_RGB(169, 169, 169)
	#define X11_DARKGRAY                MK_RGB(169, 169, 169)
	#define X11_DARK_GRAY               MK_RGB(169, 169, 169)
	#define X11_DARKBLUE                MK_RGB(  0,   0, 139)
	#define X11_DARK_BLUE               MK_RGB(  0,   0, 139)
	#define X11_DARKCYAN                MK_RGB(  0, 139, 139)
	#define X11_DARK_CYAN               MK_RGB(  0, 139, 139)
	#define X11_DARKMAGENTA             MK_RGB(139,   0, 139)
	#define X11_DARK_MAGENTA            MK_RGB(139,   0, 139)
	#define X11_DARKRED                 MK_RGB(139,   0,   0)
	#define X11_DARK_RED                MK_RGB(139,   0,   0)
	#define X11_LIGHTGREEN              MK_RGB(144, 238, 144)
	#define X11_LIGHT_GREEN             MK_RGB(144, 238, 144)

	#define Y_SNOW                    MK_RGBA(255, 250, 250, 0)
	#define Y_GHOSTWHITE              MK_RGBA(248, 248, 255, 0)
	#define Y_GHOST_WHITE             MK_RGBA(248, 248, 255, 0)
	#define Y_WHITESMOKE              MK_RGBA(245, 245, 245, 0)
	#define Y_WHITE_SMOKE             MK_RGBA(245, 245, 245, 0)
	#define Y_GAINSBORO               MK_RGBA(220, 220, 220, 0)
	#define Y_FLORALWHITE             MK_RGBA(255, 250, 240, 0)
	#define Y_FLORAL_WHITE            MK_RGBA(255, 250, 240, 0)
	#define Y_OLDLACE                 MK_RGBA(253, 245, 230, 0)
	#define Y_OLD_LACE                MK_RGBA(253, 245, 230, 0)
	#define Y_LINEN                   MK_RGBA(250, 240, 230, 0)
	#define Y_ANTIQUEWHITE            MK_RGBA(250, 235, 215, 0)
	#define Y_ANTIQUE_WHITE           MK_RGBA(250, 235, 215, 0)
	#define Y_PAPAYAWHIP              MK_RGBA(255, 239, 213, 0)
	#define Y_PAPAYA_WHIP             MK_RGBA(255, 239, 213, 0)
	#define Y_BLANCHEDALMOND          MK_RGBA(255, 235, 205, 0)
	#define Y_BLANCHED_ALMOND         MK_RGBA(255, 235, 205, 0)
	#define Y_BISQUE                  MK_RGBA(255, 228, 196, 0)
	#define Y_PEACHPUFF               MK_RGBA(255, 218, 185, 0)
	#define Y_PEACH_PUFF              MK_RGBA(255, 218, 185, 0)
	#define Y_NAVAJOWHITE             MK_RGBA(255, 222, 173, 0)
	#define Y_NAVAJO_WHITE            MK_RGBA(255, 222, 173, 0)
	#define Y_MOCCASIN                MK_RGBA(255, 228, 181, 0)
	#define Y_CORNSILK                MK_RGBA(255, 248, 220, 0)
	#define Y_IVORY                   MK_RGBA(255, 255, 240, 0)
	#define Y_LEMONCHIFFON            MK_RGBA(255, 250, 205, 0)
	#define Y_LEMON_CHIFFON           MK_RGBA(255, 250, 205, 0)
	#define Y_SEASHELL                MK_RGBA(255, 245, 238, 0)
	#define Y_HONEYDEW                MK_RGBA(240, 255, 240, 0)
	#define Y_MINTCREAM               MK_RGBA(245, 255, 250, 0)
	#define Y_MINT_CREAM              MK_RGBA(245, 255, 250, 0)
	#define Y_AZURE                   MK_RGBA(240, 255, 255, 0)
	#define Y_ALICEBLUE               MK_RGBA(240, 248, 255, 0)
	#define Y_ALICE_BLUE              MK_RGBA(240, 248, 255, 0)
	#define Y_LAVENDER                MK_RGBA(230, 230, 250, 0)
	#define Y_LAVENDERBLUSH           MK_RGBA(255, 240, 245, 0)
	#define Y_LAVENDER_BLUSH          MK_RGBA(255, 240, 245, 0)
	#define Y_MISTYROSE               MK_RGBA(255, 228, 225, 0)
	#define Y_MISTY_ROSE              MK_RGBA(255, 228, 225, 0)
	#define Y_WHITE                   MK_RGBA(255, 255, 255, 0)
	#define Y_BLACK                   MK_RGBA(  0,   0,   0, 0)
	#define Y_DARKSLATEGRAY           MK_RGBA( 47,  79,  79, 0)
	#define Y_DARK_SLATE_GRAY         MK_RGBA( 47,  79,  79, 0)
	#define Y_DARKSLATEGREY           MK_RGBA( 47,  79,  79, 0)
	#define Y_DARK_SLATE_GREY         MK_RGBA( 47,  79,  79, 0)
	#define Y_DIMGRAY                 MK_RGBA(105, 105, 105, 0)
	#define Y_DIM_GRAY                MK_RGBA(105, 105, 105, 0)
	#define Y_DIMGREY                 MK_RGBA(105, 105, 105, 0)
	#define Y_DIM_GREY                MK_RGBA(105, 105, 105, 0)
	#define Y_SLATEGRAY               MK_RGBA(112, 128, 144, 0)
	#define Y_SLATE_GRAY              MK_RGBA(112, 128, 144, 0)
	#define Y_SLATEGREY               MK_RGBA(112, 128, 144, 0)
	#define Y_SLATE_GREY              MK_RGBA(112, 128, 144, 0)
	#define Y_LIGHTSLATEGRAY          MK_RGBA(119, 136, 153, 0)
	#define Y_LIGHT_SLATE_GRAY        MK_RGBA(119, 136, 153, 0)
	#define Y_LIGHTSLATEGREY          MK_RGBA(119, 136, 153, 0)
	#define Y_LIGHT_SLATE_GREY        MK_RGBA(119, 136, 153, 0)
	#define Y_GRAY                    MK_RGBA(190, 190, 190, 0)
	#define Y_GREY                    MK_RGBA(190, 190, 190, 0)
	#define Y_LIGHTGREY               MK_RGBA(211, 211, 211, 0)
	#define Y_LIGHT_GREY              MK_RGBA(211, 211, 211, 0)
	#define Y_LIGHTGRAY               MK_RGBA(211, 211, 211, 0)
	#define Y_LIGHT_GRAY              MK_RGBA(211, 211, 211, 0)
	#define Y_MIDNIGHTBLUE            MK_RGBA( 25,  25, 112, 0)
	#define Y_MIDNIGHT_BLUE           MK_RGBA( 25,  25, 112, 0)
	#define Y_NAVY                    MK_RGBA(  0,   0, 128, 0)
	#define Y_NAVYBLUE                MK_RGBA(  0,   0, 128, 0)
	#define Y_NAVY_BLUE               MK_RGBA(  0,   0, 128, 0)
	#define Y_CORNFLOWERBLUE          MK_RGBA(100, 149, 237, 0)
	#define Y_CORNFLOWER_BLUE         MK_RGBA(100, 149, 237, 0)
	#define Y_DARKSLATEBLUE           MK_RGBA( 72,  61, 139, 0)
	#define Y_DARK_SLATE_BLUE         MK_RGBA( 72,  61, 139, 0)
	#define Y_SLATEBLUE               MK_RGBA(106,  90, 205, 0)
	#define Y_SLATE_BLUE              MK_RGBA(106,  90, 205, 0)
	#define Y_MEDIUMSLATEBLUE         MK_RGBA(123, 104, 238, 0)
	#define Y_MEDIUM_SLATE_BLUE       MK_RGBA(123, 104, 238, 0)
	#define Y_LIGHTSLATEBLUE          MK_RGBA(132, 112, 255, 0)
	#define Y_LIGHT_SLATE_BLUE        MK_RGBA(132, 112, 255, 0)
	#define Y_MEDIUMBLUE              MK_RGBA(  0,   0, 205, 0)
	#define Y_MEDIUM_BLUE             MK_RGBA(  0,   0, 205, 0)
	#define Y_ROYALBLUE               MK_RGBA( 65, 105, 225, 0)
	#define Y_ROYAL_BLUE              MK_RGBA( 65, 105, 225, 0)
	#define Y_BLUE                    MK_RGBA(  0,   0, 255, 0)
	#define Y_DODGERBLUE              MK_RGBA( 30, 144, 255, 0)
	#define Y_DODGER_BLUE             MK_RGBA( 30, 144, 255, 0)
	#define Y_DEEPSKYBLUE             MK_RGBA(  0, 191, 255, 0)
	#define Y_DEEP_SKY_BLUE           MK_RGBA(  0, 191, 255, 0)
	#define Y_SKYBLUE                 MK_RGBA(135, 206, 235, 0)
	#define Y_SKY_BLUE                MK_RGBA(135, 206, 235, 0)
	#define Y_LIGHTSKYBLUE            MK_RGBA(135, 206, 250, 0)
	#define Y_LIGHT_SKY_BLUE          MK_RGBA(135, 206, 250, 0)
	#define Y_STEELBLUE               MK_RGBA( 70, 130, 180, 0)
	#define Y_STEEL_BLUE              MK_RGBA( 70, 130, 180, 0)
	#define Y_LIGHTSTEELBLUE          MK_RGBA(176, 196, 222, 0)
	#define Y_LIGHT_STEEL_BLUE        MK_RGBA(176, 196, 222, 0)
	#define Y_LIGHTBLUE               MK_RGBA(173, 216, 230, 0)
	#define Y_LIGHT_BLUE              MK_RGBA(173, 216, 230, 0)
	#define Y_POWDERBLUE              MK_RGBA(176, 224, 230, 0)
	#define Y_POWDER_BLUE             MK_RGBA(176, 224, 230, 0)
	#define Y_PALETURQUOISE           MK_RGBA(175, 238, 238, 0)
	#define Y_PALE_TURQUOISE          MK_RGBA(175, 238, 238, 0)
	#define Y_DARKTURQUOISE           MK_RGBA(  0, 206, 209, 0)
	#define Y_DARK_TURQUOISE          MK_RGBA(  0, 206, 209, 0)
	#define Y_MEDIUMTURQUOISE         MK_RGBA( 72, 209, 204, 0)
	#define Y_MEDIUM_TURQUOISE        MK_RGBA( 72, 209, 204, 0)
	#define Y_TURQUOISE               MK_RGBA( 64, 224, 208, 0)
	#define Y_CYAN                    MK_RGBA(  0, 255, 255, 0)
	#define Y_LIGHTCYAN               MK_RGBA(224, 255, 255, 0)
	#define Y_LIGHT_CYAN              MK_RGBA(224, 255, 255, 0)
	#define Y_CADETBLUE               MK_RGBA( 95, 158, 160, 0)
	#define Y_CADET_BLUE              MK_RGBA( 95, 158, 160, 0)
	#define Y_MEDIUMAQUAMARINE        MK_RGBA(102, 205, 170, 0)
	#define Y_MEDIUM_AQUAMARINE       MK_RGBA(102, 205, 170, 0)
	#define Y_AQUAMARINE              MK_RGBA(127, 255, 212, 0)
	#define Y_DARKGREEN               MK_RGBA(  0, 100,   0, 0)
	#define Y_DARK_GREEN              MK_RGBA(  0, 100,   0, 0)
	#define Y_DARKOLIVEGREEN          MK_RGBA( 85, 107,  47, 0)
	#define Y_DARK_OLIVE_GREEN        MK_RGBA( 85, 107,  47, 0)
	#define Y_DARKSEAGREEN            MK_RGBA(143, 188, 143, 0)
	#define Y_DARK_SEA_GREEN          MK_RGBA(143, 188, 143, 0)
	#define Y_SEAGREEN                MK_RGBA( 46, 139,  87, 0)
	#define Y_SEA_GREEN               MK_RGBA( 46, 139,  87, 0)
	#define Y_MEDIUMSEAGREEN          MK_RGBA( 60, 179, 113, 0)
	#define Y_MEDIUM_SEA_GREEN        MK_RGBA( 60, 179, 113, 0)
	#define Y_LIGHTSEAGREEN           MK_RGBA( 32, 178, 170, 0)
	#define Y_LIGHT_SEA_GREEN         MK_RGBA( 32, 178, 170, 0)
	#define Y_PALEGREEN               MK_RGBA(152, 251, 152, 0)
	#define Y_PALE_GREEN              MK_RGBA(152, 251, 152, 0)
	#define Y_SPRINGGREEN             MK_RGBA(  0, 255, 127, 0)
	#define Y_SPRING_GREEN            MK_RGBA(  0, 255, 127, 0)
	#define Y_LAWNGREEN               MK_RGBA(124, 252,   0, 0)
	#define Y_LAWN_GREEN              MK_RGBA(124, 252,   0, 0)
	#define Y_GREEN                   MK_RGBA(  0, 255,   0, 0)
	#define Y_CHARTREUSE              MK_RGBA(127, 255,   0, 0)
	#define Y_MEDIUMSPRINGGREEN       MK_RGBA(  0, 250, 154, 0)
	#define Y_MEDIUM_SPRING_GREEN     MK_RGBA(  0, 250, 154, 0)
	#define Y_GREENYELLOW             MK_RGBA(173, 255,  47, 0)
	#define Y_GREEN_YELLOW            MK_RGBA(173, 255,  47, 0)
	#define Y_LIMEGREEN               MK_RGBA( 50, 205,  50, 0)
	#define Y_LIME_GREEN              MK_RGBA( 50, 205,  50, 0)
	#define Y_YELLOWGREEN             MK_RGBA(154, 205,  50, 0)
	#define Y_YELLOW_GREEN            MK_RGBA(154, 205,  50, 0)
	#define Y_FORESTGREEN             MK_RGBA( 34, 139,  34, 0)
	#define Y_FOREST_GREEN            MK_RGBA( 34, 139,  34, 0)
	#define Y_OLIVEDRAB               MK_RGBA(107, 142,  35, 0)
	#define Y_OLIVE_DRAB              MK_RGBA(107, 142,  35, 0)
	#define Y_DARKKHAKI               MK_RGBA(189, 183, 107, 0)
	#define Y_DARK_KHAKI              MK_RGBA(189, 183, 107, 0)
	#define Y_KHAKI                   MK_RGBA(240, 230, 140, 0)
	#define Y_PALEGOLDENROD           MK_RGBA(238, 232, 170, 0)
	#define Y_PALE_GOLDENROD          MK_RGBA(238, 232, 170, 0)
	#define Y_LIGHTGOLDENRODYELLOW    MK_RGBA(250, 250, 210, 0)
	#define Y_LIGHT_GOLDENROD_YELLOW  MK_RGBA(250, 250, 210, 0)
	#define Y_LIGHTYELLOW             MK_RGBA(255, 255, 224, 0)
	#define Y_LIGHT_YELLOW            MK_RGBA(255, 255, 224, 0)
	#define Y_YELLOW                  MK_RGBA(255, 255,   0, 0)
	#define Y_GOLD                    MK_RGBA(255, 215,   0, 0)
	#define Y_LIGHTGOLDENROD          MK_RGBA(238, 221, 130, 0)
	#define Y_LIGHT_GOLDENROD         MK_RGBA(238, 221, 130, 0)
	#define Y_GOLDENROD               MK_RGBA(218, 165,  32, 0)
	#define Y_DARKGOLDENROD           MK_RGBA(184, 134,  11, 0)
	#define Y_DARK_GOLDENROD          MK_RGBA(184, 134,  11, 0)
	#define Y_ROSYBROWN               MK_RGBA(188, 143, 143, 0)
	#define Y_ROSY_BROWN              MK_RGBA(188, 143, 143, 0)
	#define Y_INDIANRED               MK_RGBA(205,  92,  92, 0)
	#define Y_INDIAN_RED              MK_RGBA(205,  92,  92, 0)
	#define Y_SADDLEBROWN             MK_RGBA(139,  69,  19, 0)
	#define Y_SADDLE_BROWN            MK_RGBA(139,  69,  19, 0)
	#define Y_SIENNA                  MK_RGBA(160,  82,  45, 0)
	#define Y_PERU                    MK_RGBA(205, 133,  63, 0)
	#define Y_BURLYWOOD               MK_RGBA(222, 184, 135, 0)
	#define Y_BEIGE                   MK_RGBA(245, 245, 220, 0)
	#define Y_WHEAT                   MK_RGBA(245, 222, 179, 0)
	#define Y_SANDYBROWN              MK_RGBA(244, 164,  96, 0)
	#define Y_SANDY_BROWN             MK_RGBA(244, 164,  96, 0)
	#define Y_TAN                     MK_RGBA(210, 180, 140, 0)
	#define Y_CHOCOLATE               MK_RGBA(210, 105,  30, 0)
	#define Y_FIREBRICK               MK_RGBA(178,  34,  34, 0)
	#define Y_BROWN                   MK_RGBA(165,  42,  42, 0)
	#define Y_DARKSALMON              MK_RGBA(233, 150, 122, 0)
	#define Y_DARK_SALMON             MK_RGBA(233, 150, 122, 0)
	#define Y_SALMON                  MK_RGBA(250, 128, 114, 0)
	#define Y_LIGHTSALMON             MK_RGBA(255, 160, 122, 0)
	#define Y_LIGHT_SALMON            MK_RGBA(255, 160, 122, 0)
	#define Y_ORANGE                  MK_RGBA(255, 165,   0, 0)
	#define Y_DARKORANGE              MK_RGBA(255, 140,   0, 0)
	#define Y_DARK_ORANGE             MK_RGBA(255, 140,   0, 0)
	#define Y_CORAL                   MK_RGBA(255, 127,  80, 0)
	#define Y_LIGHTCORAL              MK_RGBA(240, 128, 128, 0)
	#define Y_LIGHT_CORAL             MK_RGBA(240, 128, 128, 0)
	#define Y_TOMATO                  MK_RGBA(255,  99,  71, 0)
	#define Y_ORANGERED               MK_RGBA(255,  69,   0, 0)
	#define Y_ORANGE_RED              MK_RGBA(255,  69,   0, 0)
	#define Y_RED                     MK_RGBA(255,   0,   0, 0)
	#define Y_HOTPINK                 MK_RGBA(255, 105, 180, 0)
	#define Y_HOT_PINK                MK_RGBA(255, 105, 180, 0)
	#define Y_DEEPPINK                MK_RGBA(255,  20, 147, 0)
	#define Y_DEEP_PINK               MK_RGBA(255,  20, 147, 0)
	#define Y_PINK                    MK_RGBA(255, 192, 203, 0)
	#define Y_LIGHTPINK               MK_RGBA(255, 182, 193, 0)
	#define Y_LIGHT_PINK              MK_RGBA(255, 182, 193, 0)
	#define Y_PALEVIOLETRED           MK_RGBA(219, 112, 147, 0)
	#define Y_PALE_VIOLET_RED         MK_RGBA(219, 112, 147, 0)
	#define Y_MAROON                  MK_RGBA(176,  48,  96, 0)
	#define Y_MEDIUMVIOLETRED         MK_RGBA(199,  21, 133, 0)
	#define Y_MEDIUM_VIOLET_RED       MK_RGBA(199,  21, 133, 0)
	#define Y_VIOLETRED               MK_RGBA(208,  32, 144, 0)
	#define Y_VIOLET_RED              MK_RGBA(208,  32, 144, 0)
	#define Y_MAGENTA                 MK_RGBA(255,   0, 255, 0)
	#define Y_VIOLET                  MK_RGBA(238, 130, 238, 0)
	#define Y_PLUM                    MK_RGBA(221, 160, 221, 0)
	#define Y_ORCHID                  MK_RGBA(218, 112, 214, 0)
	#define Y_MEDIUMORCHID            MK_RGBA(186,  85, 211, 0)
	#define Y_MEDIUM_ORCHID           MK_RGBA(186,  85, 211, 0)
	#define Y_DARKORCHID              MK_RGBA(153,  50, 204, 0)
	#define Y_DARK_ORCHID             MK_RGBA(153,  50, 204, 0)
	#define Y_DARKVIOLET              MK_RGBA(148,   0, 211, 0)
	#define Y_DARK_VIOLET             MK_RGBA(148,   0, 211, 0)
	#define Y_BLUEVIOLET              MK_RGBA(138,  43, 226, 0)
	#define Y_BLUE_VIOLET             MK_RGBA(138,  43, 226, 0)
	#define Y_PURPLE                  MK_RGBA(160,  32, 240, 0)
	#define Y_MEDIUMPURPLE            MK_RGBA(147, 112, 219, 0)
	#define Y_MEDIUM_PURPLE           MK_RGBA(147, 112, 219, 0)
	#define Y_THISTLE                 MK_RGBA(216, 191, 216, 0)
	#define Y_SNOW1                   MK_RGBA(255, 250, 250, 0)
	#define Y_SNOW_1                  MK_RGBA(255, 250, 250, 0)
	#define Y_SNOW2                   MK_RGBA(238, 233, 233, 0)
	#define Y_SNOW_2                  MK_RGBA(238, 233, 233, 0)
	#define Y_SNOW3                   MK_RGBA(205, 201, 201, 0)
	#define Y_SNOW_3                  MK_RGBA(205, 201, 201, 0)
	#define Y_SNOW4                   MK_RGBA(139, 137, 137, 0)
	#define Y_SNOW_4                  MK_RGBA(139, 137, 137, 0)
	#define Y_SEASHELL1               MK_RGBA(255, 245, 238, 0)
	#define Y_SEASHELL_1              MK_RGBA(255, 245, 238, 0)
	#define Y_SEASHELL2               MK_RGBA(238, 229, 222, 0)
	#define Y_SEASHELL_2              MK_RGBA(238, 229, 222, 0)
	#define Y_SEASHELL3               MK_RGBA(205, 197, 191, 0)
	#define Y_SEASHELL_3              MK_RGBA(205, 197, 191, 0)
	#define Y_SEASHELL4               MK_RGBA(139, 134, 130, 0)
	#define Y_SEASHELL_4              MK_RGBA(139, 134, 130, 0)
	#define Y_ANTIQUEWHITE1           MK_RGBA(255, 239, 219, 0)
	#define Y_ANTIQUE_WHITE_1         MK_RGBA(255, 239, 219, 0)
	#define Y_ANTIQUEWHITE2           MK_RGBA(238, 223, 204, 0)
	#define Y_ANTIQUE_WHITE_2         MK_RGBA(238, 223, 204, 0)
	#define Y_ANTIQUEWHITE3           MK_RGBA(205, 192, 176, 0)
	#define Y_ANTIQUE_WHITE_3         MK_RGBA(205, 192, 176, 0)
	#define Y_ANTIQUEWHITE4           MK_RGBA(139, 131, 120, 0)
	#define Y_ANTIQUE_WHITE_4         MK_RGBA(139, 131, 120, 0)
	#define Y_BISQUE1                 MK_RGBA(255, 228, 196, 0)
	#define Y_BISQUE_1                MK_RGBA(255, 228, 196, 0)
	#define Y_BISQUE2                 MK_RGBA(238, 213, 183, 0)
	#define Y_BISQUE_2                MK_RGBA(238, 213, 183, 0)
	#define Y_BISQUE3                 MK_RGBA(205, 183, 158, 0)
	#define Y_BISQUE_3                MK_RGBA(205, 183, 158, 0)
	#define Y_BISQUE4                 MK_RGBA(139, 125, 107, 0)
	#define Y_BISQUE_4                MK_RGBA(139, 125, 107, 0)
	#define Y_PEACHPUFF1              MK_RGBA(255, 218, 185, 0)
	#define Y_PEACH_PUFF_1            MK_RGBA(255, 218, 185, 0)
	#define Y_PEACHPUFF2              MK_RGBA(238, 203, 173, 0)
	#define Y_PEACH_PUFF_2            MK_RGBA(238, 203, 173, 0)
	#define Y_PEACHPUFF3              MK_RGBA(205, 175, 149, 0)
	#define Y_PEACH_PUFF_3            MK_RGBA(205, 175, 149, 0)
	#define Y_PEACHPUFF4              MK_RGBA(139, 119, 101, 0)
	#define Y_PEACH_PUFF_4            MK_RGBA(139, 119, 101, 0)
	#define Y_NAVAJOWHITE1            MK_RGBA(255, 222, 173, 0)
	#define Y_NAVAJO_WHITE_1          MK_RGBA(255, 222, 173, 0)
	#define Y_NAVAJOWHITE2            MK_RGBA(238, 207, 161, 0)
	#define Y_NAVAJO_WHITE_2          MK_RGBA(238, 207, 161, 0)
	#define Y_NAVAJOWHITE3            MK_RGBA(205, 179, 139, 0)
	#define Y_NAVAJO_WHITE_3          MK_RGBA(205, 179, 139, 0)
	#define Y_NAVAJOWHITE4            MK_RGBA(139, 121,  94, 0)
	#define Y_NAVAJO_WHITE_4          MK_RGBA(139, 121,  94, 0)
	#define Y_LEMONCHIFFON1           MK_RGBA(255, 250, 205, 0)
	#define Y_LEMON_CHIFFON_1         MK_RGBA(255, 250, 205, 0)
	#define Y_LEMONCHIFFON2           MK_RGBA(238, 233, 191, 0)
	#define Y_LEMON_CHIFFON_2         MK_RGBA(238, 233, 191, 0)
	#define Y_LEMONCHIFFON3           MK_RGBA(205, 201, 165, 0)
	#define Y_LEMON_CHIFFON_3         MK_RGBA(205, 201, 165, 0)
	#define Y_LEMONCHIFFON4           MK_RGBA(139, 137, 112, 0)
	#define Y_LEMON_CHIFFON_4         MK_RGBA(139, 137, 112, 0)
	#define Y_CORNSILK1               MK_RGBA(255, 248, 220, 0)
	#define Y_CORNSILK_1              MK_RGBA(255, 248, 220, 0)
	#define Y_CORNSILK2               MK_RGBA(238, 232, 205, 0)
	#define Y_CORNSILK_2              MK_RGBA(238, 232, 205, 0)
	#define Y_CORNSILK3               MK_RGBA(205, 200, 177, 0)
	#define Y_CORNSILK_3              MK_RGBA(205, 200, 177, 0)
	#define Y_CORNSILK4               MK_RGBA(139, 136, 120, 0)
	#define Y_CORNSILK_4              MK_RGBA(139, 136, 120, 0)
	#define Y_IVORY1                  MK_RGBA(255, 255, 240, 0)
	#define Y_IVORY_1                 MK_RGBA(255, 255, 240, 0)
	#define Y_IVORY2                  MK_RGBA(238, 238, 224, 0)
	#define Y_IVORY_2                 MK_RGBA(238, 238, 224, 0)
	#define Y_IVORY3                  MK_RGBA(205, 205, 193, 0)
	#define Y_IVORY_3                 MK_RGBA(205, 205, 193, 0)
	#define Y_IVORY4                  MK_RGBA(139, 139, 131, 0)
	#define Y_IVORY_4                 MK_RGBA(139, 139, 131, 0)
	#define Y_HONEYDEW1               MK_RGBA(240, 255, 240, 0)
	#define Y_HONEYDEW_1              MK_RGBA(240, 255, 240, 0)
	#define Y_HONEYDEW2               MK_RGBA(224, 238, 224, 0)
	#define Y_HONEYDEW_2              MK_RGBA(224, 238, 224, 0)
	#define Y_HONEYDEW3               MK_RGBA(193, 205, 193, 0)
	#define Y_HONEYDEW_3              MK_RGBA(193, 205, 193, 0)
	#define Y_HONEYDEW4               MK_RGBA(131, 139, 131, 0)
	#define Y_HONEYDEW_4              MK_RGBA(131, 139, 131, 0)
	#define Y_LAVENDERBLUSH1          MK_RGBA(255, 240, 245, 0)
	#define Y_LAVENDER_BLUSH_1        MK_RGBA(255, 240, 245, 0)
	#define Y_LAVENDERBLUSH2          MK_RGBA(238, 224, 229, 0)
	#define Y_LAVENDER_BLUSH_2        MK_RGBA(238, 224, 229, 0)
	#define Y_LAVENDERBLUSH3          MK_RGBA(205, 193, 197, 0)
	#define Y_LAVENDER_BLUSH_3        MK_RGBA(205, 193, 197, 0)
	#define Y_LAVENDERBLUSH4          MK_RGBA(139, 131, 134, 0)
	#define Y_LAVENDER_BLUSH_4        MK_RGBA(139, 131, 134, 0)
	#define Y_MISTYROSE1              MK_RGBA(255, 228, 225, 0)
	#define Y_MISTY_ROSE_1            MK_RGBA(255, 228, 225, 0)
	#define Y_MISTYROSE2              MK_RGBA(238, 213, 210, 0)
	#define Y_MISTY_ROSE_2            MK_RGBA(238, 213, 210, 0)
	#define Y_MISTYROSE3              MK_RGBA(205, 183, 181, 0)
	#define Y_MISTY_ROSE_3            MK_RGBA(205, 183, 181, 0)
	#define Y_MISTYROSE4              MK_RGBA(139, 125, 123, 0)
	#define Y_MISTY_ROSE_4            MK_RGBA(139, 125, 123, 0)
	#define Y_AZURE1                  MK_RGBA(240, 255, 255, 0)
	#define Y_AZURE_1                 MK_RGBA(240, 255, 255, 0)
	#define Y_AZURE2                  MK_RGBA(224, 238, 238, 0)
	#define Y_AZURE_2                 MK_RGBA(224, 238, 238, 0)
	#define Y_AZURE3                  MK_RGBA(193, 205, 205, 0)
	#define Y_AZURE_3                 MK_RGBA(193, 205, 205, 0)
	#define Y_AZURE4                  MK_RGBA(131, 139, 139, 0)
	#define Y_AZURE_4                 MK_RGBA(131, 139, 139, 0)
	#define Y_SLATEBLUE1              MK_RGBA(131, 111, 255, 0)
	#define Y_SLATE_BLUE_1            MK_RGBA(131, 111, 255, 0)
	#define Y_SLATEBLUE2              MK_RGBA(122, 103, 238, 0)
	#define Y_SLATE_BLUE_2            MK_RGBA(122, 103, 238, 0)
	#define Y_SLATEBLUE3              MK_RGBA(105,  89, 205, 0)
	#define Y_SLATE_BLUE_3            MK_RGBA(105,  89, 205, 0)
	#define Y_SLATEBLUE4              MK_RGBA( 71,  60, 139, 0)
	#define Y_SLATE_BLUE_4            MK_RGBA( 71,  60, 139, 0)
	#define Y_ROYALBLUE1              MK_RGBA( 72, 118, 255, 0)
	#define Y_ROYAL_BLUE_1            MK_RGBA( 72, 118, 255, 0)
	#define Y_ROYALBLUE2              MK_RGBA( 67, 110, 238, 0)
	#define Y_ROYAL_BLUE_2            MK_RGBA( 67, 110, 238, 0)
	#define Y_ROYALBLUE3              MK_RGBA( 58,  95, 205, 0)
	#define Y_ROYAL_BLUE_3            MK_RGBA( 58,  95, 205, 0)
	#define Y_ROYALBLUE4              MK_RGBA( 39,  64, 139, 0)
	#define Y_ROYAL_BLUE_4            MK_RGBA( 39,  64, 139, 0)
	#define Y_BLUE1                   MK_RGBA(  0,   0, 255, 0)
	#define Y_BLUE_1                  MK_RGBA(  0,   0, 255, 0)
	#define Y_BLUE2                   MK_RGBA(  0,   0, 238, 0)
	#define Y_BLUE_2                  MK_RGBA(  0,   0, 238, 0)
	#define Y_BLUE3                   MK_RGBA(  0,   0, 205, 0)
	#define Y_BLUE_3                  MK_RGBA(  0,   0, 205, 0)
	#define Y_BLUE4                   MK_RGBA(  0,   0, 139, 0)
	#define Y_BLUE_4                  MK_RGBA(  0,   0, 139, 0)
	#define Y_DODGERBLUE1             MK_RGBA( 30, 144, 255, 0)
	#define Y_DODGER_BLUE_1           MK_RGBA( 30, 144, 255, 0)
	#define Y_DODGERBLUE2             MK_RGBA( 28, 134, 238, 0)
	#define Y_DODGER_BLUE_2           MK_RGBA( 28, 134, 238, 0)
	#define Y_DODGERBLUE3             MK_RGBA( 24, 116, 205, 0)
	#define Y_DODGER_BLUE_3           MK_RGBA( 24, 116, 205, 0)
	#define Y_DODGERBLUE4             MK_RGBA( 16,  78, 139, 0)
	#define Y_DODGER_BLUE_4           MK_RGBA( 16,  78, 139, 0)
	#define Y_STEELBLUE1              MK_RGBA( 99, 184, 255, 0)
	#define Y_STEEL_BLUE_1            MK_RGBA( 99, 184, 255, 0)
	#define Y_STEELBLUE2              MK_RGBA( 92, 172, 238, 0)
	#define Y_STEEL_BLUE_2            MK_RGBA( 92, 172, 238, 0)
	#define Y_STEELBLUE3              MK_RGBA( 79, 148, 205, 0)
	#define Y_STEEL_BLUE_3            MK_RGBA( 79, 148, 205, 0)
	#define Y_STEELBLUE4              MK_RGBA( 54, 100, 139, 0)
	#define Y_STEEL_BLUE_4            MK_RGBA( 54, 100, 139, 0)
	#define Y_DEEPSKYBLUE1            MK_RGBA(  0, 191, 255, 0)
	#define Y_DEEP_SKY_BLUE_1         MK_RGBA(  0, 191, 255, 0)
	#define Y_DEEPSKYBLUE2            MK_RGBA(  0, 178, 238, 0)
	#define Y_DEEP_SKY_BLUE_2         MK_RGBA(  0, 178, 238, 0)
	#define Y_DEEPSKYBLUE3            MK_RGBA(  0, 154, 205, 0)
	#define Y_DEEP_SKY_BLUE_3         MK_RGBA(  0, 154, 205, 0)
	#define Y_DEEPSKYBLUE4            MK_RGBA(  0, 104, 139, 0)
	#define Y_DEEP_SKY_BLUE_4         MK_RGBA(  0, 104, 139, 0)
	#define Y_SKYBLUE1                MK_RGBA(135, 206, 255, 0)
	#define Y_SKY_BLUE_1              MK_RGBA(135, 206, 255, 0)
	#define Y_SKYBLUE2                MK_RGBA(126, 192, 238, 0)
	#define Y_SKY_BLUE_2              MK_RGBA(126, 192, 238, 0)
	#define Y_SKYBLUE3                MK_RGBA(108, 166, 205, 0)
	#define Y_SKY_BLUE_3              MK_RGBA(108, 166, 205, 0)
	#define Y_SKYBLUE4                MK_RGBA( 74, 112, 139, 0)
	#define Y_SKY_BLUE_4              MK_RGBA( 74, 112, 139, 0)
	#define Y_LIGHTSKYBLUE1           MK_RGBA(176, 226, 255, 0)
	#define Y_LIGHT_SKY_BLUE_1        MK_RGBA(176, 226, 255, 0)
	#define Y_LIGHTSKYBLUE2           MK_RGBA(164, 211, 238, 0)
	#define Y_LIGHT_SKY_BLUE_2        MK_RGBA(164, 211, 238, 0)
	#define Y_LIGHTSKYBLUE3           MK_RGBA(141, 182, 205, 0)
	#define Y_LIGHT_SKY_BLUE_3        MK_RGBA(141, 182, 205, 0)
	#define Y_LIGHTSKYBLUE4           MK_RGBA( 96, 123, 139, 0)
	#define Y_LIGHT_SKY_BLUE_4        MK_RGBA( 96, 123, 139, 0)
	#define Y_SLATEGRAY1              MK_RGBA(198, 226, 255, 0)
	#define Y_SLATE_GRAY_1            MK_RGBA(198, 226, 255, 0)
	#define Y_SLATEGRAY2              MK_RGBA(185, 211, 238, 0)
	#define Y_SLATE_GRAY_2            MK_RGBA(185, 211, 238, 0)
	#define Y_SLATEGRAY3              MK_RGBA(159, 182, 205, 0)
	#define Y_SLATE_GRAY_3            MK_RGBA(159, 182, 205, 0)
	#define Y_SLATEGRAY4              MK_RGBA(108, 123, 139, 0)
	#define Y_SLATE_GRAY_4            MK_RGBA(108, 123, 139, 0)
	#define Y_SLATEGREY1              MK_RGBA(198, 226, 255, 0)
	#define Y_SLATE_GREY_1            MK_RGBA(198, 226, 255, 0)
	#define Y_SLATEGREY2              MK_RGBA(185, 211, 238, 0)
	#define Y_SLATE_GREY_2            MK_RGBA(185, 211, 238, 0)
	#define Y_SLATEGREY3              MK_RGBA(159, 182, 205, 0)
	#define Y_SLATE_GREY_3            MK_RGBA(159, 182, 205, 0)
	#define Y_SLATEGREY4              MK_RGBA(108, 123, 139, 0)
	#define Y_SLATE_GREY_4            MK_RGBA(108, 123, 139, 0)
	#define Y_LIGHTSTEELBLUE1         MK_RGBA(202, 225, 255, 0)
	#define Y_LIGHT_STEEL_BLUE_1      MK_RGBA(202, 225, 255, 0)
	#define Y_LIGHTSTEELBLUE2         MK_RGBA(188, 210, 238, 0)
	#define Y_LIGHT_STEEL_BLUE_2      MK_RGBA(188, 210, 238, 0)
	#define Y_LIGHTSTEELBLUE3         MK_RGBA(162, 181, 205, 0)
	#define Y_LIGHT_STEEL_BLUE_3      MK_RGBA(162, 181, 205, 0)
	#define Y_LIGHTSTEELBLUE4         MK_RGBA(110, 123, 139, 0)
	#define Y_LIGHT_STEEL_BLUE_4      MK_RGBA(110, 123, 139, 0)
	#define Y_LIGHTBLUE1              MK_RGBA(191, 239, 255, 0)
	#define Y_LIGHT_BLUE_1            MK_RGBA(191, 239, 255, 0)
	#define Y_LIGHTBLUE2              MK_RGBA(178, 223, 238, 0)
	#define Y_LIGHT_BLUE_2            MK_RGBA(178, 223, 238, 0)
	#define Y_LIGHTBLUE3              MK_RGBA(154, 192, 205, 0)
	#define Y_LIGHT_BLUE_3            MK_RGBA(154, 192, 205, 0)
	#define Y_LIGHTBLUE4              MK_RGBA(104, 131, 139, 0)
	#define Y_LIGHT_BLUE_4            MK_RGBA(104, 131, 139, 0)
	#define Y_LIGHTCYAN1              MK_RGBA(224, 255, 255, 0)
	#define Y_LIGHT_CYAN_1            MK_RGBA(224, 255, 255, 0)
	#define Y_LIGHTCYAN2              MK_RGBA(209, 238, 238, 0)
	#define Y_LIGHT_CYAN_2            MK_RGBA(209, 238, 238, 0)
	#define Y_LIGHTCYAN3              MK_RGBA(180, 205, 205, 0)
	#define Y_LIGHT_CYAN_3            MK_RGBA(180, 205, 205, 0)
	#define Y_LIGHTCYAN4              MK_RGBA(122, 139, 139, 0)
	#define Y_LIGHT_CYAN_4            MK_RGBA(122, 139, 139, 0)
	#define Y_PALETURQUOISE1          MK_RGBA(187, 255, 255, 0)
	#define Y_PALE_TURQUOISE_1        MK_RGBA(187, 255, 255, 0)
	#define Y_PALETURQUOISE2          MK_RGBA(174, 238, 238, 0)
	#define Y_PALE_TURQUOISE_2        MK_RGBA(174, 238, 238, 0)
	#define Y_PALETURQUOISE3          MK_RGBA(150, 205, 205, 0)
	#define Y_PALE_TURQUOISE_3        MK_RGBA(150, 205, 205, 0)
	#define Y_PALETURQUOISE4          MK_RGBA(102, 139, 139, 0)
	#define Y_PALE_TURQUOISE_4        MK_RGBA(102, 139, 139, 0)
	#define Y_CADETBLUE1              MK_RGBA(152, 245, 255, 0)
	#define Y_CADET_BLUE_1            MK_RGBA(152, 245, 255, 0)
	#define Y_CADETBLUE2              MK_RGBA(142, 229, 238, 0)
	#define Y_CADET_BLUE_2            MK_RGBA(142, 229, 238, 0)
	#define Y_CADETBLUE3              MK_RGBA(122, 197, 205, 0)
	#define Y_CADET_BLUE_3            MK_RGBA(122, 197, 205, 0)
	#define Y_CADETBLUE4              MK_RGBA( 83, 134, 139, 0)
	#define Y_CADET_BLUE_4            MK_RGBA( 83, 134, 139, 0)
	#define Y_TURQUOISE1              MK_RGBA(  0, 245, 255, 0)
	#define Y_TURQUOISE_1             MK_RGBA(  0, 245, 255, 0)
	#define Y_TURQUOISE2              MK_RGBA(  0, 229, 238, 0)
	#define Y_TURQUOISE_2             MK_RGBA(  0, 229, 238, 0)
	#define Y_TURQUOISE3              MK_RGBA(  0, 197, 205, 0)
	#define Y_TURQUOISE_3             MK_RGBA(  0, 197, 205, 0)
	#define Y_TURQUOISE4              MK_RGBA(  0, 134, 139, 0)
	#define Y_TURQUOISE_4             MK_RGBA(  0, 134, 139, 0)
	#define Y_CYAN1                   MK_RGBA(  0, 255, 255, 0)
	#define Y_CYAN_1                  MK_RGBA(  0, 255, 255, 0)
	#define Y_CYAN2                   MK_RGBA(  0, 238, 238, 0)
	#define Y_CYAN_2                  MK_RGBA(  0, 238, 238, 0)
	#define Y_CYAN3                   MK_RGBA(  0, 205, 205, 0)
	#define Y_CYAN_3                  MK_RGBA(  0, 205, 205, 0)
	#define Y_CYAN4                   MK_RGBA(  0, 139, 139, 0)
	#define Y_CYAN_4                  MK_RGBA(  0, 139, 139, 0)
	#define Y_DARKSLATEGRAY1          MK_RGBA(151, 255, 255, 0)
	#define Y_DARK_SLATE_GRAY_1       MK_RGBA(151, 255, 255, 0)
	#define Y_DARKSLATEGRAY2          MK_RGBA(141, 238, 238, 0)
	#define Y_DARK_SLATE_GRAY_2       MK_RGBA(141, 238, 238, 0)
	#define Y_DARKSLATEGRAY3          MK_RGBA(121, 205, 205, 0)
	#define Y_DARK_SLATE_GRAY_3       MK_RGBA(121, 205, 205, 0)
	#define Y_DARKSLATEGRAY4          MK_RGBA( 82, 139, 139, 0)
	#define Y_DARK_SLATE_GRAY_4       MK_RGBA( 82, 139, 139, 0)
	#define Y_DARKSLATEGREY1          MK_RGBA(151, 255, 255, 0)
	#define Y_DARK_SLATE_GREY_1       MK_RGBA(151, 255, 255, 0)
	#define Y_DARKSLATEGREY2          MK_RGBA(141, 238, 238, 0)
	#define Y_DARK_SLATE_GREY_2       MK_RGBA(141, 238, 238, 0)
	#define Y_DARKSLATEGREY3          MK_RGBA(121, 205, 205, 0)
	#define Y_DARK_SLATE_GREY_3       MK_RGBA(121, 205, 205, 0)
	#define Y_DARKSLATEGREY4          MK_RGBA( 82, 139, 139, 0)
	#define Y_DARK_SLATE_GREY_4       MK_RGBA( 82, 139, 139, 0)
	#define Y_AQUAMARINE1             MK_RGBA(127, 255, 212, 0)
	#define Y_AQUAMARINE_1            MK_RGBA(127, 255, 212, 0)
	#define Y_AQUAMARINE2             MK_RGBA(118, 238, 198, 0)
	#define Y_AQUAMARINE_2            MK_RGBA(118, 238, 198, 0)
	#define Y_AQUAMARINE3             MK_RGBA(102, 205, 170, 0)
	#define Y_AQUAMARINE_3            MK_RGBA(102, 205, 170, 0)
	#define Y_AQUAMARINE4             MK_RGBA( 69, 139, 116, 0)
	#define Y_AQUAMARINE_4            MK_RGBA( 69, 139, 116, 0)
	#define Y_DARKSEAGREEN1           MK_RGBA(193, 255, 193, 0)
	#define Y_DARK_SEA_GREEN_1        MK_RGBA(193, 255, 193, 0)
	#define Y_DARKSEAGREEN2           MK_RGBA(180, 238, 180, 0)
	#define Y_DARK_SEA_GREEN_2        MK_RGBA(180, 238, 180, 0)
	#define Y_DARKSEAGREEN3           MK_RGBA(155, 205, 155, 0)
	#define Y_DARK_SEA_GREEN_3        MK_RGBA(155, 205, 155, 0)
	#define Y_DARKSEAGREEN4           MK_RGBA(105, 139, 105, 0)
	#define Y_DARK_SEA_GREEN_4        MK_RGBA(105, 139, 105, 0)
	#define Y_SEAGREEN1               MK_RGBA( 84, 255, 159, 0)
	#define Y_SEA_GREEN_1             MK_RGBA( 84, 255, 159, 0)
	#define Y_SEAGREEN2               MK_RGBA( 78, 238, 148, 0)
	#define Y_SEA_GREEN_2             MK_RGBA( 78, 238, 148, 0)
	#define Y_SEAGREEN3               MK_RGBA( 67, 205, 128, 0)
	#define Y_SEA_GREEN_3             MK_RGBA( 67, 205, 128, 0)
	#define Y_SEAGREEN4               MK_RGBA( 46, 139,  87, 0)
	#define Y_SEA_GREEN_4             MK_RGBA( 46, 139,  87, 0)
	#define Y_PALEGREEN1              MK_RGBA(154, 255, 154, 0)
	#define Y_PALE_GREEN_1            MK_RGBA(154, 255, 154, 0)
	#define Y_PALEGREEN2              MK_RGBA(144, 238, 144, 0)
	#define Y_PALE_GREEN_2            MK_RGBA(144, 238, 144, 0)
	#define Y_PALEGREEN3              MK_RGBA(124, 205, 124, 0)
	#define Y_PALE_GREEN_3            MK_RGBA(124, 205, 124, 0)
	#define Y_PALEGREEN4              MK_RGBA( 84, 139,  84, 0)
	#define Y_PALE_GREEN_4            MK_RGBA( 84, 139,  84, 0)
	#define Y_SPRINGGREEN1            MK_RGBA(  0, 255, 127, 0)
	#define Y_SPRING_GREEN_1          MK_RGBA(  0, 255, 127, 0)
	#define Y_SPRINGGREEN2            MK_RGBA(  0, 238, 118, 0)
	#define Y_SPRING_GREEN_2          MK_RGBA(  0, 238, 118, 0)
	#define Y_SPRINGGREEN3            MK_RGBA(  0, 205, 102, 0)
	#define Y_SPRING_GREEN_3          MK_RGBA(  0, 205, 102, 0)
	#define Y_SPRINGGREEN4            MK_RGBA(  0, 139,  69, 0)
	#define Y_SPRING_GREEN_4          MK_RGBA(  0, 139,  69, 0)
	#define Y_GREEN1                  MK_RGBA(  0, 255,   0, 0)
	#define Y_GREEN_1                 MK_RGBA(  0, 255,   0, 0)
	#define Y_GREEN2                  MK_RGBA(  0, 238,   0, 0)
	#define Y_GREEN_2                 MK_RGBA(  0, 238,   0, 0)
	#define Y_GREEN3                  MK_RGBA(  0, 205,   0, 0)
	#define Y_GREEN_3                 MK_RGBA(  0, 205,   0, 0)
	#define Y_GREEN4                  MK_RGBA(  0, 139,   0, 0)
	#define Y_GREEN_4                 MK_RGBA(  0, 139,   0, 0)
	#define Y_CHARTREUSE1             MK_RGBA(127, 255,   0, 0)
	#define Y_CHARTREUSE_1            MK_RGBA(127, 255,   0, 0)
	#define Y_CHARTREUSE2             MK_RGBA(118, 238,   0, 0)
	#define Y_CHARTREUSE_2            MK_RGBA(118, 238,   0, 0)
	#define Y_CHARTREUSE3             MK_RGBA(102, 205,   0, 0)
	#define Y_CHARTREUSE_3            MK_RGBA(102, 205,   0, 0)
	#define Y_CHARTREUSE4             MK_RGBA( 69, 139,   0, 0)
	#define Y_CHARTREUSE_4            MK_RGBA( 69, 139,   0, 0)
	#define Y_OLIVEDRAB1              MK_RGBA(192, 255,  62, 0)
	#define Y_OLIVE_DRAB_1            MK_RGBA(192, 255,  62, 0)
	#define Y_OLIVEDRAB2              MK_RGBA(179, 238,  58, 0)
	#define Y_OLIVE_DRAB_2            MK_RGBA(179, 238,  58, 0)
	#define Y_OLIVEDRAB3              MK_RGBA(154, 205,  50, 0)
	#define Y_OLIVE_DRAB_3            MK_RGBA(154, 205,  50, 0)
	#define Y_OLIVEDRAB4              MK_RGBA(105, 139,  34, 0)
	#define Y_OLIVE_DRAB_4            MK_RGBA(105, 139,  34, 0)
	#define Y_DARKOLIVEGREEN1         MK_RGBA(202, 255, 112, 0)
	#define Y_DARK_OLIVE_GREEN_1      MK_RGBA(202, 255, 112, 0)
	#define Y_DARKOLIVEGREEN2         MK_RGBA(188, 238, 104, 0)
	#define Y_DARK_OLIVE_GREEN_2      MK_RGBA(188, 238, 104, 0)
	#define Y_DARKOLIVEGREEN3         MK_RGBA(162, 205,  90, 0)
	#define Y_DARK_OLIVE_GREEN_3      MK_RGBA(162, 205,  90, 0)
	#define Y_DARKOLIVEGREEN4         MK_RGBA(110, 139,  61, 0)
	#define Y_DARK_OLIVE_GREEN_4      MK_RGBA(110, 139,  61, 0)
	#define Y_KHAKI1                  MK_RGBA(255, 246, 143, 0)
	#define Y_KHAKI_1                 MK_RGBA(255, 246, 143, 0)
	#define Y_KHAKI2                  MK_RGBA(238, 230, 133, 0)
	#define Y_KHAKI_2                 MK_RGBA(238, 230, 133, 0)
	#define Y_KHAKI3                  MK_RGBA(205, 198, 115, 0)
	#define Y_KHAKI_3                 MK_RGBA(205, 198, 115, 0)
	#define Y_KHAKI4                  MK_RGBA(139, 134,  78, 0)
	#define Y_KHAKI_4                 MK_RGBA(139, 134,  78, 0)
	#define Y_LIGHTGOLDENROD1         MK_RGBA(255, 236, 139, 0)
	#define Y_LIGHT_GOLDENROD_1       MK_RGBA(255, 236, 139, 0)
	#define Y_LIGHTGOLDENROD2         MK_RGBA(238, 220, 130, 0)
	#define Y_LIGHT_GOLDENROD_2       MK_RGBA(238, 220, 130, 0)
	#define Y_LIGHTGOLDENROD3         MK_RGBA(205, 190, 112, 0)
	#define Y_LIGHT_GOLDENROD_3       MK_RGBA(205, 190, 112, 0)
	#define Y_LIGHTGOLDENROD4         MK_RGBA(139, 129,  76, 0)
	#define Y_LIGHT_GOLDENROD_4       MK_RGBA(139, 129,  76, 0)
	#define Y_LIGHTYELLOW1            MK_RGBA(255, 255, 224, 0)
	#define Y_LIGHT_YELLOW_1          MK_RGBA(255, 255, 224, 0)
	#define Y_LIGHTYELLOW2            MK_RGBA(238, 238, 209, 0)
	#define Y_LIGHT_YELLOW_2          MK_RGBA(238, 238, 209, 0)
	#define Y_LIGHTYELLOW3            MK_RGBA(205, 205, 180, 0)
	#define Y_LIGHT_YELLOW_3          MK_RGBA(205, 205, 180, 0)
	#define Y_LIGHTYELLOW4            MK_RGBA(139, 139, 122, 0)
	#define Y_LIGHT_YELLOW_4          MK_RGBA(139, 139, 122, 0)
	#define Y_YELLOW1                 MK_RGBA(255, 255,   0, 0)
	#define Y_YELLOW_1                MK_RGBA(255, 255,   0, 0)
	#define Y_YELLOW2                 MK_RGBA(238, 238,   0, 0)
	#define Y_YELLOW_2                MK_RGBA(238, 238,   0, 0)
	#define Y_YELLOW3                 MK_RGBA(205, 205,   0, 0)
	#define Y_YELLOW_3                MK_RGBA(205, 205,   0, 0)
	#define Y_YELLOW4                 MK_RGBA(139, 139,   0, 0)
	#define Y_YELLOW_4                MK_RGBA(139, 139,   0, 0)
	#define Y_GOLD1                   MK_RGBA(255, 215,   0, 0)
	#define Y_GOLD_1                  MK_RGBA(255, 215,   0, 0)
	#define Y_GOLD2                   MK_RGBA(238, 201,   0, 0)
	#define Y_GOLD_2                  MK_RGBA(238, 201,   0, 0)
	#define Y_GOLD3                   MK_RGBA(205, 173,   0, 0)
	#define Y_GOLD_3                  MK_RGBA(205, 173,   0, 0)
	#define Y_GOLD4                   MK_RGBA(139, 117,   0, 0)
	#define Y_GOLD_4                  MK_RGBA(139, 117,   0, 0)
	#define Y_GOLDENROD1              MK_RGBA(255, 193,  37, 0)
	#define Y_GOLDENROD_1             MK_RGBA(255, 193,  37, 0)
	#define Y_GOLDENROD2              MK_RGBA(238, 180,  34, 0)
	#define Y_GOLDENROD_2             MK_RGBA(238, 180,  34, 0)
	#define Y_GOLDENROD3              MK_RGBA(205, 155,  29, 0)
	#define Y_GOLDENROD_3             MK_RGBA(205, 155,  29, 0)
	#define Y_GOLDENROD4              MK_RGBA(139, 105,  20, 0)
	#define Y_GOLDENROD_4             MK_RGBA(139, 105,  20, 0)
	#define Y_DARKGOLDENROD1          MK_RGBA(255, 185,  15, 0)
	#define Y_DARK_GOLDENROD_1        MK_RGBA(255, 185,  15, 0)
	#define Y_DARKGOLDENROD2          MK_RGBA(238, 173,  14, 0)
	#define Y_DARK_GOLDENROD_2        MK_RGBA(238, 173,  14, 0)
	#define Y_DARKGOLDENROD3          MK_RGBA(205, 149,  12, 0)
	#define Y_DARK_GOLDENROD_3        MK_RGBA(205, 149,  12, 0)
	#define Y_DARKGOLDENROD4          MK_RGBA(139, 101,   8, 0)
	#define Y_DARK_GOLDENROD_4        MK_RGBA(139, 101,   8, 0)
	#define Y_ROSYBROWN1              MK_RGBA(255, 193, 193, 0)
	#define Y_ROSY_BROWN_1            MK_RGBA(255, 193, 193, 0)
	#define Y_ROSYBROWN2              MK_RGBA(238, 180, 180, 0)
	#define Y_ROSY_BROWN_2            MK_RGBA(238, 180, 180, 0)
	#define Y_ROSYBROWN3              MK_RGBA(205, 155, 155, 0)
	#define Y_ROSY_BROWN_3            MK_RGBA(205, 155, 155, 0)
	#define Y_ROSYBROWN4              MK_RGBA(139, 105, 105, 0)
	#define Y_ROSY_BROWN_4            MK_RGBA(139, 105, 105, 0)
	#define Y_INDIANRED1              MK_RGBA(255, 106, 106, 0)
	#define Y_INDIAN_RED_1            MK_RGBA(255, 106, 106, 0)
	#define Y_INDIANRED2              MK_RGBA(238,  99,  99, 0)
	#define Y_INDIAN_RED_2            MK_RGBA(238,  99,  99, 0)
	#define Y_INDIANRED3              MK_RGBA(205,  85,  85, 0)
	#define Y_INDIAN_RED_3            MK_RGBA(205,  85,  85, 0)
	#define Y_INDIANRED4              MK_RGBA(139,  58,  58, 0)
	#define Y_INDIAN_RED_4            MK_RGBA(139,  58,  58, 0)
	#define Y_SIENNA1                 MK_RGBA(255, 130,  71, 0)
	#define Y_SIENNA_1                MK_RGBA(255, 130,  71, 0)
	#define Y_SIENNA2                 MK_RGBA(238, 121,  66, 0)
	#define Y_SIENNA_2                MK_RGBA(238, 121,  66, 0)
	#define Y_SIENNA3                 MK_RGBA(205, 104,  57, 0)
	#define Y_SIENNA_3                MK_RGBA(205, 104,  57, 0)
	#define Y_SIENNA4                 MK_RGBA(139,  71,  38, 0)
	#define Y_SIENNA_4                MK_RGBA(139,  71,  38, 0)
	#define Y_BURLYWOOD1              MK_RGBA(255, 211, 155, 0)
	#define Y_BURLYWOOD_1             MK_RGBA(255, 211, 155, 0)
	#define Y_BURLYWOOD2              MK_RGBA(238, 197, 145, 0)
	#define Y_BURLYWOOD_2             MK_RGBA(238, 197, 145, 0)
	#define Y_BURLYWOOD3              MK_RGBA(205, 170, 125, 0)
	#define Y_BURLYWOOD_3             MK_RGBA(205, 170, 125, 0)
	#define Y_BURLYWOOD4              MK_RGBA(139, 115,  85, 0)
	#define Y_BURLYWOOD_4             MK_RGBA(139, 115,  85, 0)
	#define Y_WHEAT1                  MK_RGBA(255, 231, 186, 0)
	#define Y_WHEAT_1                 MK_RGBA(255, 231, 186, 0)
	#define Y_WHEAT2                  MK_RGBA(238, 216, 174, 0)
	#define Y_WHEAT_2                 MK_RGBA(238, 216, 174, 0)
	#define Y_WHEAT3                  MK_RGBA(205, 186, 150, 0)
	#define Y_WHEAT_3                 MK_RGBA(205, 186, 150, 0)
	#define Y_WHEAT4                  MK_RGBA(139, 126, 102, 0)
	#define Y_WHEAT_4                 MK_RGBA(139, 126, 102, 0)
	#define Y_TAN1                    MK_RGBA(255, 165,  79, 0)
	#define Y_TAN_1                   MK_RGBA(255, 165,  79, 0)
	#define Y_TAN2                    MK_RGBA(238, 154,  73, 0)
	#define Y_TAN_2                   MK_RGBA(238, 154,  73, 0)
	#define Y_TAN3                    MK_RGBA(205, 133,  63, 0)
	#define Y_TAN_3                   MK_RGBA(205, 133,  63, 0)
	#define Y_TAN4                    MK_RGBA(139,  90,  43, 0)
	#define Y_TAN_4                   MK_RGBA(139,  90,  43, 0)
	#define Y_CHOCOLATE1              MK_RGBA(255, 127,  36, 0)
	#define Y_CHOCOLATE_1             MK_RGBA(255, 127,  36, 0)
	#define Y_CHOCOLATE2              MK_RGBA(238, 118,  33, 0)
	#define Y_CHOCOLATE_2             MK_RGBA(238, 118,  33, 0)
	#define Y_CHOCOLATE3              MK_RGBA(205, 102,  29, 0)
	#define Y_CHOCOLATE_3             MK_RGBA(205, 102,  29, 0)
	#define Y_CHOCOLATE4              MK_RGBA(139,  69,  19, 0)
	#define Y_CHOCOLATE_4             MK_RGBA(139,  69,  19, 0)
	#define Y_FIREBRICK1              MK_RGBA(255,  48,  48, 0)
	#define Y_FIREBRICK_1             MK_RGBA(255,  48,  48, 0)
	#define Y_FIREBRICK2              MK_RGBA(238,  44,  44, 0)
	#define Y_FIREBRICK_2             MK_RGBA(238,  44,  44, 0)
	#define Y_FIREBRICK3              MK_RGBA(205,  38,  38, 0)
	#define Y_FIREBRICK_3             MK_RGBA(205,  38,  38, 0)
	#define Y_FIREBRICK4              MK_RGBA(139,  26,  26, 0)
	#define Y_FIREBRICK_4             MK_RGBA(139,  26,  26, 0)
	#define Y_BROWN1                  MK_RGBA(255,  64,  64, 0)
	#define Y_BROWN_1                 MK_RGBA(255,  64,  64, 0)
	#define Y_BROWN2                  MK_RGBA(238,  59,  59, 0)
	#define Y_BROWN_2                 MK_RGBA(238,  59,  59, 0)
	#define Y_BROWN3                  MK_RGBA(205,  51,  51, 0)
	#define Y_BROWN_3                 MK_RGBA(205,  51,  51, 0)
	#define Y_BROWN4                  MK_RGBA(139,  35,  35, 0)
	#define Y_BROWN_4                 MK_RGBA(139,  35,  35, 0)
	#define Y_SALMON1                 MK_RGBA(255, 140, 105, 0)
	#define Y_SALMON_1                MK_RGBA(255, 140, 105, 0)
	#define Y_SALMON2                 MK_RGBA(238, 130,  98, 0)
	#define Y_SALMON_2                MK_RGBA(238, 130,  98, 0)
	#define Y_SALMON3                 MK_RGBA(205, 112,  84, 0)
	#define Y_SALMON_3                MK_RGBA(205, 112,  84, 0)
	#define Y_SALMON4                 MK_RGBA(139,  76,  57, 0)
	#define Y_SALMON_4                MK_RGBA(139,  76,  57, 0)
	#define Y_LIGHTSALMON1            MK_RGBA(255, 160, 122, 0)
	#define Y_LIGHT_SALMON_1          MK_RGBA(255, 160, 122, 0)
	#define Y_LIGHTSALMON2            MK_RGBA(238, 149, 114, 0)
	#define Y_LIGHT_SALMON_2          MK_RGBA(238, 149, 114, 0)
	#define Y_LIGHTSALMON3            MK_RGBA(205, 129,  98, 0)
	#define Y_LIGHT_SALMON_3          MK_RGBA(205, 129,  98, 0)
	#define Y_LIGHTSALMON4            MK_RGBA(139,  87,  66, 0)
	#define Y_LIGHT_SALMON_4          MK_RGBA(139,  87,  66, 0)
	#define Y_ORANGE1                 MK_RGBA(255, 165,   0, 0)
	#define Y_ORANGE_1                MK_RGBA(255, 165,   0, 0)
	#define Y_ORANGE2                 MK_RGBA(238, 154,   0, 0)
	#define Y_ORANGE_2                MK_RGBA(238, 154,   0, 0)
	#define Y_ORANGE3                 MK_RGBA(205, 133,   0, 0)
	#define Y_ORANGE_3                MK_RGBA(205, 133,   0, 0)
	#define Y_ORANGE4                 MK_RGBA(139,  90,   0, 0)
	#define Y_ORANGE_4                MK_RGBA(139,  90,   0, 0)
	#define Y_DARKORANGE1             MK_RGBA(255, 127,   0, 0)
	#define Y_DARK_ORANGE_1           MK_RGBA(255, 127,   0, 0)
	#define Y_DARKORANGE2             MK_RGBA(238, 118,   0, 0)
	#define Y_DARK_ORANGE_2           MK_RGBA(238, 118,   0, 0)
	#define Y_DARKORANGE3             MK_RGBA(205, 102,   0, 0)
	#define Y_DARK_ORANGE_3           MK_RGBA(205, 102,   0, 0)
	#define Y_DARKORANGE4             MK_RGBA(139,  69,   0, 0)
	#define Y_DARK_ORANGE_4           MK_RGBA(139,  69,   0, 0)
	#define Y_CORAL1                  MK_RGBA(255, 114,  86, 0)
	#define Y_CORAL_1                 MK_RGBA(255, 114,  86, 0)
	#define Y_CORAL2                  MK_RGBA(238, 106,  80, 0)
	#define Y_CORAL_2                 MK_RGBA(238, 106,  80, 0)
	#define Y_CORAL3                  MK_RGBA(205,  91,  69, 0)
	#define Y_CORAL_3                 MK_RGBA(205,  91,  69, 0)
	#define Y_CORAL4                  MK_RGBA(139,  62,  47, 0)
	#define Y_CORAL_4                 MK_RGBA(139,  62,  47, 0)
	#define Y_TOMATO1                 MK_RGBA(255,  99,  71, 0)
	#define Y_TOMATO_1                MK_RGBA(255,  99,  71, 0)
	#define Y_TOMATO2                 MK_RGBA(238,  92,  66, 0)
	#define Y_TOMATO_2                MK_RGBA(238,  92,  66, 0)
	#define Y_TOMATO3                 MK_RGBA(205,  79,  57, 0)
	#define Y_TOMATO_3                MK_RGBA(205,  79,  57, 0)
	#define Y_TOMATO4                 MK_RGBA(139,  54,  38, 0)
	#define Y_TOMATO_4                MK_RGBA(139,  54,  38, 0)
	#define Y_ORANGERED1              MK_RGBA(255,  69,   0, 0)
	#define Y_ORANGE_RED_1            MK_RGBA(255,  69,   0, 0)
	#define Y_ORANGERED2              MK_RGBA(238,  64,   0, 0)
	#define Y_ORANGE_RED_2            MK_RGBA(238,  64,   0, 0)
	#define Y_ORANGERED3              MK_RGBA(205,  55,   0, 0)
	#define Y_ORANGE_RED_3            MK_RGBA(205,  55,   0, 0)
	#define Y_ORANGERED4              MK_RGBA(139,  37,   0, 0)
	#define Y_ORANGE_RED_4            MK_RGBA(139,  37,   0, 0)
	#define Y_RED1                    MK_RGBA(255,   0,   0, 0)
	#define Y_RED_1                   MK_RGBA(255,   0,   0, 0)
	#define Y_RED2                    MK_RGBA(238,   0,   0, 0)
	#define Y_RED_2                   MK_RGBA(238,   0,   0, 0)
	#define Y_RED3                    MK_RGBA(205,   0,   0, 0)
	#define Y_RED_3                   MK_RGBA(205,   0,   0, 0)
	#define Y_RED4                    MK_RGBA(139,   0,   0, 0)
	#define Y_RED_4                   MK_RGBA(139,   0,   0, 0)
	#define Y_DEEPPINK1               MK_RGBA(255,  20, 147, 0)
	#define Y_DEEP_PINK_1             MK_RGBA(255,  20, 147, 0)
	#define Y_DEEPPINK2               MK_RGBA(238,  18, 137, 0)
	#define Y_DEEP_PINK_2             MK_RGBA(238,  18, 137, 0)
	#define Y_DEEPPINK3               MK_RGBA(205,  16, 118, 0)
	#define Y_DEEP_PINK_3             MK_RGBA(205,  16, 118, 0)
	#define Y_DEEPPINK4               MK_RGBA(139,  10,  80, 0)
	#define Y_DEEP_PINK_4             MK_RGBA(139,  10,  80, 0)
	#define Y_HOTPINK1                MK_RGBA(255, 110, 180, 0)
	#define Y_HOT_PINK_1              MK_RGBA(255, 110, 180, 0)
	#define Y_HOTPINK2                MK_RGBA(238, 106, 167, 0)
	#define Y_HOT_PINK_2              MK_RGBA(238, 106, 167, 0)
	#define Y_HOTPINK3                MK_RGBA(205,  96, 144, 0)
	#define Y_HOT_PINK_3              MK_RGBA(205,  96, 144, 0)
	#define Y_HOTPINK4                MK_RGBA(139,  58,  98, 0)
	#define Y_HOT_PINK_4              MK_RGBA(139,  58,  98, 0)
	#define Y_PINK1                   MK_RGBA(255, 181, 197, 0)
	#define Y_PINK_1                  MK_RGBA(255, 181, 197, 0)
	#define Y_PINK2                   MK_RGBA(238, 169, 184, 0)
	#define Y_PINK_2                  MK_RGBA(238, 169, 184, 0)
	#define Y_PINK3                   MK_RGBA(205, 145, 158, 0)
	#define Y_PINK_3                  MK_RGBA(205, 145, 158, 0)
	#define Y_PINK4                   MK_RGBA(139,  99, 108, 0)
	#define Y_PINK_4                  MK_RGBA(139,  99, 108, 0)
	#define Y_LIGHTPINK1              MK_RGBA(255, 174, 185, 0)
	#define Y_LIGHT_PINK_1            MK_RGBA(255, 174, 185, 0)
	#define Y_LIGHTPINK2              MK_RGBA(238, 162, 173, 0)
	#define Y_LIGHT_PINK_2            MK_RGBA(238, 162, 173, 0)
	#define Y_LIGHTPINK3              MK_RGBA(205, 140, 149, 0)
	#define Y_LIGHT_PINK_3            MK_RGBA(205, 140, 149, 0)
	#define Y_LIGHTPINK4              MK_RGBA(139,  95, 101, 0)
	#define Y_LIGHT_PINK_4            MK_RGBA(139,  95, 101, 0)
	#define Y_PALEVIOLETRED1          MK_RGBA(255, 130, 171, 0)
	#define Y_PALE_VIOLET_RED_1       MK_RGBA(255, 130, 171, 0)
	#define Y_PALEVIOLETRED2          MK_RGBA(238, 121, 159, 0)
	#define Y_PALE_VIOLET_RED_2       MK_RGBA(238, 121, 159, 0)
	#define Y_PALEVIOLETRED3          MK_RGBA(205, 104, 137, 0)
	#define Y_PALE_VIOLET_RED_3       MK_RGBA(205, 104, 137, 0)
	#define Y_PALEVIOLETRED4          MK_RGBA(139,  71,  93, 0)
	#define Y_PALE_VIOLET_RED_4       MK_RGBA(139,  71,  93, 0)
	#define Y_MAROON1                 MK_RGBA(255,  52, 179, 0)
	#define Y_MAROON_1                MK_RGBA(255,  52, 179, 0)
	#define Y_MAROON2                 MK_RGBA(238,  48, 167, 0)
	#define Y_MAROON_2                MK_RGBA(238,  48, 167, 0)
	#define Y_MAROON3                 MK_RGBA(205,  41, 144, 0)
	#define Y_MAROON_3                MK_RGBA(205,  41, 144, 0)
	#define Y_MAROON4                 MK_RGBA(139,  28,  98, 0)
	#define Y_MAROON_4                MK_RGBA(139,  28,  98, 0)
	#define Y_VIOLETRED1              MK_RGBA(255,  62, 150, 0)
	#define Y_VIOLET_RED_1            MK_RGBA(255,  62, 150, 0)
	#define Y_VIOLETRED2              MK_RGBA(238,  58, 140, 0)
	#define Y_VIOLET_RED_2            MK_RGBA(238,  58, 140, 0)
	#define Y_VIOLETRED3              MK_RGBA(205,  50, 120, 0)
	#define Y_VIOLET_RED_3            MK_RGBA(205,  50, 120, 0)
	#define Y_VIOLETRED4              MK_RGBA(139,  34,  82, 0)
	#define Y_VIOLET_RED_4            MK_RGBA(139,  34,  82, 0)
	#define Y_MAGENTA1                MK_RGBA(255,   0, 255, 0)
	#define Y_MAGENTA_1               MK_RGBA(255,   0, 255, 0)
	#define Y_MAGENTA2                MK_RGBA(238,   0, 238, 0)
	#define Y_MAGENTA_2               MK_RGBA(238,   0, 238, 0)
	#define Y_MAGENTA3                MK_RGBA(205,   0, 205, 0)
	#define Y_MAGENTA_3               MK_RGBA(205,   0, 205, 0)
	#define Y_MAGENTA4                MK_RGBA(139,   0, 139, 0)
	#define Y_MAGENTA_4               MK_RGBA(139,   0, 139, 0)
	#define Y_ORCHID1                 MK_RGBA(255, 131, 250, 0)
	#define Y_ORCHID_1                MK_RGBA(255, 131, 250, 0)
	#define Y_ORCHID2                 MK_RGBA(238, 122, 233, 0)
	#define Y_ORCHID_2                MK_RGBA(238, 122, 233, 0)
	#define Y_ORCHID3                 MK_RGBA(205, 105, 201, 0)
	#define Y_ORCHID_3                MK_RGBA(205, 105, 201, 0)
	#define Y_ORCHID4                 MK_RGBA(139,  71, 137, 0)
	#define Y_ORCHID_4                MK_RGBA(139,  71, 137, 0)
	#define Y_PLUM1                   MK_RGBA(255, 187, 255, 0)
	#define Y_PLUM_1                  MK_RGBA(255, 187, 255, 0)
	#define Y_PLUM2                   MK_RGBA(238, 174, 238, 0)
	#define Y_PLUM_2                  MK_RGBA(238, 174, 238, 0)
	#define Y_PLUM3                   MK_RGBA(205, 150, 205, 0)
	#define Y_PLUM_3                  MK_RGBA(205, 150, 205, 0)
	#define Y_PLUM4                   MK_RGBA(139, 102, 139, 0)
	#define Y_PLUM_4                  MK_RGBA(139, 102, 139, 0)
	#define Y_MEDIUMORCHID1           MK_RGBA(224, 102, 255, 0)
	#define Y_MEDIUM_ORCHID_1         MK_RGBA(224, 102, 255, 0)
	#define Y_MEDIUMORCHID2           MK_RGBA(209,  95, 238, 0)
	#define Y_MEDIUM_ORCHID_2         MK_RGBA(209,  95, 238, 0)
	#define Y_MEDIUMORCHID3           MK_RGBA(180,  82, 205, 0)
	#define Y_MEDIUM_ORCHID_3         MK_RGBA(180,  82, 205, 0)
	#define Y_MEDIUMORCHID4           MK_RGBA(122,  55, 139, 0)
	#define Y_MEDIUM_ORCHID_4         MK_RGBA(122,  55, 139, 0)
	#define Y_DARKORCHID1             MK_RGBA(191,  62, 255, 0)
	#define Y_DARK_ORCHID_1           MK_RGBA(191,  62, 255, 0)
	#define Y_DARKORCHID2             MK_RGBA(178,  58, 238, 0)
	#define Y_DARK_ORCHID_2           MK_RGBA(178,  58, 238, 0)
	#define Y_DARKORCHID3             MK_RGBA(154,  50, 205, 0)
	#define Y_DARK_ORCHID_3           MK_RGBA(154,  50, 205, 0)
	#define Y_DARKORCHID4             MK_RGBA(104,  34, 139, 0)
	#define Y_DARK_ORCHID_4           MK_RGBA(104,  34, 139, 0)
	#define Y_PURPLE1                 MK_RGBA(155,  48, 255, 0)
	#define Y_PURPLE_1                MK_RGBA(155,  48, 255, 0)
	#define Y_PURPLE2                 MK_RGBA(145,  44, 238, 0)
	#define Y_PURPLE_2                MK_RGBA(145,  44, 238, 0)
	#define Y_PURPLE3                 MK_RGBA(125,  38, 205, 0)
	#define Y_PURPLE_3                MK_RGBA(125,  38, 205, 0)
	#define Y_PURPLE4                 MK_RGBA( 85,  26, 139, 0)
	#define Y_PURPLE_4                MK_RGBA( 85,  26, 139, 0)
	#define Y_MEDIUMPURPLE1           MK_RGBA(171, 130, 255, 0)
	#define Y_MEDIUM_PURPLE_1         MK_RGBA(171, 130, 255, 0)
	#define Y_MEDIUMPURPLE2           MK_RGBA(159, 121, 238, 0)
	#define Y_MEDIUM_PURPLE_2         MK_RGBA(159, 121, 238, 0)
	#define Y_MEDIUMPURPLE3           MK_RGBA(137, 104, 205, 0)
	#define Y_MEDIUM_PURPLE_3         MK_RGBA(137, 104, 205, 0)
	#define Y_MEDIUMPURPLE4           MK_RGBA( 93,  71, 139, 0)
	#define Y_MEDIUM_PURPLE_4         MK_RGBA( 93,  71, 139, 0)
	#define Y_THISTLE1                MK_RGBA(255, 225, 255, 0)
	#define Y_THISTLE_1               MK_RGBA(255, 225, 255, 0)
	#define Y_THISTLE2                MK_RGBA(238, 210, 238, 0)
	#define Y_THISTLE_2               MK_RGBA(238, 210, 238, 0)
	#define Y_THISTLE3                MK_RGBA(205, 181, 205, 0)
	#define Y_THISTLE_3               MK_RGBA(205, 181, 205, 0)
	#define Y_THISTLE4                MK_RGBA(139, 123, 139, 0)
	#define Y_THISTLE_4               MK_RGBA(139, 123, 139, 0)
	#define Y_GRAY0                   MK_RGBA(  0,   0,   0, 0)
	#define Y_GRAY_0                  MK_RGBA(  0,   0,   0, 0)
	#define Y_GREY0                   MK_RGBA(  0,   0,   0, 0)
	#define Y_GREY_0                  MK_RGBA(  0,   0,   0, 0)
	#define Y_GRAY1                   MK_RGBA(  3,   3,   3, 0)
	#define Y_GRAY_1                  MK_RGBA(  3,   3,   3, 0)
	#define Y_GREY1                   MK_RGBA(  3,   3,   3, 0)
	#define Y_GREY_1                  MK_RGBA(  3,   3,   3, 0)
	#define Y_GRAY2                   MK_RGBA(  5,   5,   5, 0)
	#define Y_GRAY_2                  MK_RGBA(  5,   5,   5, 0)
	#define Y_GREY2                   MK_RGBA(  5,   5,   5, 0)
	#define Y_GREY_2                  MK_RGBA(  5,   5,   5, 0)
	#define Y_GRAY3                   MK_RGBA(  8,   8,   8, 0)
	#define Y_GRAY_3                  MK_RGBA(  8,   8,   8, 0)
	#define Y_GREY3                   MK_RGBA(  8,   8,   8, 0)
	#define Y_GREY_3                  MK_RGBA(  8,   8,   8, 0)
	#define Y_GRAY4                   MK_RGBA( 10,  10,  10, 0)
	#define Y_GRAY_4                  MK_RGBA( 10,  10,  10, 0)
	#define Y_GREY4                   MK_RGBA( 10,  10,  10, 0)
	#define Y_GREY_4                  MK_RGBA( 10,  10,  10, 0)
	#define Y_GRAY5                   MK_RGBA( 13,  13,  13, 0)
	#define Y_GRAY_5                  MK_RGBA( 13,  13,  13, 0)
	#define Y_GREY5                   MK_RGBA( 13,  13,  13, 0)
	#define Y_GREY_5                  MK_RGBA( 13,  13,  13, 0)
	#define Y_GRAY6                   MK_RGBA( 15,  15,  15, 0)
	#define Y_GRAY_6                  MK_RGBA( 15,  15,  15, 0)
	#define Y_GREY6                   MK_RGBA( 15,  15,  15, 0)
	#define Y_GREY_6                  MK_RGBA( 15,  15,  15, 0)
	#define Y_GRAY7                   MK_RGBA( 18,  18,  18, 0)
	#define Y_GRAY_7                  MK_RGBA( 18,  18,  18, 0)
	#define Y_GREY7                   MK_RGBA( 18,  18,  18, 0)
	#define Y_GREY_7                  MK_RGBA( 18,  18,  18, 0)
	#define Y_GRAY8                   MK_RGBA( 20,  20,  20, 0)
	#define Y_GRAY_8                  MK_RGBA( 20,  20,  20, 0)
	#define Y_GREY8                   MK_RGBA( 20,  20,  20, 0)
	#define Y_GREY_8                  MK_RGBA( 20,  20,  20, 0)
	#define Y_GRAY9                   MK_RGBA( 23,  23,  23, 0)
	#define Y_GRAY_9                  MK_RGBA( 23,  23,  23, 0)
	#define Y_GREY9                   MK_RGBA( 23,  23,  23, 0)
	#define Y_GREY_9                  MK_RGBA( 23,  23,  23, 0)
	#define Y_GRAY10                  MK_RGBA( 26,  26,  26, 0)
	#define Y_GRAY_10                 MK_RGBA( 26,  26,  26, 0)
	#define Y_GREY10                  MK_RGBA( 26,  26,  26, 0)
	#define Y_GREY_10                 MK_RGBA( 26,  26,  26, 0)
	#define Y_GRAY11                  MK_RGBA( 28,  28,  28, 0)
	#define Y_GRAY_11                 MK_RGBA( 28,  28,  28, 0)
	#define Y_GREY11                  MK_RGBA( 28,  28,  28, 0)
	#define Y_GREY_11                 MK_RGBA( 28,  28,  28, 0)
	#define Y_GRAY12                  MK_RGBA( 31,  31,  31, 0)
	#define Y_GRAY_12                 MK_RGBA( 31,  31,  31, 0)
	#define Y_GREY12                  MK_RGBA( 31,  31,  31, 0)
	#define Y_GREY_12                 MK_RGBA( 31,  31,  31, 0)
	#define Y_GRAY13                  MK_RGBA( 33,  33,  33, 0)
	#define Y_GRAY_13                 MK_RGBA( 33,  33,  33, 0)
	#define Y_GREY13                  MK_RGBA( 33,  33,  33, 0)
	#define Y_GREY_13                 MK_RGBA( 33,  33,  33, 0)
	#define Y_GRAY14                  MK_RGBA( 36,  36,  36, 0)
	#define Y_GRAY_14                 MK_RGBA( 36,  36,  36, 0)
	#define Y_GREY14                  MK_RGBA( 36,  36,  36, 0)
	#define Y_GREY_14                 MK_RGBA( 36,  36,  36, 0)
	#define Y_GRAY15                  MK_RGBA( 38,  38,  38, 0)
	#define Y_GRAY_15                 MK_RGBA( 38,  38,  38, 0)
	#define Y_GREY15                  MK_RGBA( 38,  38,  38, 0)
	#define Y_GREY_15                 MK_RGBA( 38,  38,  38, 0)
	#define Y_GRAY16                  MK_RGBA( 41,  41,  41, 0)
	#define Y_GRAY_16                 MK_RGBA( 41,  41,  41, 0)
	#define Y_GREY16                  MK_RGBA( 41,  41,  41, 0)
	#define Y_GREY_16                 MK_RGBA( 41,  41,  41, 0)
	#define Y_GRAY17                  MK_RGBA( 43,  43,  43, 0)
	#define Y_GRAY_17                 MK_RGBA( 43,  43,  43, 0)
	#define Y_GREY17                  MK_RGBA( 43,  43,  43, 0)
	#define Y_GREY_17                 MK_RGBA( 43,  43,  43, 0)
	#define Y_GRAY18                  MK_RGBA( 46,  46,  46, 0)
	#define Y_GRAY_18                 MK_RGBA( 46,  46,  46, 0)
	#define Y_GREY18                  MK_RGBA( 46,  46,  46, 0)
	#define Y_GREY_18                 MK_RGBA( 46,  46,  46, 0)
	#define Y_GRAY19                  MK_RGBA( 48,  48,  48, 0)
	#define Y_GRAY_19                 MK_RGBA( 48,  48,  48, 0)
	#define Y_GREY19                  MK_RGBA( 48,  48,  48, 0)
	#define Y_GREY_19                 MK_RGBA( 48,  48,  48, 0)
	#define Y_GRAY20                  MK_RGBA( 51,  51,  51, 0)
	#define Y_GRAY_20                 MK_RGBA( 51,  51,  51, 0)
	#define Y_GREY20                  MK_RGBA( 51,  51,  51, 0)
	#define Y_GREY_20                 MK_RGBA( 51,  51,  51, 0)
	#define Y_GRAY21                  MK_RGBA( 54,  54,  54, 0)
	#define Y_GRAY_21                 MK_RGBA( 54,  54,  54, 0)
	#define Y_GREY21                  MK_RGBA( 54,  54,  54, 0)
	#define Y_GREY_21                 MK_RGBA( 54,  54,  54, 0)
	#define Y_GRAY22                  MK_RGBA( 56,  56,  56, 0)
	#define Y_GRAY_22                 MK_RGBA( 56,  56,  56, 0)
	#define Y_GREY22                  MK_RGBA( 56,  56,  56, 0)
	#define Y_GREY_22                 MK_RGBA( 56,  56,  56, 0)
	#define Y_GRAY23                  MK_RGBA( 59,  59,  59, 0)
	#define Y_GRAY_23                 MK_RGBA( 59,  59,  59, 0)
	#define Y_GREY23                  MK_RGBA( 59,  59,  59, 0)
	#define Y_GREY_23                 MK_RGBA( 59,  59,  59, 0)
	#define Y_GRAY24                  MK_RGBA( 61,  61,  61, 0)
	#define Y_GRAY_24                 MK_RGBA( 61,  61,  61, 0)
	#define Y_GREY24                  MK_RGBA( 61,  61,  61, 0)
	#define Y_GREY_24                 MK_RGBA( 61,  61,  61, 0)
	#define Y_GRAY25                  MK_RGBA( 64,  64,  64, 0)
	#define Y_GRAY_25                 MK_RGBA( 64,  64,  64, 0)
	#define Y_GREY25                  MK_RGBA( 64,  64,  64, 0)
	#define Y_GREY_25                 MK_RGBA( 64,  64,  64, 0)
	#define Y_GRAY26                  MK_RGBA( 66,  66,  66, 0)
	#define Y_GRAY_26                 MK_RGBA( 66,  66,  66, 0)
	#define Y_GREY26                  MK_RGBA( 66,  66,  66, 0)
	#define Y_GREY_26                 MK_RGBA( 66,  66,  66, 0)
	#define Y_GRAY27                  MK_RGBA( 69,  69,  69, 0)
	#define Y_GRAY_27                 MK_RGBA( 69,  69,  69, 0)
	#define Y_GREY27                  MK_RGBA( 69,  69,  69, 0)
	#define Y_GREY_27                 MK_RGBA( 69,  69,  69, 0)
	#define Y_GRAY28                  MK_RGBA( 71,  71,  71, 0)
	#define Y_GRAY_28                 MK_RGBA( 71,  71,  71, 0)
	#define Y_GREY28                  MK_RGBA( 71,  71,  71, 0)
	#define Y_GREY_28                 MK_RGBA( 71,  71,  71, 0)
	#define Y_GRAY29                  MK_RGBA( 74,  74,  74, 0)
	#define Y_GRAY_29                 MK_RGBA( 74,  74,  74, 0)
	#define Y_GREY29                  MK_RGBA( 74,  74,  74, 0)
	#define Y_GREY_29                 MK_RGBA( 74,  74,  74, 0)
	#define Y_GRAY30                  MK_RGBA( 77,  77,  77, 0)
	#define Y_GRAY_30                 MK_RGBA( 77,  77,  77, 0)
	#define Y_GREY30                  MK_RGBA( 77,  77,  77, 0)
	#define Y_GREY_30                 MK_RGBA( 77,  77,  77, 0)
	#define Y_GRAY31                  MK_RGBA( 79,  79,  79, 0)
	#define Y_GRAY_31                 MK_RGBA( 79,  79,  79, 0)
	#define Y_GREY31                  MK_RGBA( 79,  79,  79, 0)
	#define Y_GREY_31                 MK_RGBA( 79,  79,  79, 0)
	#define Y_GRAY32                  MK_RGBA( 82,  82,  82, 0)
	#define Y_GRAY_32                 MK_RGBA( 82,  82,  82, 0)
	#define Y_GREY32                  MK_RGBA( 82,  82,  82, 0)
	#define Y_GREY_32                 MK_RGBA( 82,  82,  82, 0)
	#define Y_GRAY33                  MK_RGBA( 84,  84,  84, 0)
	#define Y_GRAY_33                 MK_RGBA( 84,  84,  84, 0)
	#define Y_GREY33                  MK_RGBA( 84,  84,  84, 0)
	#define Y_GREY_33                 MK_RGBA( 84,  84,  84, 0)
	#define Y_GRAY34                  MK_RGBA( 87,  87,  87, 0)
	#define Y_GRAY_34                 MK_RGBA( 87,  87,  87, 0)
	#define Y_GREY34                  MK_RGBA( 87,  87,  87, 0)
	#define Y_GREY_34                 MK_RGBA( 87,  87,  87, 0)
	#define Y_GRAY35                  MK_RGBA( 89,  89,  89, 0)
	#define Y_GRAY_35                 MK_RGBA( 89,  89,  89, 0)
	#define Y_GREY35                  MK_RGBA( 89,  89,  89, 0)
	#define Y_GREY_35                 MK_RGBA( 89,  89,  89, 0)
	#define Y_GRAY36                  MK_RGBA( 92,  92,  92, 0)
	#define Y_GRAY_36                 MK_RGBA( 92,  92,  92, 0)
	#define Y_GREY36                  MK_RGBA( 92,  92,  92, 0)
	#define Y_GREY_36                 MK_RGBA( 92,  92,  92, 0)
	#define Y_GRAY37                  MK_RGBA( 94,  94,  94, 0)
	#define Y_GRAY_37                 MK_RGBA( 94,  94,  94, 0)
	#define Y_GREY37                  MK_RGBA( 94,  94,  94, 0)
	#define Y_GREY_37                 MK_RGBA( 94,  94,  94, 0)
	#define Y_GRAY38                  MK_RGBA( 97,  97,  97, 0)
	#define Y_GRAY_38                 MK_RGBA( 97,  97,  97, 0)
	#define Y_GREY38                  MK_RGBA( 97,  97,  97, 0)
	#define Y_GREY_38                 MK_RGBA( 97,  97,  97, 0)
	#define Y_GRAY39                  MK_RGBA( 99,  99,  99, 0)
	#define Y_GRAY_39                 MK_RGBA( 99,  99,  99, 0)
	#define Y_GREY39                  MK_RGBA( 99,  99,  99, 0)
	#define Y_GREY_39                 MK_RGBA( 99,  99,  99, 0)
	#define Y_GRAY40                  MK_RGBA(102, 102, 102, 0)
	#define Y_GRAY_40                 MK_RGBA(102, 102, 102, 0)
	#define Y_GREY40                  MK_RGBA(102, 102, 102, 0)
	#define Y_GREY_40                 MK_RGBA(102, 102, 102, 0)
	#define Y_GRAY41                  MK_RGBA(105, 105, 105, 0)
	#define Y_GRAY_41                 MK_RGBA(105, 105, 105, 0)
	#define Y_GREY41                  MK_RGBA(105, 105, 105, 0)
	#define Y_GREY_41                 MK_RGBA(105, 105, 105, 0)
	#define Y_GRAY42                  MK_RGBA(107, 107, 107, 0)
	#define Y_GRAY_42                 MK_RGBA(107, 107, 107, 0)
	#define Y_GREY42                  MK_RGBA(107, 107, 107, 0)
	#define Y_GREY_42                 MK_RGBA(107, 107, 107, 0)
	#define Y_GRAY43                  MK_RGBA(110, 110, 110, 0)
	#define Y_GRAY_43                 MK_RGBA(110, 110, 110, 0)
	#define Y_GREY43                  MK_RGBA(110, 110, 110, 0)
	#define Y_GREY_43                 MK_RGBA(110, 110, 110, 0)
	#define Y_GRAY44                  MK_RGBA(112, 112, 112, 0)
	#define Y_GRAY_44                 MK_RGBA(112, 112, 112, 0)
	#define Y_GREY44                  MK_RGBA(112, 112, 112, 0)
	#define Y_GREY_44                 MK_RGBA(112, 112, 112, 0)
	#define Y_GRAY45                  MK_RGBA(115, 115, 115, 0)
	#define Y_GRAY_45                 MK_RGBA(115, 115, 115, 0)
	#define Y_GREY45                  MK_RGBA(115, 115, 115, 0)
	#define Y_GREY_45                 MK_RGBA(115, 115, 115, 0)
	#define Y_GRAY46                  MK_RGBA(117, 117, 117, 0)
	#define Y_GRAY_46                 MK_RGBA(117, 117, 117, 0)
	#define Y_GREY46                  MK_RGBA(117, 117, 117, 0)
	#define Y_GREY_46                 MK_RGBA(117, 117, 117, 0)
	#define Y_GRAY47                  MK_RGBA(120, 120, 120, 0)
	#define Y_GRAY_47                 MK_RGBA(120, 120, 120, 0)
	#define Y_GREY47                  MK_RGBA(120, 120, 120, 0)
	#define Y_GREY_47                 MK_RGBA(120, 120, 120, 0)
	#define Y_GRAY48                  MK_RGBA(122, 122, 122, 0)
	#define Y_GRAY_48                 MK_RGBA(122, 122, 122, 0)
	#define Y_GREY48                  MK_RGBA(122, 122, 122, 0)
	#define Y_GREY_48                 MK_RGBA(122, 122, 122, 0)
	#define Y_GRAY49                  MK_RGBA(125, 125, 125, 0)
	#define Y_GRAY_49                 MK_RGBA(125, 125, 125, 0)
	#define Y_GREY49                  MK_RGBA(125, 125, 125, 0)
	#define Y_GREY_49                 MK_RGBA(125, 125, 125, 0)
	#define Y_GRAY50                  MK_RGBA(127, 127, 127, 0)
	#define Y_GRAY_50                 MK_RGBA(127, 127, 127, 0)
	#define Y_GREY50                  MK_RGBA(127, 127, 127, 0)
	#define Y_GREY_50                 MK_RGBA(127, 127, 127, 0)
	#define Y_GRAY51                  MK_RGBA(130, 130, 130, 0)
	#define Y_GRAY_51                 MK_RGBA(130, 130, 130, 0)
	#define Y_GREY51                  MK_RGBA(130, 130, 130, 0)
	#define Y_GREY_51                 MK_RGBA(130, 130, 130, 0)
	#define Y_GRAY52                  MK_RGBA(133, 133, 133, 0)
	#define Y_GRAY_52                 MK_RGBA(133, 133, 133, 0)
	#define Y_GREY52                  MK_RGBA(133, 133, 133, 0)
	#define Y_GREY_52                 MK_RGBA(133, 133, 133, 0)
	#define Y_GRAY53                  MK_RGBA(135, 135, 135, 0)
	#define Y_GRAY_53                 MK_RGBA(135, 135, 135, 0)
	#define Y_GREY53                  MK_RGBA(135, 135, 135, 0)
	#define Y_GREY_53                 MK_RGBA(135, 135, 135, 0)
	#define Y_GRAY54                  MK_RGBA(138, 138, 138, 0)
	#define Y_GRAY_54                 MK_RGBA(138, 138, 138, 0)
	#define Y_GREY54                  MK_RGBA(138, 138, 138, 0)
	#define Y_GREY_54                 MK_RGBA(138, 138, 138, 0)
	#define Y_GRAY55                  MK_RGBA(140, 140, 140, 0)
	#define Y_GRAY_55                 MK_RGBA(140, 140, 140, 0)
	#define Y_GREY55                  MK_RGBA(140, 140, 140, 0)
	#define Y_GREY_55                 MK_RGBA(140, 140, 140, 0)
	#define Y_GRAY56                  MK_RGBA(143, 143, 143, 0)
	#define Y_GRAY_56                 MK_RGBA(143, 143, 143, 0)
	#define Y_GREY56                  MK_RGBA(143, 143, 143, 0)
	#define Y_GREY_56                 MK_RGBA(143, 143, 143, 0)
	#define Y_GRAY57                  MK_RGBA(145, 145, 145, 0)
	#define Y_GRAY_57                 MK_RGBA(145, 145, 145, 0)
	#define Y_GREY57                  MK_RGBA(145, 145, 145, 0)
	#define Y_GREY_57                 MK_RGBA(145, 145, 145, 0)
	#define Y_GRAY58                  MK_RGBA(148, 148, 148, 0)
	#define Y_GRAY_58                 MK_RGBA(148, 148, 148, 0)
	#define Y_GREY58                  MK_RGBA(148, 148, 148, 0)
	#define Y_GREY_58                 MK_RGBA(148, 148, 148, 0)
	#define Y_GRAY59                  MK_RGBA(150, 150, 150, 0)
	#define Y_GRAY_59                 MK_RGBA(150, 150, 150, 0)
	#define Y_GREY59                  MK_RGBA(150, 150, 150, 0)
	#define Y_GREY_59                 MK_RGBA(150, 150, 150, 0)
	#define Y_GRAY60                  MK_RGBA(153, 153, 153, 0)
	#define Y_GRAY_60                 MK_RGBA(153, 153, 153, 0)
	#define Y_GREY60                  MK_RGBA(153, 153, 153, 0)
	#define Y_GREY_60                 MK_RGBA(153, 153, 153, 0)
	#define Y_GRAY61                  MK_RGBA(156, 156, 156, 0)
	#define Y_GRAY_61                 MK_RGBA(156, 156, 156, 0)
	#define Y_GREY61                  MK_RGBA(156, 156, 156, 0)
	#define Y_GREY_61                 MK_RGBA(156, 156, 156, 0)
	#define Y_GRAY62                  MK_RGBA(158, 158, 158, 0)
	#define Y_GRAY_62                 MK_RGBA(158, 158, 158, 0)
	#define Y_GREY62                  MK_RGBA(158, 158, 158, 0)
	#define Y_GREY_62                 MK_RGBA(158, 158, 158, 0)
	#define Y_GRAY63                  MK_RGBA(161, 161, 161, 0)
	#define Y_GRAY_63                 MK_RGBA(161, 161, 161, 0)
	#define Y_GREY63                  MK_RGBA(161, 161, 161, 0)
	#define Y_GREY_63                 MK_RGBA(161, 161, 161, 0)
	#define Y_GRAY64                  MK_RGBA(163, 163, 163, 0)
	#define Y_GRAY_64                 MK_RGBA(163, 163, 163, 0)
	#define Y_GREY64                  MK_RGBA(163, 163, 163, 0)
	#define Y_GREY_64                 MK_RGBA(163, 163, 163, 0)
	#define Y_GRAY65                  MK_RGBA(166, 166, 166, 0)
	#define Y_GRAY_65                 MK_RGBA(166, 166, 166, 0)
	#define Y_GREY65                  MK_RGBA(166, 166, 166, 0)
	#define Y_GREY_65                 MK_RGBA(166, 166, 166, 0)
	#define Y_GRAY66                  MK_RGBA(168, 168, 168, 0)
	#define Y_GRAY_66                 MK_RGBA(168, 168, 168, 0)
	#define Y_GREY66                  MK_RGBA(168, 168, 168, 0)
	#define Y_GREY_66                 MK_RGBA(168, 168, 168, 0)
	#define Y_GRAY67                  MK_RGBA(171, 171, 171, 0)
	#define Y_GRAY_67                 MK_RGBA(171, 171, 171, 0)
	#define Y_GREY67                  MK_RGBA(171, 171, 171, 0)
	#define Y_GREY_67                 MK_RGBA(171, 171, 171, 0)
	#define Y_GRAY68                  MK_RGBA(173, 173, 173, 0)
	#define Y_GRAY_68                 MK_RGBA(173, 173, 173, 0)
	#define Y_GREY68                  MK_RGBA(173, 173, 173, 0)
	#define Y_GREY_68                 MK_RGBA(173, 173, 173, 0)
	#define Y_GRAY69                  MK_RGBA(176, 176, 176, 0)
	#define Y_GRAY_69                 MK_RGBA(176, 176, 176, 0)
	#define Y_GREY69                  MK_RGBA(176, 176, 176, 0)
	#define Y_GREY_69                 MK_RGBA(176, 176, 176, 0)
	#define Y_GRAY70                  MK_RGBA(179, 179, 179, 0)
	#define Y_GRAY_70                 MK_RGBA(179, 179, 179, 0)
	#define Y_GREY70                  MK_RGBA(179, 179, 179, 0)
	#define Y_GREY_70                 MK_RGBA(179, 179, 179, 0)
	#define Y_GRAY71                  MK_RGBA(181, 181, 181, 0)
	#define Y_GRAY_71                 MK_RGBA(181, 181, 181, 0)
	#define Y_GREY71                  MK_RGBA(181, 181, 181, 0)
	#define Y_GREY_71                 MK_RGBA(181, 181, 181, 0)
	#define Y_GRAY72                  MK_RGBA(184, 184, 184, 0)
	#define Y_GRAY_72                 MK_RGBA(184, 184, 184, 0)
	#define Y_GREY72                  MK_RGBA(184, 184, 184, 0)
	#define Y_GREY_72                 MK_RGBA(184, 184, 184, 0)
	#define Y_GRAY73                  MK_RGBA(186, 186, 186, 0)
	#define Y_GRAY_73                 MK_RGBA(186, 186, 186, 0)
	#define Y_GREY73                  MK_RGBA(186, 186, 186, 0)
	#define Y_GREY_73                 MK_RGBA(186, 186, 186, 0)
	#define Y_GRAY74                  MK_RGBA(189, 189, 189, 0)
	#define Y_GRAY_74                 MK_RGBA(189, 189, 189, 0)
	#define Y_GREY74                  MK_RGBA(189, 189, 189, 0)
	#define Y_GREY_74                 MK_RGBA(189, 189, 189, 0)
	#define Y_GRAY75                  MK_RGBA(191, 191, 191, 0)
	#define Y_GRAY_75                 MK_RGBA(191, 191, 191, 0)
	#define Y_GREY75                  MK_RGBA(191, 191, 191, 0)
	#define Y_GREY_75                 MK_RGBA(191, 191, 191, 0)
	#define Y_GRAY76                  MK_RGBA(194, 194, 194, 0)
	#define Y_GRAY_76                 MK_RGBA(194, 194, 194, 0)
	#define Y_GREY76                  MK_RGBA(194, 194, 194, 0)
	#define Y_GREY_76                 MK_RGBA(194, 194, 194, 0)
	#define Y_GRAY77                  MK_RGBA(196, 196, 196, 0)
	#define Y_GRAY_77                 MK_RGBA(196, 196, 196, 0)
	#define Y_GREY77                  MK_RGBA(196, 196, 196, 0)
	#define Y_GREY_77                 MK_RGBA(196, 196, 196, 0)
	#define Y_GRAY78                  MK_RGBA(199, 199, 199, 0)
	#define Y_GRAY_78                 MK_RGBA(199, 199, 199, 0)
	#define Y_GREY78                  MK_RGBA(199, 199, 199, 0)
	#define Y_GREY_78                 MK_RGBA(199, 199, 199, 0)
	#define Y_GRAY79                  MK_RGBA(201, 201, 201, 0)
	#define Y_GRAY_79                 MK_RGBA(201, 201, 201, 0)
	#define Y_GREY79                  MK_RGBA(201, 201, 201, 0)
	#define Y_GREY_79                 MK_RGBA(201, 201, 201, 0)
	#define Y_GRAY80                  MK_RGBA(204, 204, 204, 0)
	#define Y_GRAY_80                 MK_RGBA(204, 204, 204, 0)
	#define Y_GREY80                  MK_RGBA(204, 204, 204, 0)
	#define Y_GREY_80                 MK_RGBA(204, 204, 204, 0)
	#define Y_GRAY81                  MK_RGBA(207, 207, 207, 0)
	#define Y_GRAY_81                 MK_RGBA(207, 207, 207, 0)
	#define Y_GREY81                  MK_RGBA(207, 207, 207, 0)
	#define Y_GREY_81                 MK_RGBA(207, 207, 207, 0)
	#define Y_GRAY82                  MK_RGBA(209, 209, 209, 0)
	#define Y_GRAY_82                 MK_RGBA(209, 209, 209, 0)
	#define Y_GREY82                  MK_RGBA(209, 209, 209, 0)
	#define Y_GREY_82                 MK_RGBA(209, 209, 209, 0)
	#define Y_GRAY83                  MK_RGBA(212, 212, 212, 0)
	#define Y_GRAY_83                 MK_RGBA(212, 212, 212, 0)
	#define Y_GREY83                  MK_RGBA(212, 212, 212, 0)
	#define Y_GREY_83                 MK_RGBA(212, 212, 212, 0)
	#define Y_GRAY84                  MK_RGBA(214, 214, 214, 0)
	#define Y_GRAY_84                 MK_RGBA(214, 214, 214, 0)
	#define Y_GREY84                  MK_RGBA(214, 214, 214, 0)
	#define Y_GREY_84                 MK_RGBA(214, 214, 214, 0)
	#define Y_GRAY85                  MK_RGBA(217, 217, 217, 0)
	#define Y_GRAY_85                 MK_RGBA(217, 217, 217, 0)
	#define Y_GREY85                  MK_RGBA(217, 217, 217, 0)
	#define Y_GREY_85                 MK_RGBA(217, 217, 217, 0)
	#define Y_GRAY86                  MK_RGBA(219, 219, 219, 0)
	#define Y_GRAY_86                 MK_RGBA(219, 219, 219, 0)
	#define Y_GREY86                  MK_RGBA(219, 219, 219, 0)
	#define Y_GREY_86                 MK_RGBA(219, 219, 219, 0)
	#define Y_GRAY87                  MK_RGBA(222, 222, 222, 0)
	#define Y_GRAY_87                 MK_RGBA(222, 222, 222, 0)
	#define Y_GREY87                  MK_RGBA(222, 222, 222, 0)
	#define Y_GREY_87                 MK_RGBA(222, 222, 222, 0)
	#define Y_GRAY88                  MK_RGBA(224, 224, 224, 0)
	#define Y_GRAY_88                 MK_RGBA(224, 224, 224, 0)
	#define Y_GREY88                  MK_RGBA(224, 224, 224, 0)
	#define Y_GREY_88                 MK_RGBA(224, 224, 224, 0)
	#define Y_GRAY89                  MK_RGBA(227, 227, 227, 0)
	#define Y_GRAY_89                 MK_RGBA(227, 227, 227, 0)
	#define Y_GREY89                  MK_RGBA(227, 227, 227, 0)
	#define Y_GREY_89                 MK_RGBA(227, 227, 227, 0)
	#define Y_GRAY90                  MK_RGBA(229, 229, 229, 0)
	#define Y_GRAY_90                 MK_RGBA(229, 229, 229, 0)
	#define Y_GREY90                  MK_RGBA(229, 229, 229, 0)
	#define Y_GREY_90                 MK_RGBA(229, 229, 229, 0)
	#define Y_GRAY91                  MK_RGBA(232, 232, 232, 0)
	#define Y_GRAY_91                 MK_RGBA(232, 232, 232, 0)
	#define Y_GREY91                  MK_RGBA(232, 232, 232, 0)
	#define Y_GREY_91                 MK_RGBA(232, 232, 232, 0)
	#define Y_GRAY92                  MK_RGBA(235, 235, 235, 0)
	#define Y_GRAY_92                 MK_RGBA(235, 235, 235, 0)
	#define Y_GREY92                  MK_RGBA(235, 235, 235, 0)
	#define Y_GREY_92                 MK_RGBA(235, 235, 235, 0)
	#define Y_GRAY93                  MK_RGBA(237, 237, 237, 0)
	#define Y_GRAY_93                 MK_RGBA(237, 237, 237, 0)
	#define Y_GREY93                  MK_RGBA(237, 237, 237, 0)
	#define Y_GREY_93                 MK_RGBA(237, 237, 237, 0)
	#define Y_GRAY94                  MK_RGBA(240, 240, 240, 0)
	#define Y_GRAY_94                 MK_RGBA(240, 240, 240, 0)
	#define Y_GREY94                  MK_RGBA(240, 240, 240, 0)
	#define Y_GREY_94                 MK_RGBA(240, 240, 240, 0)
	#define Y_GRAY95                  MK_RGBA(242, 242, 242, 0)
	#define Y_GRAY_95                 MK_RGBA(242, 242, 242, 0)
	#define Y_GREY95                  MK_RGBA(242, 242, 242, 0)
	#define Y_GREY_95                 MK_RGBA(242, 242, 242, 0)
	#define Y_GRAY96                  MK_RGBA(245, 245, 245, 0)
	#define Y_GRAY_96                 MK_RGBA(245, 245, 245, 0)
	#define Y_GREY96                  MK_RGBA(245, 245, 245, 0)
	#define Y_GREY_96                 MK_RGBA(245, 245, 245, 0)
	#define Y_GRAY97                  MK_RGBA(247, 247, 247, 0)
	#define Y_GRAY_97                 MK_RGBA(247, 247, 247, 0)
	#define Y_GREY97                  MK_RGBA(247, 247, 247, 0)
	#define Y_GREY_97                 MK_RGBA(247, 247, 247, 0)
	#define Y_GRAY98                  MK_RGBA(250, 250, 250, 0)
	#define Y_GRAY_98                 MK_RGBA(250, 250, 250, 0)
	#define Y_GREY98                  MK_RGBA(250, 250, 250, 0)
	#define Y_GREY_98                 MK_RGBA(250, 250, 250, 0)
	#define Y_GRAY99                  MK_RGBA(252, 252, 252, 0)
	#define Y_GRAY_99                 MK_RGBA(252, 252, 252, 0)
	#define Y_GREY99                  MK_RGBA(252, 252, 252, 0)
	#define Y_GREY_99                 MK_RGBA(252, 252, 252, 0)
	#define Y_GRAY100                 MK_RGBA(255, 255, 255, 0)
	#define Y_GRAY_100                MK_RGBA(255, 255, 255, 0)
	#define Y_GREY100                 MK_RGBA(255, 255, 255, 0)
	#define Y_GREY_100                MK_RGBA(255, 255, 255, 0)
	#define Y_DARKGREY                MK_RGBA(169, 169, 169, 0)
	#define Y_DARK_GREY               MK_RGBA(169, 169, 169, 0)
	#define Y_DARKGRAY                MK_RGBA(169, 169, 169, 0)
	#define Y_DARK_GRAY               MK_RGBA(169, 169, 169, 0)
	#define Y_DARKBLUE                MK_RGBA(  0,   0, 139, 0)
	#define Y_DARK_BLUE               MK_RGBA(  0,   0, 139, 0)
	#define Y_DARKCYAN                MK_RGBA(  0, 139, 139, 0)
	#define Y_DARK_CYAN               MK_RGBA(  0, 139, 139, 0)
	#define Y_DARKMAGENTA             MK_RGBA(139,   0, 139, 0)
	#define Y_DARK_MAGENTA            MK_RGBA(139,   0, 139, 0)
	#define Y_DARKRED                 MK_RGBA(139,   0,   0, 0)
	#define Y_DARK_RED                MK_RGBA(139,   0,   0, 0)
	#define Y_LIGHTGREEN              MK_RGBA(144, 238, 144, 0)
	#define Y_LIGHT_GREEN             MK_RGBA(144, 238, 144, 0)
