//
// Created:     05.09.06
// Aurthor:    Iain Gilbert
//

#if defined _base_included
  #endinput
#endif

#define _base_included
#pragma library base

#include <a_samp>
#include <core>
#include <float>
#include "utils\dini"

//#define dcmd(%1,%2,%3) if ((strcmp((%3)[1], #%1, true, (%2)) == 0) && ((((%3)[(%2) + 1] == 0) && (dcmd_%1(playerid, "")))||(((%3)[(%2) + 1] == 32) && (dcmd_%1(playerid, (%3)[(%2) + 2]))))) return 1

#pragma tabsize 0

#define VERSION "v.0.6.9 b6 Lite"
#define VERSIONNAME "To be continued..."

#define MAX_STRING 255
#define MAX_NAME MAX_PLAYER_NAME
#define INACTIVE_PLAYER_ID 255
#define INVALID_QUEST_ID 0
#define MAX_QUESTS 255
#define MAX_WIN 500000 // Maximum gambling win
#define MAX_SPAWNPOINTS 50
#define MAX_COUNTDOWN 5
#define MAX_PING 500

#define COLOUR_GREY 0xAFAFAFAA // grey
#define COLOUR_GREEN 0x33AA33AA // green
#define COLOUR_LIGHTGREEN 0x9ACD32AA //lightgreen
#define COLOUR_RED 0xFF3333AA // red
#define COLOUR_LIGHTRED 0xFF6347AA // lightred
#define COLOUR_YELLOW 0xFFFF00AA // yellow
#define COLOUR_WHITE 0xFFFFFFAA // white
#define COLOUR_BLUE 0x33AAFFAA // blue
#define COLOUR_LIGHTBLUE 0x33CCFFAA // LightBlue
#define COLOUR_ORANGE 0xFF9900AA //orange
#define COLOUR_PURPLE 0xC2A2DAAA //purple

#define COLOUR_CRIMSON 0xDC143CAA
#define COLOUR_LIMEGREEN 0x32CD32AA
#define COLOUR_AQUA 0x00FFFFAA
#define COLOUR_FLBLUE 0x6495EDAA
#define COLOUR_MAGENTA 0xFF00FFFF
#define COLOUR_GOLD 0xB8860BAA
#define COLOUR_PINK 0xFFC0CBAA



// TODO: more colours
#define COLOUR_MISC 0xAFAFAFAA // Grey - Misc
#define COLOUR_CHAT 0xFFFFFFAA // White - Chat
#define COLOUR_PLAYER 0xAAAAAAAA // White - Player
#define COLOUR_XP_GOOD 0x00C7FFAA // Blue - XP
#define COLOUR_XP_BAD 0x00008BAA // Blue - XP
#define COLOUR_COMBAT_GOOD 0xAA3333AA // Red - Combat
#define COLOUR_COMBAT_BAD 0xBB3333AA // Red - Combat
#define COLOUR_MONEY_GOOD 0xFFFF00AA // Yellow - Money
#define COLOUR_MONEY_BAD 0xDAA520AA // Yellow - Money
#define COLOUR_RACE 0x005407AA // green - dark
#define COLOUR_RACE_BAD 0x545407AA // yellow-green-dark
#define COLOUR_GANG 0xFF8C00AA // orange
#define COLOUR_GANG_CHAT 0xFFA500AA // orange
#define COLOUR_DM 0xFF0066AA // red - purple
#define COLOUR_DM_BAD 0xFF0066AA // red - purple



#define MIN_HEALTH 10
#define MAX_HEALTH 100
#define NUMVALUES 4	

new ConfigDB[MAX_STRING] = "GTO/Config/GTO.Config.Base.txt";
new LevelDB[MAX_STRING] = "GTO/Config/GTO.Config.Levels.txt";
new MOTDDB[MAX_STRING] = "GTO/Config/GTO.MOTD.txt";
new SecurityDB[MAX_STRING] = "GTO/Config/GTO.Security.txt";
new BansDB[MAX_STRING] = "GTO/Bans.txt";
new Verbose_Save=-1; // do we save extra un-needed db info like weapons, races, vehicels, deathmatches, etc
new ForceOverwrite = 0;


// xyz coord info
enum CoordInfo {
    Float:Coord_X,
    Float:Coord_Y,
    Float:Coord_Z
}
new PlayerPos[MAX_PLAYERS][CoordInfo];

new KickList[MAX_PLAYERS];
new DBSeperator= 124; // seperate db fields.atm for db writing im just sending a string, which is written to a file.
new nullstr[MAX_STRING];

enum LevelInfo {
	level_xp,
    	level_name[MAX_STRING]
}

#define MAX_LEVEL 40
#define MAX_XP  20000000
#define MAX_LVLXP 18000000


// level rank names by Baby Face / Cool
new LevelList[MAX_LEVEL+1][LevelInfo] = { // experience required for each level
{  0,		"Wannabe" },
{  500,		"Just Balla" },
{  1000,	"Foot Criminal" },
{  2000,	"Foot Soldier" },
{  5000,	"Foot Lieutenant" },
{  7500,	"Foot Captain" },
{  11000,	"Street Criminal" },
{  16000,	"Street Soldier" },
{  21000,	"Street Lieutenant" },
{  31000,	"Street Captain" },
{  46000,	"HardCore Soldier" },
{  70000,	"Maniac" },
{  100000,	"1st Star General" },
{  130000,	"2nd Star General" },
{  160000,	"3rd Star General" },
{  190000,	"4th Star General" },
{  230000,	"5th Star General" },
{  270000,	"Set Leader" },
{  320000,	"Body Guard" },
{  370000,	"Left Hand Man" },
{  450000, 	"Right Hand Man" },
{  500000,	"GodFather" },
{  570000,	"The Los-Santos City Manager" },
{  670000,	"The San-Fierro City Manager" },
{  770000,	"The Las-Venturas City Manager" },
{  880000, 	"President of San Andreas" },

{  990000,      "Leader of Parlament" },
{ 1100000,	"The Owner of Africa" },
{ 2200000,	"The Owner of Asia" },
{ 3300000,	"The Owner of America" },
{ 4400000,	"The Owner of Europa" },

{ 5500000,	"The Leader of SA-men" },
{ 6600000,	"Minister of The Planet" },
{ 7700000,	"The Savior of The World" },
{ 8800000,	"Cool Fan GTA" },
{10000000,	"The Subjugator of Ladies Hearts" },

{12000000,	"Warrior" }, // 36
{13500000,	"Captain" }, // 37
{15000000,	"Komandor" }, // 38
{18000000,	"Chieftain" }, // 39
{20000000,	"Admin" } // 40

};

forward Base_OnGameModeInit();

public Base_OnGameModeInit(){
	EnableTirePopping(1);
	EnableZoneNames(1);
	UsePlayerPedAnims();
	AllowAdminTeleport(1);
//	SetDisabledWeapons(21,43,44,45);
//	printf("SERVER: Weapons 21, 43-45 is DISABLED.");
	ShowPlayerMarkers(1);
	ShowNameTags(1);
	BaseConfig();
	return 0;
}

BaseConfig(){
	if (!dini_Exists(ConfigDB)) dini_Create(ConfigDB);
	if (!dini_Exists(LevelDB)) dini_Create(LevelDB);
	if (!dini_Exists(BansDB)) dini_Create(BansDB);
	if (!dini_Exists(MOTDDB)) dini_Create(MOTDDB);
	if (!dini_Exists(SecurityDB)) dini_Create(SecurityDB);

	new temp[MAX_STRING];

	set(temp,dini_Get(ConfigDB,"Verbose_Save"));
	if (strlen(temp) > 0) Verbose_Save = strval(temp);
	else { valstr(temp,Verbose_Save); dini_Set(ConfigDB,"Verbose_Save",temp);  }
	set(temp,nullstr);

	for (new i=0;i<=MAX_LEVEL;i++)
	{
		new tempname[MAX_STRING];
		format(tempname,sizeof(tempname),"Level%d_Rankname",i);
		set(temp,dini_Get(LevelDB,tempname));
		if (strlen(temp) > 0) set(LevelList[i][level_name],temp);
		else {
//			set(temp,LevelList[i][level_name]);
//			dini_Set(LevelDB,"Level%d_Rankname",temp);
			dini_Set(LevelDB,tempname,LevelList[i][level_name]);
			}
		set(temp,nullstr);
		
		format(tempname,sizeof(tempname),"Level%d_Experience",i);
		set(temp,dini_Get(LevelDB,tempname));
		if (strlen(temp) > 0) LevelList[i][level_xp] = strval(temp);
		else {
//			set(temp,LevelList[i][level_xp]);
			valstr(temp,LevelList[i][level_xp]);
//			dini_Set(LevelDB,"Level%d_Experience",temp);
			dini_Set(LevelDB,tempname,temp);
			}
		set(temp,nullstr);
	}

	return 0;
}

GetLevelName(level)
{
	new name[MAX_STRING];
	if ( (level < 0) || (level > MAX_LEVEL+1 ) ) return name;
	set(name,LevelList[level][level_name]);
	return name;
}

