/*----------------------------------------------------------------------------*\
					=======================================
					 y_groups - Player group abstractions! 
					=======================================
Description:
	Admin levels, gangs, teams etc - they're all "groups" of people, this
	provides an abstraction for all of these collections.
Legal:
	Version: MPL 1.1
	
	The contents of this file are subject to the Mozilla Public License Version 
	1.1 (the "License"); you may not use this file except in compliance with 
	the License. You may obtain a copy of the License at 
	http://www.mozilla.org/MPL/
	
	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	The Original Code is the YSI groups include.
	
	The Initial Developer of the Original Code is Alex "Y_Less" Cole.
	Portions created by the Initial Developer are Copyright (C) 2011
	the Initial Developer. All Rights Reserved.
	
	Contributors:
		ZeeX, koolk, JoeBullet/Google63, g_aSlice/Slice
	
	Thanks:
		JoeBullet/Google63 - Handy arbitrary ASM jump code using SCTRL.
		ZeeX - Very productive conversations.
		koolk - IsPlayerinAreaEx code.
		TheAlpha - Danish translation.
		breadfish - German translation.
		Fireburn - Dutch translation.
		yom - French translation.
		50p - Polish translation.
		Zamaroht - Spanish translation.
		Dracoblue, sintax, mabako, Xtreme, other coders - Producing other modes
			for me to strive to better.
		Pixels^ - Running XScripters where the idea was born.
		Matite - Pestering me to release it and using it.
	
	Very special thanks to:
		Thiadmer - PAWN, whose limits continue to amaze me!
		Kye/Kalcor - SA:MP.
		SA:MP Team past, present and future - SA:MP.
	
Version:
	1.0
Changelog:
	29/11/10:
		First version
\*----------------------------------------------------------------------------*/

#include <YSI\internal\y_version>

#undef _inc_y_groups

#include <YSI\internal\y_nogroups>

/*#if defined YSI_GROUPS_LAST
	#if YSI_GROUPS_LAST == 25
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CMD
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CMD
	#elseif YSI_GROUPS_LAST == 22
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CLASSES
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CLASSES
	#elseif YSI_GROUPS_LAST == 9
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_INTTEST
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_INTTEST
	#elseif YSI_GROUPS_LAST == 8
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_INTTEST2
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_INTTEST2
	#endif
	#undef YSI_GROUPS_LAST
#endif*/

#if defined _YSI_GROUPS_FIRST_HALF
	#undef _YSI_GROUPS_FIRST_HALF
#endif

// First, detect which library has included this.  If none then it was the user.
#if defined _inc_y_classes
	#if !defined _YSI_GROUP_CLASSES_INCLUDED
		// Although this is included before _GROUP_MAKE_NAME is set, it will
		// still be the correct value eventually.
		// Mark this library as existing.
		#define _YSI_GROUP_CLASSES_INCLUDED
		// These all need doing twice - once here and once below.
		//#if defined _YSI_HAS_GROUP_SYSTEM
		//	#include <YSI\internal\y_groupfirst>
		//#endif
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CLASSES
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CLASSES
		#if defined _YSI_HAS_GROUP_SYSTEM
			#include <YSI\internal\y_groupsecond>
			#include <YSI\internal\y_classgroups>
		#endif
		#include <YSI\internal\y_groupsingle>
		// End.
		#endinput
	#endif
#endif
#if defined _inc_y_commands
	#if !defined _YSI_GROUP_COMMANDS_INCLUDED
		// Although this is included before _GROUP_MAKE_NAME is set, it will
		// still be the correct value eventually.
		// Mark this library as existing.
		#define _YSI_GROUP_COMMANDS_INCLUDED
		// These all need doing twice - once here and once below.
		//#if defined _YSI_HAS_GROUP_SYSTEM
		//	#include <YSI\internal\y_groupfirst>
		//#endif
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CMD
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CMD
		#if defined _YSI_HAS_GROUP_SYSTEM
			#include <YSI\internal\y_groupsecond>
		#endif
		#include <YSI\internal\y_groupsingle>
		// End.
		#endinput
	#endif
#endif
#if defined _YSI_ALLOW_INTERNAL_TEST
	#if defined _inc_y_inttest
		#if !defined _YSI_GROUP_INTTEST_INCLUDED
			// Mark this library as existing.
			#define _YSI_GROUP_INTTEST_INCLUDED
			// These all need doing twice - once here and once below.
			//#if defined _YSI_HAS_GROUP_SYSTEM
			//	#include <YSI\internal\y_groupfirst>
			//#endif
			#undef _GROUP_MAKE_NAME
			#undef _GROUP_MAKE_LIMIT
			#define _GROUP_MAKE_NAME    _GROUP_MAKE_NAME_INTTEST
			#define _GROUP_MAKE_LIMIT   _GROUP_MAKE_LIMIT_INTTEST
			#if defined _YSI_HAS_GROUP_SYSTEM
				#include <YSI\internal\y_groupsecond>
			#endif
			#include <YSI\internal\y_groupsingle>
			// End.
			#endinput
		#endif
	#endif
	#if defined _inc_y_inttest2
		#if !defined _YSI_GROUP_INTTEST2_INCLUDED
			// Mark this library as existing.
			#define _YSI_GROUP_INTTEST2_INCLUDED
			// These all need doing twice - once here and once below.
			//#if defined _YSI_HAS_GROUP_SYSTEM
			//	#include <YSI\internal\y_groupfirst>
			//#endif
			#undef _GROUP_MAKE_NAME
			#undef _GROUP_MAKE_LIMIT
			#define _GROUP_MAKE_NAME    _GROUP_MAKE_NAME_INTTEST2
			#define _GROUP_MAKE_LIMIT   _GROUP_MAKE_LIMIT_INTTEST2
			#if defined _YSI_HAS_GROUP_SYSTEM
				#include <YSI\internal\y_groupsecond>
			#endif
			#include <YSI\internal\y_groupsingle>
			// End.
			#endinput
		#endif
	#endif
#endif

// ||                                                                         ||
// =============================================================================
// ||                                                                         ||
#define _YSI_GROUPS_FIRST_HALF
// ||                                                                         ||
// =============================================================================
// ||                                                                         ||

// User inclusion.
#if !defined _YSI_HAS_GROUP_SYSTEM
	#define _YSI_HAS_GROUP_SYSTEM
	// Include the main code.
	#include <a_samp>
	#include <YSI\internal\y_grouponce>
	
	// Include code for previous libraries.
	#if defined _YSI_GROUP_CLASSES_INCLUDED
		// This only needs to be done if the library was previously included.
		#define _YSIM_OVERRIDE          22
		#include <YSI\y_master>
		// Include the first half of the file for the call chain.
		//#include <YSI\internal\y_groupfirst>
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CLASSES
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CLASSES
		// Include the second half of the file for the methods.
		#include <YSI\internal\y_groupsecond>
		#include <YSI\internal\y_classgroups>
	#endif
	#if defined _YSI_GROUP_COMMANDS_INCLUDED
		// This only needs to be done if the library was previously included.
		#define _YSIM_OVERRIDE          25
		#include <YSI\y_master>
		// Include the first half of the file for the call chain.
		//#include <YSI\internal\y_groupfirst>
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        _GROUP_MAKE_NAME_CMD
		#define _GROUP_MAKE_LIMIT       _GROUP_MAKE_LIMIT_CMD
		// Include the second half of the file for the methods.
		#include <YSI\internal\y_groupsecond>
	#endif
	// Internal test library.
	#if defined _YSI_ALLOW_INTERNAL_TEST
		#if defined _YSI_GROUP_INTTEST_INCLUDED
			#define _YSIM_OVERRIDE      9
			#include <YSI\y_master>
			//#include <YSI\internal\y_groupfirst>
			#undef _GROUP_MAKE_NAME
			#undef _GROUP_MAKE_LIMIT
			#define _GROUP_MAKE_NAME    _GROUP_MAKE_NAME_INTTEST
			#define _GROUP_MAKE_LIMIT   _GROUP_MAKE_LIMIT_INTTEST
			#include <YSI\internal\y_groupsecond>
		#endif
		#if defined _YSI_GROUP_INTTEST2_INCLUDED
			#define _YSIM_OVERRIDE      8
			#include <YSI\y_master>
			//#include <YSI\internal\y_groupfirst>
			#undef _GROUP_MAKE_NAME
			#undef _GROUP_MAKE_LIMIT
			#define _GROUP_MAKE_NAME    _GROUP_MAKE_NAME_INTTEST2
			#define _GROUP_MAKE_LIMIT   _GROUP_MAKE_LIMIT_INTTEST2
			#include <YSI\internal\y_groupsecond>
		#endif
	#endif
#endif

// Now include any user defined libraries.
#if defined GROUP_LIBRARY_NAME
	#if defined GROUP_LIBRARY_SIZE
		// Include the generic group code for this new custom group.
		#if defined _YSIM_MANUAL_SET
			#define _YSIM_RESET_USER
		#endif
		#include <YSI\y_master>
		//#include <YSI\internal\y_groupsingle>
		//#include <YSI\internal\y_groupfirst>
		#undef _GROUP_MAKE_NAME
		#undef _GROUP_MAKE_LIMIT
		#define _GROUP_MAKE_NAME        GROUP_LIBRARY_NAME
		#define _GROUP_MAKE_LIMIT       GROUP_LIBRARY_SIZE
		#undef _YSI_GROUPS_FIRST_HALF
		// Include the second half of the file for the methods.
		#include <YSI\internal\y_groupsecond>
		#define _YSI_GROUPS_FIRST_HALF
		#include <YSI\internal\y_groupsingle>
		// Remove the definitions.
		//#undef GROUP_LIBRARY_SIZE
		//#undef GROUP_LIBRARY_NAME
	#else
		#error You must define both GROUP_LIBRARY_SIZE and GROUP_LIBRARY_NAME.
	#endif
#else
	#if defined GROUP_LIBRARY_SIZE
		#error You must define both GROUP_LIBRARY_SIZE and GROUP_LIBRARY_NAME.
	#endif
#endif

// Revert to the user's included definition if y_groups was included after all
// group using libraries and after explicit y_master inclusion.
//#include <YSI\internal\y_grouprevert>

//#define YSI_SET_LAST_GROUP 24
#include <YSI\internal\y_grouprevert>
