
/*#######################################################################################################################################################
##################################################### /   #####################################################################
#########################################################################################################################################################*/

stock ToggleVehicleDoorsLocked ( vehicleid, val )
{
	new engine, lights, alarm, doors, bonnet, boot, objective;
	GetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	
	VEHICLE [ vehicleid ] [ LOCK ] = val ;
	
	SetVehicleParamsEx ( vehicleid, engine, lights, alarm, VEHICLE [ vehicleid ] [ LOCK ], bonnet, boot, objective ) ;
	return 1;
}

/*#######################################################################################################################################################
######################################################	/   ###################################################################
#########################################################################################################################################################*/

stock ToggleVehicleLights ( vehicleid )
{
	new engine,lights,alarm,doors,bonnet,boot,objective;
	GetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	
	SetVehicleParamsEx ( vehicleid, engine, ( lights == VEHICLE_PARAMS_UNSET || lights == VEHICLE_PARAMS_OFF ) ? VEHICLE_PARAMS_ON : VEHICLE_PARAMS_OFF, alarm, doors, bonnet, boot, objective ) ;
	return 1;
}

/*#######################################################################################################################################################
##################################################### /   ##################################################################
#########################################################################################################################################################*/

stock ToggleVehicleBoot ( playerid, vehicleid )
{
	new engine, lights, alarm, doors, bonnet, boot, objective;
	GetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	
	if ( boot == VEHICLE_PARAMS_UNSET || boot == VEHICLE_PARAMS_OFF )
		boot = VEHICLE_PARAMS_ON, OnPlayerCommandText ( playerid, "/  ." ) ;
	else
		boot = VEHICLE_PARAMS_OFF, OnPlayerCommandText ( playerid, "/  ." ) ;
	
	SetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	return 1;
}

/*#######################################################################################################################################################
##################################################### /   #####################################################################
#########################################################################################################################################################*/

stock ToggleVehicleBonnet ( playerid, vehicleid )
{
	new engine, lights, alarm, doors, bonnet, boot, objective;
	GetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	
	if ( bonnet == VEHICLE_PARAMS_UNSET || bonnet == VEHICLE_PARAMS_OFF )
		bonnet = VEHICLE_PARAMS_ON, OnPlayerCommandText ( playerid, "/  ." ) ;
	else
		bonnet = VEHICLE_PARAMS_OFF, OnPlayerCommandText ( playerid, "/  ." ) ;
	
	SetVehicleParamsEx ( vehicleid, engine, lights, alarm, doors, bonnet, boot, objective ) ;
	return 1;
}

/*#######################################################################################################################################################
#####################################################		   		#####################################################################
#########################################################################################################################################################*/

stock ReturnTypeVehicle ( model )
{
	if ( 400 > model > 611 ) return -1;
	switch ( model )
	{
		case 509,481,510:												return VELO;
		case 461..463,448,581,521..523,586,468,471:						return MOTO;
		case 417,425,447,469,487,488,497,548,563:						return HELICOPTER;
		case 460,476,511..513,519,520,553,577,592,593:					return AIRPLANE;
		case 435,450,569,570,584,590,591,606..608,610,611:				return TRAILER;
		case 472,473,493,595,484,430,453,452,446,454:					return BOAT;
		case 499,498,609,524,578,455,403,414,443,514,515,408,456,433:	return AUTO_B;
		case 431,437:													return BUS;
		case 441,464,465,501,564,594:									return RC;
		default:														return AUTO_A;
	}
	return -1;
}

/*#######################################################################################################################################################
######################################################		      #####################################################################
#########################################################################################################################################################*/

stock MyRemovePlayerFromVehicle ( playerid )
{
	SetPVarInt ( playerid, "RemoveVehicle", GetPlayerVehicleID ( playerid ) ) ;
	RemovePlayerFromVehicle ( playerid ) ;
	SetTimerEx ( "CheckRemovePlayerFromVehicle" , 3000, false, "i", playerid ) ;
	return 1;
}

forward CheckRemovePlayerFromVehicle ( playerid ) ;
public CheckRemovePlayerFromVehicle ( playerid )
{
	if ( IsPlayerInVehicle ( playerid, GetPVarInt ( playerid, "RemoveVehicle" ) ) ) AntiCheatMessage ( playerid, "   " ) ;
	DeletePVar ( playerid, "RemoveVehicle" ) ;
	return 1;
}

/*#######################################################################################################################################################
######################################################       #####################################################################
#########################################################################################################################################################*/

stock MyPutPlayerInVehicle ( playerid, vehicleid, seatid )
{
	SetPVarInt ( playerid, "VehicleID", vehicleid ) ;
	SetPVarInt ( playerid, "UseEnterVehicle", 1 ) ;
	PutPlayerInVehicle ( playerid, vehicleid, seatid ) ;
	SetTimerEx ( "CheckPutPlayerInVehicle" , 1500, false, "i", playerid ) ;
	return 1;
}

forward CheckPutPlayerInVehicle ( playerid ) ;
public CheckPutPlayerInVehicle ( playerid )
{
	if ( !IsPlayerInVehicle ( playerid, GetPVarInt ( playerid, "VehicleID" ) ) ) AntiCheatMessage ( playerid, "   " ) ;
	return 1;
}

/*#######################################################################################################################################################
######################################################   	   #####################################################################
#########################################################################################################################################################*/

stock ReturnNearIndexVehicle ( playerid, Float:Radius )
{
	new Float:vPos [ 3 ];
	
	for ( new idx = 0, vehicleid = 0; idx < cvector_size ( PVEHICLES ) ; idx++ )
	{
		vehicleid = cvector_get ( PVEHICLES, idx ) ;
		if ( vehicleid == -1 || !VEHICLE [ vehicleid ] [ ID ] ) continue;
		
		GetVehiclePos ( vehicleid, vPos [ 0 ] , vPos [ 1 ] , vPos [ 2 ]  ) ;
		
		if ( IsPlayerInRangeOfPoint ( playerid, Radius, vPos [ 0 ] , vPos [ 1 ] , vPos [ 2 ]  ) ) return vehicleid;
	}
	return -1;
}

/*#######################################################################################################################################################
#####################################################		  		#####################################################################
#########################################################################################################################################################*/

stock ClearVehicleInfo ( vehicleid )
{
	VEHICLE [ vehicleid ] [ ID ] = 0;
	VEHICLE [ vehicleid ] [ MID ] = 0;
	VEHICLE [ vehicleid ] [ MODEL ] = 0;
	VEHICLE [ vehicleid ] [ COLOR ] [ 0 ] = 0;
	VEHICLE [ vehicleid ] [ COLOR ] [ 1 ] = 0;
	VEHICLE [ vehicleid ] [ POSITION ] [ 0 ] = 0.0;
	VEHICLE [ vehicleid ] [ POSITION ] [ 1 ] = 0.0;
	VEHICLE [ vehicleid ] [ POSITION ] [ 2 ] = 0.0;
	VEHICLE [ vehicleid ] [ POSITION ] [ 3 ] = 0.0;
	VEHICLE [ vehicleid ] [ FUEL ] = 0.0;
	VEHICLE [ vehicleid ] [ TYPE ] = -1;
	VEHICLE [ vehicleid ] [ OWNER ] = -1;
	VEHICLE [ vehicleid ] [ LOCK ] = -1;
	VEHICLE [ vehicleid ] [ ENGINE ] = -1;
	VEHICLE [ vehicleid ] [ HEALTH ] = 0.0;
	VEHICLE [ vehicleid ] [ TIRES ] = 0;
	VEHICLE [ vehicleid ] [ PANELS ] = 0;
	VEHICLE [ vehicleid ] [ DOORS ] = 0;
	VEHICLE [ vehicleid ] [ LIGHTS ] = 0;
	VEHICLE [ vehicleid ] [ TEXTID ] = Text:-1;
	VEHICLE [ vehicleid ] [ LOAD ] = 0.0;
	VEHICLE [ vehicleid ] [ OBJECT ] [ 0 ] = 0;
	VEHICLE [ vehicleid ] [ OBJECT ] [ 1 ] = 0;
	VEHICLE [ vehicleid ] [ OBJECT ] [ 2 ] = 0;
	VEHICLE [ vehicleid ] [ OBJECT ] [ 3 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 0 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 1 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 2 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 3 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 4 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 5 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 6 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 7 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 8 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 9 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 10 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 11 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 12 ] = 0;
	VEHICLE [ vehicleid ] [ TUNING ] [ 13 ] = 0;
	VEHICLE [ vehicleid ] [ PAINTJOB ] = 0;
	VEHICLE [ vehicleid ] [ PRICE ] = 0;
	VEHICLE [ vehicleid ] [ TEXTID3D ] = Text3D:-1;
	
	return 1;
}

stock CreateSalonVehicle ( model, Float:x, Float:y, Float:z, Float:a, owner )
{
	new color [ 2 ] ;
	
	color [ 0 ] = random ( 256 ) ;
	color [ 1 ] = random ( 256 ) ;
	
	new vehicleid = CreateVehicle ( model, x, y, z, a, color [ 0 ], color [ 1 ], 15 ) ;
	
	VEHICLE [ vehicleid ] [ OWNER ]		=	owner ;
	VEHICLE [ vehicleid ] [ ID ] 		= 	vehicleid ;
	VEHICLE [ vehicleid ] [ MODEL ] 	= 	model ;
	VEHICLE [ vehicleid ] [ TYPE ] 		= 	VSALON ;
	VEHICLE [ vehicleid ] [ FUEL ]		= 	10;
	VEHICLE [ vehicleid ] [ HEALTH ]	= 	1000.0;
	VEHICLE [ vehicleid ] [ PRICE ] 	= 	VehiclePrice [ model - 400 ];
	VEHICLE [ vehicleid ] [ COLOR ] [ 0 ] = color [ 0 ] ;
	VEHICLE [ vehicleid ] [ COLOR ] [ 1 ] = color [ 1 ] ;
	
	VEHICLE [ vehicleid ] [ POSITION ] [ 0 ] = x ;
	VEHICLE [ vehicleid ] [ POSITION ] [ 1 ] = y;
	VEHICLE [ vehicleid ] [ POSITION ] [ 2 ] = z ;
	VEHICLE [ vehicleid ] [ POSITION ] [ 3 ] = a ;
	
	new temp [ 50 ] ;
	echo ( temp, ": %s | : $%d", VehicleName [ model - 400 ], VEHICLE [ vehicleid ] [ PRICE ] ) ;
	VEHICLE [ vehicleid ] [ TEXTID3D ] = CreateDynamic3DTextLabel ( temp, 0x2186A5FF, 0.0, 0.0, 0.0, 15.0, INVALID_PLAYER_ID, vehicleid, 0, 0, 0, -1 ) ;
	
	sscanf ( "Not Plate", "s[10]", VEHICLE [ vehicleid ] [ PLATE ] ) ;
	SetVehicleNumberPlate ( vehicleid, VEHICLE [ vehicleid ] [  PLATE ] ) ;
	
	new query [ 256 ] ;
	echo ( query, "INSERT INTO `vehicles` \
	( `model`, `pos_x`, `pos_y`, `pos_z`, `angle`, `color_one`, `color_two`, `type`, `owner`, `price` ) VALUES ( '%d', '%f', '%f', '%f', '%f', '%d', '%d', '%d', '%d', '%d' )", 
	model,
	x, y, z, a,
	color [ 0 ], color [ 1 ],
	VSALON,
	owner,
	VEHICLE [ vehicleid ] [ PRICE ]	) ;
	
	mysql_function_query ( dbHandle, query, false, "", "" ) ;
	
	echo ( query, "SELECT MAX(`id`) as `last_id` FROM `vehicles` WHERE `type` = '%d' AND `owner` = '%d' LIMIT 1", VSALON, owner );
	mysql_function_query ( dbHandle, query, true, "NewSalonVehicle", "i", vehicleid ) ;
	
	cvector_push_back ( PVEHICLES, vehicleid ) ;
	
	return vehicleid;
}

