/*#######################################################################################################################################################
#################################################     			#########################################################
#########################################################################################################################################################*/


stock ReturnIndexHouseForID ( id )
{
	for ( new sid = 0; sid < HouseCount; sid++ ) if ( HOUSE [ sid ] [ ID ] == id ) return sid;
	return -1;
}


stock ReturnFreeIndexHouse ( )
{
	for ( new sid = 0; sid < MAX_HOUSE; sid++ ) if ( !HOUSE [ sid ] [ ID ] ) return sid;
	return -1;
}


stock ReturnNearIndexHouse ( playerid, Float:Out, Float:In )
{
	for ( new i = 0; i < HouseCount; i++ )
	{
		if ( !HOUSE [ i ] [ ID ] ) continue;
		
		new hint = HOUSE [ i ] [ Int ] ;
		
		if ( GetPlayerVirtualWorld ( playerid ) == 0 )
		{
			if ( IsPlayerInRangeOfPoint ( playerid, Out, HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ] ) ) 
				return i;
		}
		else if ( GetPlayerVirtualWorld ( playerid ) == ( HOUSE [ i ] [ ID ] + 1000 ) )
		{
			if ( IsPlayerInRangeOfPoint ( playerid, In, HouseInt [ hint ] [ Position ] [ 0 ] , HouseInt [ hint ] [ Position ] [ 1 ], HouseInt [ hint ] [ Position ] [ 2 ] ) )
				return i;
		}
	}
	return -1;
}


stock EnterExitHouse ( playerid, hid )
{
	if ( hid == -1 ) return 1;
	
	new hint = HOUSE [ hid ] [ Int ] ;
	
	if ( GetPlayerVirtualWorld ( playerid ) == 0 )
	{
		if ( IsPlayerInRangeOfPoint ( playerid, 1.00, HOUSE [ hid ] [ Position ] [ 0 ], HOUSE [ hid ] [ Position ] [ 1 ], HOUSE [ hid ] [ Position ] [ 2 ] ) )
		{
			MySetPlayerPos ( playerid, HouseInt [ hint ] [ Position ] [ 0 ] , HouseInt [ hint ] [ Position ] [ 1 ], HouseInt [ hint ] [ Position ] [ 2 ], HouseInt [ hint ] [ Position ] [ 3 ], HouseInt [ hint ] [ Int ], HOUSE [ hid ] [ ID ] + 1000 ) ;
					
			PlayerTextDrawSetString ( playerid, ZoneName [ playerid ], HOUSE [ hid ] [ Name ] ) ;
		}
	}
	else if ( GetPlayerVirtualWorld ( playerid ) == ( HOUSE [ hid ] [ ID ] + 1000 ) )
	{
		if ( IsPlayerInRangeOfPoint ( playerid, 1.00, HouseInt [ hint ] [ Position ] [ 0 ] , HouseInt [ hint ] [ Position ] [ 1 ], HouseInt [ hint ] [ Position ] [ 2 ] ) )
		{
			MySetPlayerPos ( playerid, HOUSE [ hid ] [ Position ] [ 0 ], HOUSE [ hid ] [ Position ] [ 1 ], HOUSE [ hid ] [ Position ] [ 2 ], HOUSE [ hid ] [ Position ] [ 3 ], 0, 0 ) ;
		}			
	}
	return 1;
}


stock DeleteHouseItems ( i )
{
	DestroyDynamicPickup ( HOUSE [ i ] [ PickupId ] ) ;
	DestroyDynamicMapIcon ( HOUSE [ i ] [ IconId ] ) ;
	DestroyDynamic3DTextLabel ( HOUSE [ i ] [ TextId ] ) ;
	
	return 1;
}


stock CreateHouseItems ( i )
{
	new text [ 128 ] ;
	
	if ( HOUSE [ i ] [ Owner ] == -1 )
	{
		echo ( text, "{00FF00}  \"%s\" (#%d)\n\n: $%d\n\n(( - ,  /  ))\n(( - ,   ALT ))", HOUSE [ i ] [ Name ], HOUSE [ i ] [ ID ], HOUSE [ i ] [ Price ] ) ;
		
		HOUSE [ i ] [ PickupId ] = CreateDynamicPickup ( 1273, 23, HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ], 0, 0 ) ;
		
		HOUSE [ i ] [ IconId ] = CreateDynamicMapIcon ( HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ], 31, 0, 0, 0, -1, 200.0 ) ;
	}
	else
	{
		echo ( text, "{FF0000} \"%s\" (#%d)\n\n: %s\n\n(( - ,   ALT ))", HOUSE [ i ] [ Name ], HOUSE [ i ] [ ID ], HOUSE [ i ] [ OwnerName ] ) ;
		
		HOUSE [ i ] [ PickupId ] = CreateDynamicPickup ( 1314, 23, HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ], 0, 0 ) ;
		
		HOUSE [ i ] [ IconId ] = CreateDynamicMapIcon ( HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ], 32, 0, 0, 0, -1, 200.0 ) ;
	}
	
	HOUSE [ i ] [ TextId ] = CreateDynamic3DTextLabel ( text, -1, HOUSE [ i ] [ Position ] [ 0 ], HOUSE [ i ] [ Position ] [ 1 ], HOUSE [ i ] [ Position ] [ 2 ] + 0.7, 10.0, INVALID_PLAYER_ID, INVALID_VEHICLE_ID, 0, 0, 0 ) ;
	
	return 1;
}

stock CreateHouseExit ( i )
{
	new hint = HOUSE [ i ] [ Int ] ;
	
	CreateDynamicPickup ( 19133, 23, HouseInt [ hint ] [ Position ] [ 0 ], HouseInt [ hint ] [ Position ] [ 1 ], HouseInt [ hint ] [ Position ] [ 2 ], HOUSE [ i ] [ ID ] + 1000, HouseInt [ hint ] [ Int ] ) ;
	
	new text [ 128 ] ;
	echo ( text, " \"%s\" (%d)\n\n\n\n\n\n(( - ,   ALT ))", HOUSE [ i ] [ Name ], HOUSE [ i ] [ ID ] ) ;
	
	HOUSE [ i ] [ ExitTextId ] = CreateDynamic3DTextLabel ( text, -1, HouseInt [ hint ] [ Position ] [ 0 ], HouseInt [ hint ] [ Position ] [ 1 ], HouseInt [ hint ] [ Position ] [ 2 ] + 0.7, 5.0, INVALID_PLAYER_ID, INVALID_VEHICLE_ID, 0, HOUSE [ i ] [ ID ] + 1000, HouseInt [ hint ] [ Int ] ) ;

	return 1;
}

stock CreateHouse ( playerid, price, h, hint )
{
	new sql_query [ 256 ] ;
	
	echo ( sql_query, "INSERT INTO `houses` \
	( `int`, `pos_x`, `pos_y`, `pos_z`, `face_angle`, `price`, `name` ) VALUES \
	( '%d',  '%f',    '%f',    '%f',    '%f',         '%d',    'None' )", 
	hint, 
	PLAYER [ playerid ] [ POSITION ] [ 0 ], 
	PLAYER [ playerid ] [ POSITION ] [ 1 ], 
	PLAYER [ playerid ] [ POSITION ] [ 2 ], 
	PLAYER [ playerid ] [ POSITION ] [ 3 ], 
	price ) ;
	
	mysql_function_query ( dbHandle, sql_query, false, "", "" ) ;
	
	HOUSE [ h ] [ Price ] = price ;
	HOUSE [ h ] [ Owner ] = -1 ;
	sscanf ( "None", "s[5]", HOUSE [ h ] [ OwnerName ] ) ;
	sscanf ( "None", "s[5]", HOUSE [ h ] [ Name ] ) ;
	HOUSE [ h ] [ Position ] [ 0 ] = PLAYER [ playerid ] [ POSITION ] [ 0 ] ;
	HOUSE [ h ] [ Position ] [ 1 ] = PLAYER [ playerid ] [ POSITION ] [ 1 ] ;
	HOUSE [ h ] [ Position ] [ 2 ] = PLAYER [ playerid ] [ POSITION ] [ 2 ] ;
	HOUSE [ h ] [ Position ] [ 3 ] = PLAYER [ playerid ] [ POSITION ] [ 3 ] ;
	HOUSE [ h ] [ Int ] = hint ;
	
	mysql_function_query ( dbHandle, "SELECT MAX(`id`) as `last_id` FROM `houses` LIMIT 1", true, "LoadHouseLastId", "ii", playerid, h ) ;
	
	return 1;
}

forward LoadHouseLastId ( playerid, h );
public LoadHouseLastId ( playerid, h ) 
{
	new rows, fields, temp [ 11 ] ;
	cache_get_data ( rows, fields ) ;
	
	if ( rows )
	{
		cache_get_field_content ( 0, "last_id", temp ) , HOUSE [ h ] [ ID ] = strval ( temp );
		
		CreateHouseItems ( h ) ;
		CreateHouseExit ( h ) ;
		
		HouseCount++;
		
		new string [ 128 ] ;
		echo ( string, "   . (ID: #%d)", HOUSE [ h ][ ID ] ) ;
		SendClientMessage ( playerid, COLOR_BLUE, string ) ;
	}
	else
	{
		
		HOUSE [ h ] [ Price ] = 0 ;
		HOUSE [ h ] [ Owner ] = -1 ;
		HOUSE [ h ] [ Position ] [ 0 ] = 0.0 ;
		HOUSE [ h ] [ Position ] [ 1 ] = 0.0 ;
		HOUSE [ h ] [ Position ] [ 2 ] = 0.0 ;
		HOUSE [ h ] [ Position ] [ 3 ] = 0.0 ;
		HOUSE [ h ] [ Int ] = 0 ;
	
		SendClientMessage ( playerid, COLOR_GRAY, "  !" ) ;
	}
	return 1;
}
/*#######################################################################################################################################################
################################################# 					  	  ###################################################################
#########################################################################################################################################################*/

forward LoadHouses ( ) ;
public LoadHouses ( ) 
{
	new rows, fields, temp [ 50 ] ;
	cache_get_data ( rows, fields ) ;
	HouseCount = rows;
	if ( rows )
	{
		for ( new i = 0; i < rows; i++ )
		{
			cache_get_field_content ( i, "id", temp ), HOUSE [ i ] [ ID ] = strval ( temp ) ;
			cache_get_field_content ( i, "price", temp ), HOUSE [ i ] [ Price ] = strval ( temp ) ;
			cache_get_field_content ( i, "owner", temp ), HOUSE [ i ] [ Owner ] = strval ( temp ) ;
			cache_get_field_content ( i, "player_name", temp ), sscanf ( temp, "s[24]", HOUSE [ i ] [ OwnerName ] ) ;
			cache_get_field_content ( i, "name", temp ), sscanf ( temp, "s[50]", HOUSE [ i ] [ Name ] ) ;
			cache_get_field_content ( i, "pos_x", temp ), HOUSE [ i ] [ Position ] [ 0 ] = floatstr ( temp ) ;
			cache_get_field_content ( i, "pos_y", temp ), HOUSE [ i ] [ Position ] [ 1 ] = floatstr ( temp ) ;
			cache_get_field_content ( i, "pos_z", temp ), HOUSE [ i ] [ Position ] [ 2 ] = floatstr ( temp ) ;
			cache_get_field_content ( i, "face_angle", temp ), HOUSE [ i ] [ Position ] [ 3 ] = floatstr ( temp ) ;
			cache_get_field_content ( i, "int", temp ), HOUSE [ i ] [ Int ] = strval ( temp ) ;
			cache_get_field_content ( i, "close", temp ), HOUSE [ i ] [ Close ] = strval ( temp ) ;
			
			CreateHouseItems ( i ) ;
			CreateHouseExit ( i ) ;
		}
		
		printf ( " : %d", HouseCount ) ;
	}
	else
	{
		print ( "  " ) ;
	}
	return 1;
}

/*#######################################################################################################################################################
#################################################			 	 		  ###################################################################
#########################################################################################################################################################*/

stock SaveHouses (  ) 
{
	for ( new sid = 0; sid < HouseCount; sid++ )
	{
		if ( !HOUSE [ sid ] [ ID ] ) continue;
		
		printf ( " : %s ( ID: %d )", HOUSE [ sid ] [ Name ], HOUSE [ sid ] [ ID ] ) ;
		
		new query [ 512 ] ;
		
		new escape_name [ 50 ] ;
		mysql_real_escape_string ( HOUSE [ sid ] [ Name ], escape_name ) ;
		
		echo ( query, 
		"UPDATE `houses` SET \
		`owner` = '%d', \
		`price` = '%d', \
		`name` = '%s', \
		`int` = '%d', \
		`pos_x` = '%f', \
		`pos_y` = '%f', \
		`pos_z` = '%f', \
		`face_angle` = '%f', \
		`close` = '%d' \
		WHERE `id` = '%d' LIMIT 1", 
		HOUSE [ sid ] [ Owner ], 
		HOUSE [ sid ] [ Price ], 
		escape_name, 
		HOUSE [ sid ] [ Int ], 
		HOUSE [ sid ] [ Position ] [ 0 ],
		HOUSE [ sid ] [ Position ] [ 1 ],
		HOUSE [ sid ] [ Position ] [ 2 ],
		HOUSE [ sid ] [ Position ] [ 3 ],
		HOUSE [ sid ] [ Close ], 
		HOUSE [ sid ] [ ID ] ) ;

		mysql_function_query ( dbHandle, query, false, "", "" ) ;
	}
	return 1;
}

stock SaveHouse ( sid ) 
{
	if ( !HOUSE [ sid ] [ ID ] ) continue;
	
	printf ( " : %s ( ID: %d )", HOUSE [ sid ] [ Name ], HOUSE [ sid ] [ ID ] ) ;
	
	new query [ 512 ] ;
	
	new escape_name [ 50 ] ;
	mysql_real_escape_string ( HOUSE [ sid ] [ Name ], escape_name ) ;
	
	echo ( query, 
	"UPDATE `houses` SET \
	`owner` = '%d', \
	`name` = '%s', \
	`int` = '%d', \
	`pos_x` = '%f', \
	`pos_y` = '%f', \
	`pos_z` = '%f', \
	`face_angle` = '%f' \
	WHERE `id` = '%d' LIMIT 1", 
	HOUSE [ sid ] [ Owner ], 
	escape_name, 
	HOUSE [ sid ] [ Int ], 
	HOUSE [ sid ] [ Position ] [ 0 ],
	HOUSE [ sid ] [ Position ] [ 1 ],
	HOUSE [ sid ] [ Position ] [ 2 ],
	HOUSE [ sid ] [ Position ] [ 3 ],
	HOUSE [ sid ] [ ID ] ) ;
	
	mysql_function_query ( dbHandle, query, false, "", "" ) ;
	
	return 1;
}

