#include <a_samp>
#include <MXini>

#define MAX_GANGS 1000

new tgang[MAX_PLAYERS], Scores[MAX_PLAYERS], name[MAX_GANGS][256], col[MAX_GANGS][256], gangskin[MAX_PLAYERS], id[MAX_PLAYERS] = -1;
new GangName[MAX_GANGS][256], Gang[MAX_GANGS],
GangLvl[MAX_PLAYERS], GName[MAX_GANGS][256],
GColor[MAX_GANGS][100], PGang[MAX_PLAYERS],
Float:GSpawnX[MAX_GANGS], Float:GSpawnY[MAX_GANGS],
Float:GSpawnZ[MAX_GANGS], GSkin[MAX_GANGS][7];

public OnFilterScriptInit()
{
    GangLoad();
	print("\n--------------------------------------------");
	print("	   ! ");
	print("--------------------------------------------\n");
	return true;
}

public OnFilterScriptExit()
{
    for(new i; i<MAX_PLAYERS; i++) SaveAccount(i);
	return true;
}

public OnPlayerDisconnect(playerid, reason)
{
    SaveAccount(playerid);
	return true;
}

public OnPlayerRequestClass(playerid, classid)
{
    PGang[playerid] = 0;
    GangLvl[playerid] = 0;
    Scores[playerid] = 0;
    LoadAccount(playerid);
	return true;
}

public OnPlayerSpawn(playerid)
{
	SetTimerEx("Spawn", 500, false, "i", playerid);
	return true;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	Scores[killerid]++;
	return true;
}

public OnPlayerText(playerid, text[])
{
	new string[256];
	if(PGang[playerid] > 0)
	{
	    GetPlayerColor(playerid);
		format(string, sizeof(string), "[ %s] %s:{FFFFFF} %s", GName[PGang[playerid]], PlayerName(playerid), text);
		SendClientMessageToAll(GetPlayerColor(playerid), string);
	    return false;
	}
	return true;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	new cmd[256], idx;
	cmd = strtok(cmdtext,idx);
	if(strcmp(cmd, "/ascore", true) == 0)
	{
	    if(IsPlayerAdmin(playerid))
	    {
			new tmp[256], tmp2[256];
		    tmp = strtok(cmdtext, idx);
		    tmp2 = strtok(cmdtext, idx);
		    if(!strlen(tmp) || !strlen(tmp2)) return SendClientMessage(playerid, 0xFFFF00FF, "/ascore [id ][]");
			Scores[strval(tmp)] = strval(tmp2);
		}
		return true;
	}

	if(!strcmp(cmd, "/klen", true))
	{
		ShowPlayerDialog(playerid, 1001, DIALOG_STYLE_LIST, "{00FF00} {FF0000}", " \n \n  \n \n  \n  \n  \n  ", "", "");
		return true;
	}
	return false;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
    new string[256];
   	new tmp[256];
	if(dialogid == 1001)
	{
	    if(response)
	    {
		    switch(listitem)
		    {
		        case 0:
		        {
		            if(PGang[playerid] == 0 && GetPlayerMoney(playerid) >= 0)
//if(PGang[playerid] == 0 && Scores[playerid] >= 500 && GetPlayerMoney(playerid) >= 1000000)
					{
	                	ShowPlayerDialog(playerid, 2002, DIALOG_STYLE_INPUT, " ", "     :", "", "");
	                }else return SendClientMessage(playerid, 0xFF0000FF, "     ,        500000$.");
		        }
		        case 1:
		        {
		            if(PGang[playerid] != 0 && GangLvl[playerid] == 6)
					{
	                	ShowPlayerDialog(playerid, 8001, DIALOG_STYLE_LIST, "  ", "\n\n \n\n \n", "", "");
	                }else return SendClientMessage(playerid, 0xFF0000FF, "    ,       .");
		        }
		        case 2:
		        {
		            if(PGang[playerid] != 0 && GangLvl[playerid] == 6)
					{
	                	ShowPlayerDialog(playerid, 7001, DIALOG_STYLE_MSGBOX, "  ", "        ?", "", "");
	                }else return SendClientMessage(playerid, 0xFF0000FF, "    ,       .");
		        }
		        case 3:
		        {
		            if(PGang[playerid] != 0 && GangLvl[playerid] == 6)
					{
	                	ShowPlayerDialog(playerid, 9001, DIALOG_STYLE_INPUT, " ", " id ,    :", "", "");
	                }else return SendClientMessage(playerid, 0xFF0000FF, "    ,       .");
		        }
		        case 4:
		        {
					if(PGang[playerid] != 0 && GangLvl[playerid] >= 4)
					{
	                	ShowPlayerDialog(playerid, 3001, DIALOG_STYLE_INPUT, "  ", " id ,   :", "", "");
					}else return SendClientMessage(playerid, 0xFF0000FF, "    ,        4 .");
		        }
		        case 5:
		        {
					if(PGang[playerid] != 0 && GangLvl[playerid] >= 5)
					{
	                	ShowPlayerDialog(playerid, 4001, DIALOG_STYLE_INPUT, "  ", " id ,   :", "", "");
					}else return SendClientMessage(playerid, 0xFF0000FF, "    ,        5 .");
		        }
		        case 6:
		        {
					if(PGang[playerid] != 0 && GangLvl[playerid] == 6)
					{
	                	ShowPlayerDialog(playerid, 5001, DIALOG_STYLE_INPUT, "  ", " 6   RRGGBB:", "", "");
					}else return SendClientMessage(playerid, 0xFF0000FF, "    ,       .");
		        }
		        case 7:
		        {
					if(PGang[playerid] > 0)
					{
	                	ShowPlayerDialog(playerid, 6001, DIALOG_STYLE_MSGBOX, "  ", "     ?", "", "");
					}else return SendClientMessage(playerid, 0xFF0000FF, "    !");
		        }
		    }
		}
	}
	else if(dialogid == 2002)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 2003, DIALOG_STYLE_INPUT, " ", "  :", "", "");
			format(GangName[playerid], 256, inputtext);
			ShowPlayerDialog(playerid, 2003, DIALOG_STYLE_INPUT, " ", "  :", "", "");
	    }
	}
	else if(dialogid == 2003)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 999999, DIALOG_STYLE_INPUT, " ", "     :", "", "");
			if(strlen(inputtext) != 6)
			{
				SendClientMessage(playerid, 0xFF0000, "    6   RRGGBB!");
				return ShowPlayerDialog(playerid, 999999, DIALOG_STYLE_INPUT, " ", "  :", "", "");
			}
			new f[256];
			format(f, 256, "%i.ini", GetFreeGang());
			new cfile = ini_createFile(f);
			if(cfile == INI_OK)
			{
				GangLvl[playerid] = 6;
				PGang[playerid] = GetFreeGang();
				format(GName[PGang[playerid]], 256, GangName[playerid]);
				format(GColor[PGang[playerid]], 10, "%sFF", inputtext);
				new hex[MAX_PLAYERS];
				hex[playerid] = HexToInt(GColor[PGang[playerid]]);
				SetPlayerColor(playerid, hex[playerid]);
				Gang[GetFreeGang()] = 1;
				GivePlayerMoney(playerid, 10000000);
				format(string, sizeof(string), "  !\r\n : %s\r\n : %s", GName[PGang[playerid]], GColor[PGang[playerid]]);
				ShowPlayerDialog(playerid, 999, DIALOG_STYLE_MSGBOX, " ", string, "", "");
			    ini_setString(cfile, "Gang name", GName[PGang[playerid]]);
			    ini_setString(cfile, "Gang color", GColor[PGang[playerid]]);
   			    ini_setFloat(cfile, "SpawnX", 0.0);
			    ini_setFloat(cfile, "SpawnY", 0.0);
			    ini_setFloat(cfile, "SpawnZ", 0.0);
       			ini_setInteger(cfile, "Skin1", 0);
			    ini_setInteger(cfile, "Skin2", 0);
			    ini_setInteger(cfile, "Skin2", 0);
			    ini_setInteger(cfile, "Skin3", 0);
			    ini_setInteger(cfile, "Skin4", 0);
			    ini_setInteger(cfile, "Skin5", 0);
			    ini_setInteger(cfile, "Skin6", 0);
				ini_closeFile(cfile);
			}
	    }
	}
	else if(dialogid == 3001)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 3002, DIALOG_STYLE_INPUT, "  ", " id ,   :", "", "");
			if(IsPlayerConnected(strval(inputtext)))
			{
				if(PGang[strval(inputtext)] == 0)
				{
				    format(string, sizeof(string), "%s     %s", PlayerName(playerid), GName[PGang[playerid]]);
				    ShowPlayerDialog(strval(inputtext), 3002, DIALOG_STYLE_MSGBOX, "  ", string, "", "");
				    format(string, sizeof(string), " %s  %s  .", PlayerName(playerid), PlayerName(id[playerid]));
				    for(new i; i<MAX_PLAYERS; i++)
				    {
				        if(PGang[i] == PGang[playerid])
				        {

							SendClientMessage(i, 0xFF0000FF, string);
				        }
					}
				    tgang[strval(inputtext)] = PGang[playerid];
				}else return SendClientMessage(playerid, 0xFFFFFFFF, "    !");
			}else return SendClientMessage(playerid, 0xFFFFFFFF, "    !");
	    }
	}
	else if(dialogid == 3002)
	{
	    if(response)
	    {
            PGang[playerid] = tgang[playerid];
            GangLvl[playerid] = 1;
			new hex[MAX_PLAYERS];
			hex[playerid] = HexToInt(GColor[PGang[playerid]]);
			SetPlayerColor(playerid, hex[playerid]);
            format(string, sizeof(string), "    {FF0000}%s", GName[PGang[playerid]]);
            SendClientMessage(playerid, 0xFFFFFFFF, string);
            format(string, sizeof(string), "%s   !", PlayerName(playerid));
            for(new i; i<MAX_PLAYERS; i++)
            {
				if(PGang[i] == PGang[playerid])
				{
				    SendClientMessage(i, 0xFFFF00FF, string);
				}
            }
	    }
	    else
		{
		    tgang[playerid] = 0;
		}
	}
	else if(dialogid == 4001)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 6001, DIALOG_STYLE_INPUT, "  ", " id ,   :", "", "");
			if(IsPlayerConnected(strval(inputtext)))
			{
				if(PGang[strval(inputtext)] == PGang[playerid])
				{
					PGang[strval(inputtext)] = 0;
					GangLvl[strval(inputtext)] = 0;
					format(string, 256, "      %s", PlayerName(playerid));
					SendClientMessage(playerid, 0xFF0000FF, string);
				}else return SendClientMessage(playerid, 0xFFFFFFFF, "     !");
			}else return SendClientMessage(playerid, 0xFFFFFFFF, "    !");
	    }
	}
	else if(dialogid == 5001)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 17, DIALOG_STYLE_INPUT, "  ", " 6   RRGGBB:", "", "");
			if(strlen(inputtext) != 6)
			{
				SendClientMessage(playerid, 0xFF0000FF, "    6   RRGGBB!");
				return ShowPlayerDialog(playerid, 18, DIALOG_STYLE_INPUT, "  ", " 6   RRGGBB:", "", "");
			}
			format(GColor[PGang[playerid]], 10, "%sFF", inputtext);
			format(string, sizeof(string), "   : %s", GColor[PGang[playerid]]);
			SendClientMessage(playerid, 0xFFFFFFFF, string);
			new f[256];
			format(f, 256, "%i.ini", PGang[playerid]);
			new file = ini_openFile(f);
			if(file == INI_OK)
			{
				ini_setString(file, "Gang color", GColor[PGang[playerid]]);
				ini_closeFile(file);
			}
	    }
	}
	else if(dialogid == 6001)
	{
	    if(response)
	    {
	        format(string,sizeof(string), "%s   !", PlayerName(playerid));
	        for(new i; i<MAX_PLAYERS; i++)
	        {
				if(PGang[i] == PGang[playerid] && i != playerid)
				{
				 	SendClientMessage(i, 0xFFFF00, string);
				}
			}
			PGang[playerid] = 0;
			GangLvl[playerid] = 0;
	    }
	}
	else if(dialogid == 7001)
	{
	    if(response)
	    {
	        new Float:x, Float:y, Float:z;
			GetPlayerPos(playerid, x, y, z);
			GSpawnX[PGang[playerid]] = x;
			GSpawnY[PGang[playerid]] = y;
			GSpawnZ[PGang[playerid]] = z;
            new f[256];
			format(f, 256, "%i.ini", PGang[playerid]);
			new file = ini_openFile(f);
			if(file == INI_OK)
			{
			    ini_setFloat(file, "SpawnX", x);
			    ini_setFloat(file, "SpawnY", y);
			    ini_setFloat(file, "SpawnZ", z);
			    ini_closeFile(file);
			}
	    }
	}
	else if(dialogid == 8001)
	{
	    if(response)
	    {
			switch(listitem)
			{
	            case 0: gangskin[playerid] = 1;
	            case 1: gangskin[playerid] = 2;
	            case 2: gangskin[playerid] = 3;
		        case 3: gangskin[playerid] = 4;
	            case 4: gangskin[playerid] = 5;
	            case 5: gangskin[playerid] = 6;
			}
			ShowPlayerDialog(playerid, 8002, DIALOG_STYLE_INPUT, "  ", "   ID   0-299,   :", "", "");
	    }
	}
	else if(dialogid == 8002)
	{
	    if(response)
	    {
			if(!strlen(inputtext) && strval(inputtext) > 0) return ShowPlayerDialog(playerid, 20, DIALOG_STYLE_INPUT, "  ", "   ID   0-299,   :", "", "");
            new f[256];
			format(f, 256, "%i.ini", PGang[playerid]);
			new file = ini_openFile(f);
			if(file == INI_OK)
			{
				format(string, 256, "Skin%i", gangskin[playerid]);
			    ini_setInteger(file, string, strval(inputtext));
			    ini_closeFile(file);
				format(string, sizeof(string), "  ! ID : %i", strval(inputtext));
				SendClientMessage(playerid, 0xFFFF00FF, string);
				GSkin[PGang[playerid]][gangskin[playerid]-1] = strval(inputtext);
				for(new i; i<MAX_PLAYERS; i++)
				{
				    if(PGang[i] == PGang[playerid] && GangLvl[i] == gangskin[playerid])
				    {
				        SetPlayerSkin(i, strval(inputtext));
				    }
				}
				gangskin[playerid] = 0;
			}
	    }
	}
	else if(dialogid == 9001)
	{
	    if(response)
	    {
			if(!strlen(inputtext)) return ShowPlayerDialog(playerid, 21, DIALOG_STYLE_INPUT, " ", " id ,    :", "", "");
			if(PGang[strval(inputtext)] != PGang[playerid])
			{
			    SendClientMessage(playerid, 0xFFFF00FF, "    !");
			    return ShowPlayerDialog(playerid, 22, DIALOG_STYLE_INPUT, " ", " id ,    :", "", "");
			}
			id[playerid] = strval(inputtext);
			ShowPlayerDialog(playerid, 9002, DIALOG_STYLE_LIST, " ", "\n\n \n\n \n", "", "");
	    }
	}
	else if(dialogid == 9002)
	{
	    if(response)
	    {
	        switch(listitem)
			{
	            case 0: GangLvl[id[playerid]] = 1;
	            case 1: GangLvl[id[playerid]] = 2;
	            case 2: GangLvl[id[playerid]] = 3;
		        case 3: GangLvl[id[playerid]] = 4;
	            case 4: GangLvl[id[playerid]] = 5;
	            case 5: GangLvl[id[playerid]] = 6;
			}
			format(string, sizeof(string), "   %s  %i", PlayerName(id[playerid]), GangLvl[id[playerid]]);
			SendClientMessage(playerid, 0xFFFF00FF, string);
			format(string, sizeof(string), " %s    %i", PlayerName(playerid), GangLvl[id[playerid]]);
			SendClientMessage(id[playerid], 0xFFFF00FF, string);
			if(GSkin[PGang[playerid]][GangLvl[id[playerid]]] > 0) SetPlayerSkin(id[playerid], GSkin[PGang[playerid]][GangLvl[id[playerid]]-1]);
			id[playerid] = -1;
	    }
	}
	return true;
}

stock GetFreeGang()
{
	for(new i=1; i<MAX_GANGS; i++)
	{
		if(Gang[i] == 0) return i;
	}
	return false;
}

forward LoadAccount(playerid);
public LoadAccount(playerid)
{
    new f[256], hex[MAX_PLAYERS];
    format(f, 256, "%s.ini", PlayerName(playerid));
	new file = ini_openFile(f);
	if(file == INI_OK)
	{
	    ini_getInteger(file, "Score", Scores[playerid]);
	    ini_getInteger(file, "Gang", PGang[playerid]);
	    ini_getInteger(file, "GangLvl", GangLvl[playerid]);
	    if(PGang[playerid] > 0)
	    {
			hex[playerid] = HexToInt(GColor[PGang[playerid]]);
			SetPlayerColor(playerid, hex[playerid]);
		}
		ini_closeFile(file);
		return true;
	}
	else
	{
	    ini_closeFile(file);
	    file = ini_createFile(f);
	    ini_setInteger(file, "Score", 0);
	    ini_setInteger(file, "Gang", 0);
	    ini_setInteger(file, "GangLvl", 0);
		ini_closeFile(file);
		return true;
	}
}

forward SaveAccount(playerid);
public SaveAccount(playerid)
{
    new f[256];
    format(f, 256, "%s.ini", PlayerName(playerid));
	new file = ini_openFile(f);
	if(file == INI_OK)
	{
	    ini_setInteger(file, "Score", Scores[playerid]);
	    ini_setInteger(file, "Gang", PGang[playerid]);
	    ini_setInteger(file, "GangLvl", GangLvl[playerid]);
		ini_closeFile(file);
	}
	return true;
}

forward GangLoad();
public GangLoad()
{
    new file, f[256];
	for(new i; i<MAX_GANGS; i++)
	{
	    format(f, 256, "%i.ini", i);
		file = ini_openFile(f);
		if(file == INI_OK)
		{
		    ini_getString(file, "Gang name", name[i]);
		    format(GName[i], 256, name[i]);
		    ini_getString(file, "Gang color", col[i]);
		    format(GColor[i], 10, col[i]);
		    ini_getFloat(file, "SpawnX", GSpawnX[i]);
		    ini_getFloat(file, "SpawnY", GSpawnY[i]);
		    ini_getFloat(file, "SpawnZ", GSpawnZ[i]);
		    ini_getInteger(file, "Skin1", GSkin[i][0]);
		    ini_getInteger(file, "Skin2", GSkin[i][1]);
		    ini_getInteger(file, "Skin3", GSkin[i][2]);
		    ini_getInteger(file, "Skin4", GSkin[i][3]);
		    ini_getInteger(file, "Skin5", GSkin[i][4]);
		    ini_getInteger(file, "Skin6", GSkin[i][5]);
		    Gang[i] = 1;
			ini_closeFile(file);
		}
	}
	return false;
}

forward Spawn(playerid);
public Spawn(playerid)
{
    if(GSkin[PGang[playerid]][GangLvl[playerid]-1] > 0)
	{
 		SetPlayerSkin(playerid, GSkin[PGang[playerid]][GangLvl[playerid]-1]);
	}
	if(GSpawnX[PGang[playerid]] != 0.0 && GSpawnY[PGang[playerid]] != 0.0 && GSpawnZ[PGang[playerid]] != 0.0)
	{
		SetPlayerPos(playerid, GSpawnX[PGang[playerid]], GSpawnY[PGang[playerid]], GSpawnZ[PGang[playerid]]);
	}
}

stock strtok(const string[], &index)
{
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' '))
	{
		index++;
	}

	new offset = index;
	new result[20];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof(result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}
	result[index - offset] = EOS;
	return result;
}

stock PlayerName(playerid)
{
	new pname[MAX_PLAYER_NAME];
	GetPlayerName(playerid,pname,sizeof(pname));
	return pname;
}

stock HexToInt(string[]) {
  if (string[0]==0) return 0;
  new i;
  new cur=1;
  new res=0;
  for (i=strlen(string);i>0;i--) {
    if (string[i-1]<58) res=res+cur*(string[i-1]-48); else res=res+cur*(string[i-1]-65+10);
    cur=cur*16;
  }
  return res;
}
